/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigStreamProvider;
import com.intellij.cloudConfig.CloudConfigStreamProviderKt;
import com.intellij.cloudConfig.NetworkStatistics;
import com.intellij.cloudConfig.PluginState;
import com.intellij.cloudConfig.StatusBarInfoManager;
import com.intellij.cloudConfig.StatusInfo;
import com.intellij.concurrency.JobScheduler;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.StateStorageBaseKt;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.idea.cloudConfig.ETagCloudConfigFileClient;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import messages.CloudConfigBundle;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudConfigManager
implements ApplicationLoadListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cloudConfig.CloudConfigManager");
    private static final String LOCAL_DISABLED_PLUGINS_FILENAME = "local_disabled_plugins.txt";
    private static CloudConfigManager ourInstance;
    private File myIdeConfigPath;
    private File myConfigDir;
    private File myCachesDir;
    private File myFilesArchive;
    private File myUpdatesArchive;
    private File myStatusFile;
    private File myAutoUpdatePluginsFile;
    private StatusInfo myStatusInfo;
    private ETagCloudConfigFileClient myClient;
    private boolean myIOError;
    private boolean myIOOperation;
    private LocalChanges myLocalChanges;
    private final NetworkStatistics myNetworkStatistics = new NetworkStatistics();
    private StatusBarInfoManager myStatusBarManager;
    private FrameStateListener myFrameListener;
    private Runnable myDisablePluginsListener;
    private PluginStateListener myStatePluginListener;
    private List<Pair<IdeaPluginDescriptor, PluginState>> myEnabledDisabledPlugins = Collections.emptyList();
    private List<Pair<IdeaPluginDescriptor, PluginState>> myInstalledUninstalledPlugins = Collections.emptyList();
    private boolean myBeforeApplicationLoadedStart;
    private boolean mySavePluginsWithEditConfigs = true;
    private boolean myAutoUpdatePlugins;
    private ExecuteManager myExecuteManager;
    private static final Function2<Class, String, String> KEYMAP_CONVERTER;
    private static List<IdeaPluginDescriptor> myRepositoryPlugins;
    private static final String[] OS_NAMES;

    @NotNull
    public static CloudConfigManager getInstance() {
        CloudConfigManager cloudConfigManager = ourInstance;
        if (cloudConfigManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getInstance"));
        }
        return cloudConfigManager;
    }

    @NotNull
    public StatusInfo getStatusInfo() {
        if (this.myIOError) {
            StatusInfo statusInfo = StatusInfo.JBA_IO_ERROR;
            if (statusInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getStatusInfo"));
            }
            return statusInfo;
        }
        if (this.myIOOperation) {
            StatusInfo statusInfo = StatusInfo.JBA_IO_OPERATION;
            if (statusInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getStatusInfo"));
            }
            return statusInfo;
        }
        if (this.myStatusInfo != StatusInfo.OFFLINE && this.myStatusInfo != StatusInfo.JBA_CONNECTED && CloudConfigManager.isStreamProviderEnabled()) {
            StatusInfo statusInfo = StatusInfo.OFFLINE;
            if (statusInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getStatusInfo"));
            }
            return statusInfo;
        }
        StatusInfo statusInfo = this.myStatusInfo;
        if (statusInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getStatusInfo"));
        }
        return statusInfo;
    }

    public boolean isAutoUpdatePlugins() {
        return this.myAutoUpdatePlugins;
    }

    public void setAutoUpdatePlugins(boolean value) {
        boolean update = this.myAutoUpdatePlugins != value;
        this.myAutoUpdatePlugins = value;
        if (update) {
            this.storeAutoUpdatePlugins();
            if (value) {
                this.executePlugins();
            }
        }
    }

    @NotNull
    public List<Pair<IdeaPluginDescriptor, PluginState>> getEnabledDisabledPlugins() {
        List<Pair<IdeaPluginDescriptor, PluginState>> list = this.myEnabledDisabledPlugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getEnabledDisabledPlugins"));
        }
        return list;
    }

    @NotNull
    public List<Pair<IdeaPluginDescriptor, PluginState>> getInstalledUninstalledPlugins() {
        List<Pair<IdeaPluginDescriptor, PluginState>> list = this.myInstalledUninstalledPlugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getInstalledUninstalledPlugins"));
        }
        return list;
    }

    public boolean hasPluginsUpdate() {
        return !this.myEnabledDisabledPlugins.isEmpty() || !this.myInstalledUninstalledPlugins.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeApplicationLoaded(@NotNull Application application, @NotNull String configPath) {
        block21: {
            if (application == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/intellij/cloudConfig/CloudConfigManager", "beforeApplicationLoaded"));
            }
            if (configPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/cloudConfig/CloudConfigManager", "beforeApplicationLoaded"));
            }
            ourInstance = this;
            if (application.isUnitTestMode()) {
                this.myStatusBarManager = StatusBarInfoManager.EMPTY;
                this.myExecuteManager = new TestExecuteManager();
            } else {
                this.myStatusBarManager = new StatusBarInfoManager();
                this.myExecuteManager = new ExecuteManager();
            }
            if (!Boolean.getBoolean("use.jba.cloud.config") || CloudConfigManager.isStreamProviderEnabled()) {
                this.myStatusInfo = StatusInfo.OFFLINE;
                LOG.info("=== Offline: (" + System.getProperty("use.jba.cloud.config") + ") " + CloudConfigManager.isStreamProviderEnabled() + " ===");
                return;
            }
            this.myIdeConfigPath = new File(configPath);
            this.myConfigDir = new File(configPath, "jba_config");
            this.myCachesDir = new File(this.myConfigDir, "caches");
            this.myFilesArchive = new File(this.myCachesDir, "files.7z");
            this.myUpdatesArchive = new File(this.myCachesDir, "updates.7z");
            this.myStatusFile = new File(this.myConfigDir, "status.info");
            this.myAutoUpdatePluginsFile = new File(this.myConfigDir, "auto_update_plugins");
            this.myLocalChanges = new LocalChanges();
            try {
                this.myStatusInfo = StatusInfo.valueOf(FileUtil.loadFile((File)this.myStatusFile));
                if (this.myStatusInfo == StatusInfo.DISABLED) {
                    LOG.info("=== Exit: " + (Object)((Object)this.myStatusInfo) + " ===");
                    return;
                }
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
            try {
                this.myAutoUpdatePlugins = "1".equals(FileUtil.loadFile((File)this.myAutoUpdatePluginsFile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.myClient = CloudConfigClientUtil.createClient();
            if (this.myClient == null) {
                this.myStatusInfo = StatusInfo.JBA_NOT_FOUND;
                LOG.info("=== Exit: " + (Object)((Object)this.myStatusInfo) + " ===");
                return;
            }
            try {
                this.myBeforeApplicationLoadedStart = true;
                File autoConnect = new File(this.myConfigDir, ".auto_connect");
                if (autoConnect.exists()) {
                    boolean remote = false;
                    try {
                        remote = "remote".equals(FileUtil.loadFile((File)autoConnect));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    FileUtil.delete((File)autoConnect);
                    if (remote) {
                        this.connectThisInstance(false, true, null);
                    } else {
                        this.connectFirstInstance(true, null);
                    }
                    break block21;
                }
                if (this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
                    this.myLocalChanges.load();
                    this.updateConnection(true);
                } else {
                    this.updateInitStatus();
                }
            }
            finally {
                this.myBeforeApplicationLoadedStart = false;
            }
        }
        LOG.info("=== Start: " + (Object)((Object)this.myStatusInfo) + " ===");
    }

    public void recalculateInitStatus(@Nullable Project project) {
        LOG.info("=== Start.recalculateInitStatus ===");
        if (this.myStatusInfo == StatusInfo.DISABLED && this.myClient == null) {
            this.myStatusInfo = null;
            FileUtil.delete((File)this.myStatusFile);
            this.myClient = CloudConfigClientUtil.createClient();
            LOG.assertTrue(this.myClient != null);
        }
        if (this.myStatusInfo == null) {
            this.myIOOperation = true;
            this.updateStatusBar(true);
            this.myExecuteManager.runProcessWithProgressSynchronously(() -> {
                try {
                    this.calculateInitStatus();
                }
                catch (IOException e) {
                    CloudConfigManager.logInfo(e);
                }
            }, CloudConfigBundle.message("io.operation.message", new Object[0]), false, project);
            this.myIOOperation = false;
            this.updateStatusBar(false);
            LOG.info("=== End.recalculateInitStatus ===");
        }
    }

    private void calculateInitStatus() throws IOException {
        LOG.info("=== calculateInitStatus ===");
        this.myStatusInfo = this.listFiles("").contains("files.7z") ? StatusInfo.JBA_THIS_NOT_CONNECTED : StatusInfo.JBA_NOT_CONNECTED;
    }

    private void updateInitStatus() {
        LOG.info("=== Start.updateInitStatus ===");
        this.myIOOperation = true;
        this.updateStatusBar(true);
        this.myExecuteManager.executeOnPooledThread(() -> {
            try {
                this.calculateInitStatus();
            }
            catch (IOException e) {
                CloudConfigManager.logInfo(e);
            }
            this.myExecuteManager.invokeLater(() -> {
                this.myIOOperation = false;
                this.updateStatusBar(false);
                LOG.info("=== End.updateInitStatus ===");
            });
        });
    }

    public void updateIO() {
        LOG.info("=== Start.updateIO ===");
        this.myIOOperation = true;
        this.updateStatusBar(true);
        this.myExecuteManager.executeOnPooledThread(() -> {
            try {
                LOG.info("=== updateIO ===");
                try {
                    this.listFiles("io");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (this.myStatusInfo == null) {
                    this.calculateInitStatus();
                } else if (this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
                    this.doConnection();
                    return;
                }
            }
            catch (IOException e) {
                CloudConfigManager.logInfo(e);
            }
            this.myExecuteManager.invokeLater(() -> {
                this.myIOOperation = false;
                this.updateStatusBar(false);
                LOG.info("=== End.updateIO ===");
            });
        });
    }

    public void disable() {
        this.myLocalChanges.clean();
        this.myStatusInfo = StatusInfo.DISABLED;
        this.myIOError = false;
        this.myIOOperation = false;
        if (this.myClient != null) {
            this.myClient.clearTags();
            this.myClient = null;
        }
        this.storeState();
        this.updateStatusBar(false);
    }

    public void testDisconnect(boolean removeData) {
        this.removeListeners();
        this.doDisconnect(removeData, false);
        this.updateStatusBar(false);
    }

    public void disconnect(boolean removeData) {
        LOG.info("=== Start.disconnect ===");
        this.removeListeners();
        if (!removeData) {
            this.doDisconnect(false, true);
            this.updateStatusBar(false);
            LOG.info("=== End.disconnect ===");
            return;
        }
        this.myIOOperation = true;
        this.updateStatusBar(false);
        this.myExecuteManager.executeOnPooledThread(() -> {
            boolean[] success = new boolean[]{false};
            try {
                LOG.info("=== disconnect.delete_files ===");
                File delFile = new File(this.myConfigDir, ".del");
                FileUtil.createIfDoesntExist((File)delFile);
                this.writeFile(delFile);
                this.deleteFile("files.7z");
                this.deleteFile("updates.7z");
                success[0] = true;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            this.myExecuteManager.invokeLater(() -> {
                if (success[0]) {
                    this.doDisconnect(true, true);
                }
                this.myIOOperation = false;
                this.updateStatusBar(false);
                LOG.info("=== End.disconnect ===");
            });
        });
    }

    private void doDisconnect(boolean removeData, boolean reload) {
        try {
            LOG.info("=== doDisconnect ===");
            this.myInstalledUninstalledPlugins = Collections.emptyList();
            this.myEnabledDisabledPlugins = this.myInstalledUninstalledPlugins;
            this.myLocalChanges.clean();
            this.myStatusInfo = removeData ? StatusInfo.JBA_NOT_CONNECTED : StatusInfo.JBA_THIS_NOT_CONNECTED;
            this.myClient.clearTags();
            FileUtil.delete((File)this.myConfigDir);
            this.setStreamProvider(true, reload);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private ConnectionState getConnectionState() {
        block12: {
            block11: {
                Boolean newVersion;
                block10: {
                    ConnectionState connectionState;
                    try {
                        LOG.info("=== getConnectionState ===");
                        newVersion = this.getFile("files.7z");
                        if (newVersion != null) break block10;
                        connectionState = ConnectionState.DELETE;
                    }
                    catch (IOException e) {
                        CloudConfigManager.logInfo(e);
                        ConnectionState connectionState2 = ConnectionState.IO_ERROR;
                        if (connectionState2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getConnectionState"));
                        }
                        return connectionState2;
                    }
                    if (connectionState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getConnectionState"));
                    }
                    return connectionState;
                }
                if (!newVersion.booleanValue()) break block11;
                ConnectionState connectionState = ConnectionState.NEW;
                if (connectionState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getConnectionState"));
                }
                return connectionState;
            }
            if (this.getFile("updates.7z") != Boolean.TRUE) break block12;
            ConnectionState connectionState = ConnectionState.UPDATE;
            if (connectionState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getConnectionState"));
            }
            return connectionState;
        }
        ConnectionState connectionState = ConnectionState.OLD;
        if (connectionState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getConnectionState"));
        }
        return connectionState;
    }

    private void updateConnection(boolean init) {
        try {
            LOG.info("=== Start.updateConnection ===");
            if (init) {
                this.setStreamProvider(false, false);
            }
            this.myIOOperation = true;
            this.updateStatusBar(init);
            this.myExecuteManager.executeOnPooledThread(() -> this.doConnection());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void doConnection() {
        LOG.info("=== doConnect ===");
        ConnectionState state = this.getConnectionState();
        if (state == ConnectionState.NEW) {
            this.connectThisInstanceOperation(true, true, null);
            return;
        }
        this.myExecuteManager.invokeLater(() -> {
            if (state == ConnectionState.OLD) {
                if (this.handleUpdates()) {
                    return;
                }
            } else if (state == ConnectionState.UPDATE) {
                try {
                    this.updateFiles();
                    if (this.handleUpdates()) {
                        return;
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            } else if (state == ConnectionState.DELETE) {
                this.removeListeners();
                this.doDisconnect(false, true);
                this.myStatusInfo = StatusInfo.JBA_NOT_CONNECTED;
            }
            this.myIOOperation = false;
            this.updateStatusBar(false);
            LOG.info("=== End.connect ===");
        });
    }

    public void connectFirstInstance(boolean cleanup, @Nullable Runnable successRun) {
        try {
            LOG.info("=== Start.connectFirstInstance ===");
            FileUtil.delete((File)this.myConfigDir);
            FileUtil.createDirectory((File)this.myConfigDir);
            ApplicationManager.getApplication().saveSettings();
            this.myLocalChanges.clean();
            this.myClient.clearTags();
            Set<File> index = this.copyConfigs(KEYMAP_CONVERTER, LafManagerImpl.class, KeymapManagerImpl.class, EditorColorsManagerImpl.class);
            this.addPlugins(index);
            this.addToFile(index, "os", CloudConfigClientUtil.getOS());
            this.addToFile(index, "version", "0");
            this.myIOOperation = true;
            this.updateStatusBar(true);
            this.myExecuteManager.executeOnPooledThread(() -> {
                boolean[] success = new boolean[]{false};
                try {
                    LOG.info("=== connectFirstInstance.pushToServer ===");
                    this.pushToServer(index, cleanup);
                    success[0] = true;
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                this.myExecuteManager.invokeLater(() -> {
                    if (success[0]) {
                        try {
                            this.setConnected();
                            this.setStreamProvider(false, false);
                        }
                        catch (IOException e) {
                            success[0] = false;
                            LOG.error((Throwable)e);
                        }
                    }
                    this.myIOOperation = false;
                    this.updateStatusBar(false);
                    if (success[0] && successRun != null) {
                        successRun.run();
                    }
                    LOG.info("=== End.connectFirstInstance ===");
                });
            });
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void addToFile(@NotNull Set<File> index, @NotNull String name, @NotNull String content) throws IOException {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/cloudConfig/CloudConfigManager", "addToFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "addToFile"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/cloudConfig/CloudConfigManager", "addToFile"));
        }
        File file = new File(this.myConfigDir, name);
        FileUtil.writeToFile((File)file, (String)content);
        index.add(file);
    }

    private void initListeners() {
        if (this.myFrameListener == null) {
            this.myFrameListener = new FrameStateListener(){
                long time;

                public void onFrameDeactivated() {
                    this.time = System.currentTimeMillis();
                }

                public void onFrameActivated() {
                    if (CloudConfigManager.this.myIOOperation || !CloudConfigManager.this.myStatusInfo.in(StatusInfo.JBA_NOT_CONNECTED, StatusInfo.JBA_CONNECTED)) {
                        return;
                    }
                    if (!Boolean.getBoolean("no_delay.jba.cloud.config") && System.currentTimeMillis() - this.time < 3600000L) {
                        return;
                    }
                    if (CloudConfigManager.this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
                        CloudConfigManager.this.updateConnection(false);
                    } else {
                        CloudConfigManager.this.updateInitStatus();
                    }
                }
            };
            FrameStateManager.getInstance().addListener(this.myFrameListener);
        }
        if (this.myDisablePluginsListener == null) {
            this.myDisablePluginsListener = () -> this.handleDisablePlugins();
            PluginManagerCore.addDisablePluginListener((Runnable)this.myDisablePluginsListener);
        }
        if (this.myStatePluginListener == null) {
            this.myStatePluginListener = new PluginStateListener(){

                public void install(@NotNull IdeaPluginDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/cloudConfig/CloudConfigManager$2", "install"));
                    }
                    CloudConfigManager.this.installPlugin(descriptor);
                }

                public void uninstall(@NotNull IdeaPluginDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/cloudConfig/CloudConfigManager$2", "uninstall"));
                    }
                    CloudConfigManager.this.uninstallPlugin(descriptor);
                }
            };
            PluginInstaller.addStateListener((PluginStateListener)this.myStatePluginListener);
        }
    }

    private void handleDisablePlugins() {
        try {
            boolean result;
            LOG.info("=== Start.DisablePluginHandler ===");
            File localFile = this.getLocalDisabledPluginsFile();
            LinkedHashSet oldPlugins = new LinkedHashSet(FileUtil.loadLines((File)localFile));
            File sourceFile = this.getDisabledPluginsFile();
            LinkedHashSet newPlugins = new LinkedHashSet(FileUtil.loadLines((File)sourceFile));
            Iterator I = newPlugins.iterator();
            while (I.hasNext()) {
                if (!oldPlugins.remove(I.next())) continue;
                I.remove();
            }
            if (oldPlugins.isEmpty() && newPlugins.isEmpty()) {
                return;
            }
            FileUtil.copyContent((File)sourceFile, (File)localFile);
            List<String> plugins = this.loadPlugins("disabled_plugins.txt");
            boolean update = false;
            for (String deletedPluginId : oldPlugins) {
                result = CloudConfigManager.removePlugin(plugins, deletedPluginId);
                update |= result;
                LOG.info("=== DisablePluginHandler.Remove: " + deletedPluginId + " (" + result + ") ===");
            }
            for (String newPluginId : newPlugins) {
                result = CloudConfigManager.addPlugin(plugins, newPluginId);
                update |= result;
                LOG.info("=== DisablePluginHandler.Add: " + newPluginId + " (" + result + ") ===");
            }
            if (update) {
                this.savePlugins(plugins, "disabled_plugins.txt");
            }
            LOG.info("=== End.DisablePluginHandler ===");
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void installPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/cloudConfig/CloudConfigManager", "installPlugin"));
        }
        try {
            LOG.info("=== InstallPlugin: " + descriptor + " ===");
            if (descriptor.isBundled()) {
                return;
            }
            String pluginId = descriptor.getPluginId().getIdString();
            if (ContainerUtil.find(CloudConfigManager.getRepositoryPlugins(), remote -> remote.getPluginId().getIdString().equals(pluginId)) == null) {
                return;
            }
            List<String> plugins = this.loadPlugins("installed_plugins.txt");
            if (CloudConfigManager.addPlugin(plugins, pluginId)) {
                LOG.info("=== InstallPlugin.Add: " + descriptor + " ===");
                this.savePlugins(plugins, "installed_plugins.txt");
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void uninstallPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/cloudConfig/CloudConfigManager", "uninstallPlugin"));
        }
        try {
            LOG.info("=== UninstallPlugin: " + descriptor + " ===");
            List<String> plugins = this.loadPlugins("installed_plugins.txt");
            if (CloudConfigManager.removePlugin(plugins, descriptor.getPluginId().getIdString())) {
                LOG.info("=== UninstallPlugin.Remove: " + descriptor + " ===");
                this.savePlugins(plugins, "installed_plugins.txt");
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private List<String> loadPlugins(String name) throws IOException {
        List list;
        try {
            list = FileUtil.loadLines((File)new File(this.myConfigDir, name));
        }
        catch (FileNotFoundException e) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "loadPlugins"));
            }
            return arrayList;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "loadPlugins"));
        }
        return list;
    }

    private void savePlugins(@NotNull List<String> plugins, @NotNull String name) throws IOException {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "savePlugins"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "savePlugins"));
        }
        this.savePluginsToFile(plugins, name);
        if (this.mySavePluginsWithEditConfigs) {
            this.editConfigFiles(name);
        }
    }

    private void savePluginsToFile(@NotNull List<String> plugins, @NotNull String name) throws IOException {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "savePluginsToFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "savePluginsToFile"));
        }
        FileUtil.writeToFile((File)new File(this.myConfigDir, name), (String)StringUtil.join(plugins, (String)"\n"));
    }

    private static boolean addPlugin(@NotNull List<String> plugins, @NotNull String pluginId) {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "addPlugin"));
        }
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/cloudConfig/CloudConfigManager", "addPlugin"));
        }
        int index = plugins.indexOf(pluginId);
        if (index == -1) {
            plugins.add(pluginId);
            return true;
        }
        return false;
    }

    private static boolean removePlugin(@NotNull List<String> plugins, @NotNull String pluginId) {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "removePlugin"));
        }
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/cloudConfig/CloudConfigManager", "removePlugin"));
        }
        int index = plugins.indexOf(pluginId);
        if (index != -1) {
            plugins.remove(index);
            return true;
        }
        return false;
    }

    private void removeListeners() {
        if (this.myFrameListener != null) {
            FrameStateManager.getInstance().removeListener(this.myFrameListener);
            this.myFrameListener = null;
        }
        if (this.myDisablePluginsListener != null) {
            PluginManagerCore.removeDisablePluginListener((Runnable)this.myDisablePluginsListener);
            this.myDisablePluginsListener = null;
        }
        if (this.myStatePluginListener != null) {
            PluginInstaller.removeStateListener((PluginStateListener)this.myStatePluginListener);
            this.myStatePluginListener = null;
        }
    }

    public void connectThisInstance(boolean reload, boolean saveCaches, @Nullable Runnable successRun) {
        this.myIOOperation = true;
        this.updateStatusBar(true);
        this.myExecuteManager.executeOnPooledThread(() -> this.connectThisInstanceOperation(reload, saveCaches, successRun));
    }

    private void connectThisInstanceOperation(boolean reload, boolean saveCaches, @Nullable Runnable successRun) {
        LOG.info("=== connectThisInstanceOperation ===");
        boolean[] success = new boolean[]{false};
        try {
            this.myExecuteManager.invokeAndWait(() -> {
                if (saveCaches) {
                    File[] files = this.myConfigDir.listFiles();
                    LOG.assertTrue(files != null);
                    for (File file : files) {
                        if ("caches".equals(file.getName())) continue;
                        FileUtil.delete((File)file);
                    }
                } else {
                    FileUtil.delete((File)this.myConfigDir);
                    FileUtil.createDirectory((File)this.myConfigDir);
                }
                this.myLocalChanges.clean();
            });
            LOG.assertTrue(this.getFile("files.7z") != null);
            CloudConfigManager.extractArchive(this.myFilesArchive, this.myConfigDir, false);
            if (this.getFile("updates.7z") != null) {
                CloudConfigManager.extractArchive(this.myUpdatesArchive, this.myConfigDir, true);
            }
            boolean[] write = new boolean[]{false};
            this.myExecuteManager.invokeAndWait(() -> {
                try {
                    File osFile = new File(this.myConfigDir, "os");
                    LOG.assertTrue(osFile.exists());
                    List osNames = FileUtil.loadLines((File)osFile);
                    String os = CloudConfigClientUtil.getOS();
                    ApplicationManager.getApplication().saveSettings();
                    LinkedHashSet<File> index = new LinkedHashSet<File>();
                    if (!osNames.contains(os)) {
                        index.addAll(this.copyConfigs(KEYMAP_CONVERTER, KeymapManagerImpl.class));
                        osNames.add(os);
                        this.addToFile(index, "os", StringUtil.join((Collection)osNames, (String)"\n"));
                    }
                    FileUtil.copyContent((File)this.getDisabledPluginsFile(), (File)this.getLocalDisabledPluginsFile());
                    if (!index.isEmpty()) {
                        this.createUpdates(index);
                        write[0] = true;
                    }
                    success[0] = true;
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            });
            if (write[0]) {
                this.writeUpdates();
            }
        }
        catch (IOException e) {
            success[0] = false;
            LOG.error((Throwable)e);
        }
        this.myExecuteManager.invokeLater(() -> {
            if (success[0]) {
                try {
                    this.setConnected();
                    this.setStreamProvider(false, reload);
                }
                catch (IOException e) {
                    success[0] = false;
                    LOG.error((Throwable)e);
                }
            }
            if (!success[0] || !this.handleUpdates()) {
                this.myIOOperation = false;
                this.updateStatusBar(false);
            }
            if (success[0] && successRun != null) {
                successRun.run();
            }
            LOG.info("=== End.connectThisInstanceOperation ===");
        });
    }

    private boolean handleUpdates() {
        try {
            File newUpdates = new File(this.myConfigDir, "new.updates");
            Set<File> index = this.myLocalChanges.getFiles();
            if (!index.isEmpty()) {
                LOG.info("=== End.Update: " + index + " ===");
                this.createUpdates(index);
                this.myLocalChanges.clean();
                FileUtil.createIfDoesntExist((File)newUpdates);
            }
            if (newUpdates.exists()) {
                this.myExecuteManager.executeOnPooledThread(() -> {
                    boolean[] write = new boolean[]{false};
                    try {
                        this.writeUpdates();
                        write[0] = true;
                    }
                    catch (IOException e) {
                        CloudConfigManager.logInfo(e);
                    }
                    this.myExecuteManager.invokeLater(() -> {
                        if (write[0]) {
                            FileUtil.delete((File)newUpdates);
                        }
                        this.myIOOperation = false;
                        this.updateStatusBar(false);
                    });
                });
                return true;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    private void createUpdates(@NotNull Set<File> index) throws IOException {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/cloudConfig/CloudConfigManager", "createUpdates"));
        }
        this.addToFile(index, "version", CloudConfigManager.plusOne(FileUtil.loadFile((File)new File(this.myConfigDir, "version"))));
        String configPrefix = this.myConfigDir.getAbsolutePath();
        if (this.myUpdatesArchive.exists()) {
            File temp = new File(this.myCachesDir, "temp");
            FileUtil.delete((File)temp);
            CloudConfigManager.extractArchive(this.myUpdatesArchive, temp, false);
            int configPrefixLength = configPrefix.length();
            Set newUpdate = ContainerUtil.map2Set(index, file -> {
                String path = file.getAbsolutePath();
                assert (path.startsWith(configPrefix));
                return path.substring(configPrefixLength);
            });
            LinkedHashSet<File> oldUpdate = new LinkedHashSet<File>();
            String oldUpdatePrefix = temp.getAbsolutePath();
            CloudConfigManager.collectFiles(temp, oldUpdatePrefix, oldUpdate, newUpdate);
            try (SevenZOutputFile archive = new SevenZOutputFile(this.myUpdatesArchive);){
                CloudConfigManager.addToArchive(archive, oldUpdate, oldUpdatePrefix);
                CloudConfigManager.addToArchive(archive, index, configPrefix);
            }
            FileUtil.delete((File)temp);
        } else {
            CloudConfigManager.createArchive(index, this.myUpdatesArchive, configPrefix);
        }
    }

    private void writeUpdates() throws IOException {
        this.writeFile(this.myUpdatesArchive);
    }

    private static void collectFiles(@NotNull File dir, @NotNull String prefix, @NotNull Set<File> result, @NotNull Set<String> excludes) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/cloudConfig/CloudConfigManager", "collectFiles"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/cloudConfig/CloudConfigManager", "collectFiles"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/cloudConfig/CloudConfigManager", "collectFiles"));
        }
        if (excludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludes", "com/intellij/cloudConfig/CloudConfigManager", "collectFiles"));
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int prefixLength = prefix.length();
        for (File file : files) {
            if (file.isDirectory()) {
                CloudConfigManager.collectFiles(file, prefix, result, excludes);
                continue;
            }
            String path = file.getAbsolutePath();
            assert (path.startsWith(prefix));
            String name = path.substring(prefixLength);
            if (excludes.contains(name)) continue;
            result.add(file);
        }
    }

    @NotNull
    private Set<File> copyConfigs(@NotNull Function2<Class, String, String> nameConverter, Class ... storageClasses) throws IOException {
        if (nameConverter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameConverter", "com/intellij/cloudConfig/CloudConfigManager", "copyConfigs"));
        }
        if (storageClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageClasses", "com/intellij/cloudConfig/CloudConfigManager", "copyConfigs"));
        }
        LinkedHashSet<File> index = new LinkedHashSet<File>();
        File optionsDir = new File(this.myIdeConfigPath, "options");
        for (Class storageClass : storageClasses) {
            File dir;
            String schemeDir;
            State spec = StoreUtil.getStateSpec((Class)storageClass);
            LOG.assertTrue(spec != null);
            String inputName = CloudConfigStreamProviderKt.getFileConfig(spec);
            File inputFile = new File(optionsDir, inputName);
            if (inputFile.exists() && inputFile.isFile()) {
                String outName = (String)nameConverter.invoke((Object)storageClass, (Object)inputName);
                File outFile = new File(this.myConfigDir, outName);
                FileUtil.copyContent((File)inputFile, (File)outFile);
                index.add(outFile);
            }
            if ((schemeDir = spec.additionalExportFile()).isEmpty() || !(dir = new File(this.myIdeConfigPath, schemeDir)).exists() || !dir.isDirectory()) continue;
            SchemeManagerImpl scheme = CloudConfigManager.findScheme(schemeDir);
            String schemeOutDir = (String)nameConverter.invoke((Object)storageClass, (Object)schemeDir);
            FileUtil.copyDir((File)dir, (File)new File(this.myConfigDir, schemeOutDir), childFile -> {
                String childName = childFile.getName();
                boolean canRead = scheme.canRead((CharSequence)childName);
                if (canRead) {
                    index.add(new File(this.myConfigDir, schemeOutDir + File.separator + childName));
                }
                return canRead;
            });
        }
        LinkedHashSet<File> linkedHashSet = index;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "copyConfigs"));
        }
        return linkedHashSet;
    }

    private void addPlugins(@NotNull Set<File> index) throws IOException {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/cloudConfig/CloudConfigManager", "addPlugins"));
        }
        String content = FileUtil.loadFile((File)this.getDisabledPluginsFile());
        FileUtil.writeToFile((File)this.getLocalDisabledPluginsFile(), (String)content);
        File file = new File(this.myConfigDir, "disabled_plugins.txt");
        FileUtil.writeToFile((File)file, (String)content);
        index.add(file);
        this.addToFile(index, "installed_plugins.txt", StringUtil.join(CloudConfigManager.getInstalledPlugins(), (String)"\n"));
    }

    @NotNull
    private static List<IdeaPluginDescriptor> getInstalledPlugins() throws IOException {
        List<IdeaPluginDescriptor> plugins = new ArrayList();
        ContainerUtil.addAll(plugins, (Object[])PluginManagerCore.getPlugins());
        plugins.addAll(InstalledPluginsState.getInstance().getInstalledPlugins());
        plugins = ContainerUtil.filter(plugins, descriptor -> {
            if (descriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)descriptor).isDeleted()) {
                return false;
            }
            return !descriptor.isBundled();
        });
        if (!plugins.isEmpty()) {
            List<IdeaPluginDescriptor> repositoryPlugins = CloudConfigManager.getRepositoryPlugins();
            plugins = ContainerUtil.filter(plugins, local -> {
                PluginId id = local.getPluginId();
                return ContainerUtil.find((Iterable)repositoryPlugins, remote -> remote.getPluginId().compareTo(id) == 0) != null;
            });
        }
        List<IdeaPluginDescriptor> list = plugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getInstalledPlugins"));
        }
        return list;
    }

    @NotNull
    private static List<IdeaPluginDescriptor> getRepositoryPlugins() {
        if (myRepositoryPlugins == null) {
            try {
                myRepositoryPlugins = (List)ApplicationManager.getApplication().executeOnPooledThread(() -> RepositoryHelper.loadPlugins(null)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                CloudConfigManager.logInfo(e);
            }
        }
        List<Object> list = myRepositoryPlugins == null ? Collections.emptyList() : myRepositoryPlugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getRepositoryPlugins"));
        }
        return list;
    }

    private void updatePluginsLaterIfNeeded(@Nullable Set<String> changedFiles) throws IOException {
        if (this.myBeforeApplicationLoadedStart) {
            ApplicationManager.getApplication().invokeLater(() -> this.safeUpdatePlugins(changedFiles, true));
        } else {
            this.updatePlugins(changedFiles, true);
        }
    }

    private void safeUpdatePlugins(@Nullable Set<String> changedFiles, boolean autoUpdatePlugins) {
        try {
            this.updatePlugins(changedFiles, autoUpdatePlugins);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void manualUpdatePlugins() {
        this.safeUpdatePlugins(null, false);
    }

    private void updatePlugins(@Nullable Set<String> changedFiles, boolean autoUpdatePlugins) throws IOException {
        LinkedHashSet<String> oldPlugins;
        boolean checkDisabled = true;
        boolean checkInstalled = true;
        if (changedFiles != null) {
            if (changedFiles.isEmpty()) {
                return;
            }
            checkDisabled = changedFiles.contains("disabled_plugins.txt");
            checkInstalled = changedFiles.contains("installed_plugins.txt");
            if (!checkDisabled && !checkInstalled) {
                return;
            }
        }
        Map plugins = ContainerUtil.map2Map((Object[])PluginManagerCore.getPlugins(), descriptor -> Pair.create((Object)descriptor.getPluginId().getIdString(), (Object)descriptor));
        if (checkDisabled) {
            this.myEnabledDisabledPlugins = new ArrayList<Pair<IdeaPluginDescriptor, PluginState>>();
            oldPlugins = new LinkedHashSet(FileUtil.loadLines((File)this.getDisabledPluginsFile()));
            this.mergePlugins(this.myEnabledDisabledPlugins, plugins, oldPlugins, PluginState.Enable, "disabled_plugins.txt", PluginState.Disable);
        }
        if (checkInstalled) {
            this.myInstalledUninstalledPlugins = new ArrayList<Pair<IdeaPluginDescriptor, PluginState>>();
            oldPlugins = new LinkedHashSet<String>();
            for (IdeaPluginDescriptor descriptor2 : CloudConfigManager.getInstalledPlugins()) {
                oldPlugins.add(descriptor2.getPluginId().getIdString());
            }
            this.mergePlugins(this.myInstalledUninstalledPlugins, plugins, oldPlugins, PluginState.Uninstall, "installed_plugins.txt", PluginState.Install);
        }
        this.updateStatusBar(false);
        if (autoUpdatePlugins && this.myAutoUpdatePlugins) {
            this.executePlugins();
        }
    }

    private void mergePlugins(@NotNull List<Pair<IdeaPluginDescriptor, PluginState>> result, @NotNull Map<String, IdeaPluginDescriptor> plugins, @NotNull Set<String> oldPlugins, @NotNull PluginState oldState, @NotNull String newPluginsName, @NotNull PluginState newState) throws IOException {
        IdeaPluginDescriptor descriptor;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/cloudConfig/CloudConfigManager", "mergePlugins"));
        }
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "mergePlugins"));
        }
        if (oldPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldPlugins", "com/intellij/cloudConfig/CloudConfigManager", "mergePlugins"));
        }
        if (oldState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldState", "com/intellij/cloudConfig/CloudConfigManager", "mergePlugins"));
        }
        if (newPluginsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPluginsName", "com/intellij/cloudConfig/CloudConfigManager", "mergePlugins"));
        }
        if (newState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newState", "com/intellij/cloudConfig/CloudConfigManager", "mergePlugins"));
        }
        LinkedHashSet<String> newPlugins = new LinkedHashSet<String>(this.loadPlugins(newPluginsName));
        Iterator I = newPlugins.iterator();
        while (I.hasNext()) {
            if (!oldPlugins.remove(I.next())) continue;
            I.remove();
        }
        for (String pluginId : oldPlugins) {
            descriptor = plugins.get(pluginId);
            if (descriptor == null) continue;
            result.add((Pair<IdeaPluginDescriptor, PluginState>)Pair.create((Object)descriptor, (Object)((Object)oldState)));
        }
        for (String pluginId : newPlugins) {
            descriptor = plugins.get(pluginId);
            if (descriptor == null) continue;
            result.add((Pair<IdeaPluginDescriptor, PluginState>)Pair.create((Object)descriptor, (Object)((Object)newState)));
        }
    }

    public void executePlugins() {
        ArrayList<Pair<IdeaPluginDescriptor, PluginState>> executeList = new ArrayList<Pair<IdeaPluginDescriptor, PluginState>>(this.myEnabledDisabledPlugins);
        executeList.addAll(this.myInstalledUninstalledPlugins);
        this.executePlugins(executeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executePlugins(@NotNull List<Pair<IdeaPluginDescriptor, PluginState>> executeList) {
        if (executeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executeList", "com/intellij/cloudConfig/CloudConfigManager", "executePlugins"));
        }
        if (executeList.isEmpty()) {
            return;
        }
        final ArrayList<IdeaPluginDescriptor> installList = new ArrayList<IdeaPluginDescriptor>();
        final boolean[] states = new boolean[]{false, false, false};
        try {
            this.mySavePluginsWithEditConfigs = false;
            for (Pair<IdeaPluginDescriptor, PluginState> info : executeList) {
                IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)info.first;
                PluginState state = (PluginState)((Object)info.second);
                if (state == PluginState.Install) {
                    installList.add(descriptor);
                    continue;
                }
                if (state == PluginState.Uninstall) {
                    try {
                        assert (descriptor instanceof IdeaPluginDescriptorImpl);
                        ((IdeaPluginDescriptorImpl)descriptor).setDeleted(true);
                        PluginInstaller.prepareToUninstall((PluginId)descriptor.getPluginId());
                        states[1] = true;
                    }
                    catch (IOException e) {
                        PluginManagerMain.LOG.error((Throwable)e);
                    }
                    continue;
                }
                if (state == PluginState.Disable) {
                    PluginManagerCore.disablePlugin((String)descriptor.getPluginId().getIdString());
                    states[0] = true;
                    continue;
                }
                PluginManagerCore.enablePlugin((String)descriptor.getPluginId().getIdString());
                states[0] = true;
            }
        }
        finally {
            this.mySavePluginsWithEditConfigs = true;
        }
        if (installList.isEmpty()) {
            this.editConfigFiles("disabled_plugins.txt");
            this.manualUpdatePlugins();
            PluginManagerConfigurable.shutdownOrRestartApp();
        } else {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Download JBA Cloud Shared Plugins"){
                final List<PluginDownloader> myDownloaders;
                boolean mySuccess;
                {
                    super(arg0, arg1);
                    this.myDownloaders = new ArrayList<PluginDownloader>();
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/cloudConfig/CloudConfigManager$3", "run"));
                    }
                    for (IdeaPluginDescriptor descriptor : installList) {
                        try {
                            PluginDownloader downloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)descriptor);
                            if (!downloader.prepareToInstall(indicator)) continue;
                            this.myDownloaders.add(downloader);
                        }
                        catch (IOException e) {
                            PluginManagerMain.LOG.error((Throwable)e);
                        }
                    }
                }

                public void onSuccess() {
                    this.mySuccess = true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFinished() {
                    if (this.mySuccess) {
                        try {
                            CloudConfigManager.this.mySavePluginsWithEditConfigs = false;
                            for (PluginDownloader downloader : this.myDownloaders) {
                                try {
                                    downloader.install();
                                    states[2] = true;
                                }
                                catch (IOException e) {
                                    PluginManagerMain.LOG.error((Throwable)e);
                                }
                            }
                        }
                        finally {
                            CloudConfigManager.this.mySavePluginsWithEditConfigs = true;
                        }
                    }
                    if (!(states[0] || states[1] || states[2])) {
                        CloudConfigManager.this.manualUpdatePlugins();
                    } else {
                        if (states[0] && !states[1] && !states[2]) {
                            CloudConfigManager.this.editConfigFiles("disabled_plugins.txt");
                        } else if (!states[0] && (states[1] || states[2])) {
                            CloudConfigManager.this.editConfigFiles("installed_plugins.txt");
                        } else {
                            CloudConfigManager.this.editConfigFiles("disabled_plugins.txt", "installed_plugins.txt");
                        }
                        CloudConfigManager.this.manualUpdatePlugins();
                        PluginManagerConfigurable.shutdownOrRestartApp();
                    }
                }
            });
        }
    }

    @NotNull
    private static SchemeManagerImpl findScheme(final @NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/cloudConfig/CloudConfigManager", "findScheme"));
        }
        final Ref result = new Ref();
        ((SchemeManagerFactoryBase)SchemeManagerFactory.getInstance()).process((Function1)new Function1<SchemeManagerImpl<Scheme, ? extends Scheme>, Unit>(){

            public Unit invoke(SchemeManagerImpl<Scheme, ? extends Scheme> manager) {
                if (result.isNull() && fileSpec.equals(manager.getFileSpec())) {
                    result.set(manager);
                }
                return null;
            }
        });
        SchemeManagerImpl schemeManagerImpl = (SchemeManagerImpl)result.get();
        if (schemeManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "findScheme"));
        }
        return schemeManagerImpl;
    }

    private void pushToServer(@NotNull Set<File> index, boolean cleanup) throws IOException {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/cloudConfig/CloudConfigManager", "pushToServer"));
        }
        if (cleanup) {
            this.deleteFile("updates.7z");
            this.deleteFile(".del");
        }
        CloudConfigManager.createArchive(index, this.myFilesArchive, this.myConfigDir.getAbsolutePath());
        this.writeFile(this.myFilesArchive);
    }

    private void setConnected() throws IOException {
        this.myStatusInfo = StatusInfo.JBA_CONNECTED;
        this.storeStateIO();
        this.storeAutoUpdatePlugins();
    }

    private void updateStatusBar(boolean create) {
        if (this.myBeforeApplicationLoadedStart) {
            ApplicationManager.getApplication().invokeLater(() -> this.myStatusBarManager.update(create));
        } else {
            this.myStatusBarManager.update(create);
        }
    }

    public void editConfigFiles(String ... fileNames) {
        if (fileNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNames", "com/intellij/cloudConfig/CloudConfigManager", "editConfigFiles"));
        }
        try {
            LOG.info("=== Start.Edit: " + Arrays.toString(fileNames) + " |" + this.myIOOperation + "| ===");
            this.myLocalChanges.addFiles(fileNames);
            if (this.myIOOperation) {
                return;
            }
            this.myIOOperation = true;
            this.updateStatusBar(false);
            this.myExecuteManager.schedule(() -> this.doConnection(), 1L, TimeUnit.SECONDS);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private static String plusOne(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/CloudConfigManager", "plusOne"));
        }
        String string = Integer.toString(Integer.parseInt(value) + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "plusOne"));
        }
        return string;
    }

    private void storeState() {
        try {
            this.storeStateIO();
        }
        catch (IOException e) {
            CloudConfigManager.logInfo(e);
        }
    }

    private void storeStateIO() throws IOException {
        FileUtil.writeToFile((File)this.myStatusFile, (String)this.myStatusInfo.name());
    }

    private void storeAutoUpdatePlugins() {
        try {
            FileUtil.writeToFile((File)this.myAutoUpdatePluginsFile, (String)(this.myAutoUpdatePlugins ? "1" : "0"));
        }
        catch (IOException e) {
            CloudConfigManager.logInfo(e);
        }
    }

    private void setStreamProvider(boolean noProvider, boolean reload) throws IOException {
        CloudConfigStreamProvider streamProvider = noProvider ? null : new CloudConfigStreamProvider(this.myConfigDir, this);
        CloudConfigManager.getStateStorageManager().setStreamProvider((StreamProvider)streamProvider);
        if (!noProvider) {
            this.initListeners();
        }
        if (reload) {
            File optionsDir = noProvider ? new File(this.myIdeConfigPath, "options") : this.myConfigDir;
            CloudConfigManager.reloadComponents(optionsDir, !noProvider, null, KeymapManagerImpl.class, EditorColorsManagerImpl.class, LafManagerImpl.class);
        }
        if (noProvider) {
            this.myInstalledUninstalledPlugins = Collections.emptyList();
            this.myEnabledDisabledPlugins = this.myInstalledUninstalledPlugins;
        } else {
            this.updatePluginsLaterIfNeeded(null);
        }
    }

    private void updateFiles() throws IOException {
        LOG.info("=== Update Files ===");
        HashSet<String> changedFiles = new HashSet<String>();
        CloudConfigManager.extractArchive(this.myUpdatesArchive, this.myConfigDir, changedFiles);
        this.myLocalChanges.removeFiles(changedFiles);
        if (!changedFiles.isEmpty()) {
            CloudConfigManager.reloadComponents(this.myConfigDir, true, changedFiles, KeymapManagerImpl.class, EditorColorsManagerImpl.class, LafManagerImpl.class);
        }
        this.updatePluginsLaterIfNeeded(changedFiles);
    }

    private static void reloadComponents(@NotNull File optionsDir, boolean streamProvider, @Nullable Set<String> changedFiles, Class ... storageClasses) {
        if (optionsDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsDir", "com/intellij/cloudConfig/CloudConfigManager", "reloadComponents"));
        }
        if (storageClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageClasses", "com/intellij/cloudConfig/CloudConfigManager", "reloadComponents"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final LinkedHashSet<String> componentNames = new LinkedHashSet<String>();
        final HashSet<StateStorage> changedStorages = new HashSet<StateStorage>();
        ArrayList<SchemeManagerImpl> schemes = new ArrayList<SchemeManagerImpl>();
        StateStorageManagerImpl storageManager = CloudConfigManager.getStateStorageManager();
        for (Class storageClass : storageClasses) {
            State spec = StoreUtil.getStateSpec((Class)storageClass);
            LOG.assertTrue(spec != null);
            boolean addComponent = false;
            String schemeDir = spec.additionalExportFile();
            if (schemeDir.length() > 0 && (changedFiles == null || changedFiles.contains(schemeDir))) {
                schemes.add(CloudConfigManager.findScheme(schemeDir));
                addComponent = true;
            }
            String name = CloudConfigStreamProviderKt.getFileConfig(spec);
            boolean exists = new File(optionsDir, name).exists();
            StateStorage storage = storageManager.findCachedFileStorage(name);
            LOG.assertTrue(storage instanceof XmlElementStorage);
            changedStorages.add(storage);
            ((XmlElementStorage)storage).updatedFrom(componentNames, !exists, streamProvider);
            if (!addComponent && changedFiles != null && !changedFiles.contains(name)) continue;
            componentNames.add(spec.name());
        }
        for (SchemeManagerImpl scheme : schemes) {
            scheme.reload();
        }
        Application application = ApplicationManager.getApplication();
        final ComponentStoreImpl store = (ComponentStoreImpl)ServiceKt.getStateStore((ComponentManager)application);
        final Collection notReloadableComponents = store.getNotReloadableComponents(componentNames);
        LOG.assertTrue(notReloadableComponents.isEmpty());
        StateStorageBaseKt.runBatchUpdate((MessageBus)application.getMessageBus(), (Function0)new Function0<Object>(){

            public Object invoke() {
                store.reinitComponents(componentNames, changedStorages, notReloadableComponents);
                return null;
            }
        });
        if (UIUtil.isUnderDarcula()) {
            DarculaInstaller.install();
        } else {
            DarculaInstaller.uninstall();
        }
        ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
        LOG.info("=== Reload components: " + componentNames + " ===");
    }

    private static boolean isStreamProviderEnabled() {
        StreamProvider provider = CloudConfigManager.getStateStorageManager().getStreamProvider();
        return provider != null && provider.getEnabled();
    }

    @NotNull
    public static StateStorageManagerImpl getStateStorageManager() {
        StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).getStateStorageManager();
        if (stateStorageManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getStateStorageManager"));
        }
        return stateStorageManagerImpl;
    }

    private static boolean filterOsName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/cloudConfig/CloudConfigManager", "filterOsName"));
        }
        if (!fileName.startsWith(CloudConfigClientUtil.getOS() + ".")) {
            for (String name : OS_NAMES) {
                if (!fileName.startsWith(name + ".")) continue;
                return false;
            }
        }
        return true;
    }

    public static void createArchive(@NotNull Set<File> files, @NotNull File outFile, @NotNull String prefix) throws IOException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/cloudConfig/CloudConfigManager", "createArchive"));
        }
        if (outFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outFile", "com/intellij/cloudConfig/CloudConfigManager", "createArchive"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/cloudConfig/CloudConfigManager", "createArchive"));
        }
        FileUtil.createParentDirs((File)outFile);
        try (SevenZOutputFile archive = new SevenZOutputFile(outFile);){
            CloudConfigManager.addToArchive(archive, files, prefix);
        }
    }

    private static void addToArchive(SevenZOutputFile archive, @NotNull Set<File> files, @NotNull String prefix) throws IOException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/cloudConfig/CloudConfigManager", "addToArchive"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/cloudConfig/CloudConfigManager", "addToArchive"));
        }
        prefix = prefix + File.separator;
        int length = prefix.length();
        for (File file : files) {
            String path = file.getAbsolutePath();
            assert (path.startsWith(prefix));
            String name = path.substring(length);
            if (File.separatorChar != '/') {
                name = name.replace(File.separatorChar, '/');
            }
            archive.putArchiveEntry((ArchiveEntry)archive.createArchiveEntry(file, name));
            if (file.exists() && file.isFile()) {
                archive.write(FileUtil.loadFileBytes((File)file));
            }
            archive.closeArchiveEntry();
        }
    }

    private static void extractArchive(@NotNull File archiveFile, @NotNull File outDir, boolean delete) throws IOException {
        if (archiveFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archiveFile", "com/intellij/cloudConfig/CloudConfigManager", "extractArchive"));
        }
        if (outDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outDir", "com/intellij/cloudConfig/CloudConfigManager", "extractArchive"));
        }
        try (SevenZFile archive = new SevenZFile(archiveFile);){
            SevenZArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                if (entry.isDirectory() || !CloudConfigManager.filterOsName(entry.getName())) continue;
                File file = new File(outDir, entry.getName());
                int size = (int)entry.getSize();
                if (delete && size == 0) {
                    FileUtil.delete((File)file);
                    continue;
                }
                FileUtil.writeToFile((File)file, (byte[])CloudConfigClientUtil.loadBytes((SevenZFile)archive, (int)size));
            }
        }
    }

    private static void extractArchive(@NotNull File archiveFile, @NotNull File outDir, @NotNull Set<String> changedFiles) throws IOException {
        if (archiveFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archiveFile", "com/intellij/cloudConfig/CloudConfigManager", "extractArchive"));
        }
        if (outDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outDir", "com/intellij/cloudConfig/CloudConfigManager", "extractArchive"));
        }
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFiles", "com/intellij/cloudConfig/CloudConfigManager", "extractArchive"));
        }
        try (SevenZFile archive = new SevenZFile(archiveFile);){
            SevenZArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String fileName = entry.getName();
                File file = new File(outDir, fileName);
                int size = (int)entry.getSize();
                boolean change = false;
                if (size == 0) {
                    if (file.exists()) {
                        FileUtil.delete((File)file);
                        change = true;
                        LOG.info("=== Update File(Delete): " + fileName + " ===");
                    }
                } else if (CloudConfigManager.filterOsName(fileName)) {
                    byte[] oldBytes = file.isFile() && file.exists() ? FileUtil.loadFileBytes((File)file) : null;
                    byte[] newBytes = CloudConfigClientUtil.loadBytes((SevenZFile)archive, (int)((int)entry.getSize()));
                    if (!Arrays.equals(newBytes, oldBytes)) {
                        FileUtil.writeToFile((File)file, (byte[])newBytes);
                        if (!"version".equals(fileName)) {
                            change = true;
                            LOG.info("=== Update File(Edit): " + fileName + " ===");
                        }
                    }
                }
                if (!change) continue;
                changedFiles.add(fileName);
                String dirName = StringUtil.substringBefore((String)fileName, (String)"/");
                if (dirName == null) continue;
                changedFiles.add(dirName);
            }
        }
    }

    @NotNull
    private List<String> listFiles(@NotNull String file) throws IOException {
        List list;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cloudConfig/CloudConfigManager", "listFiles"));
        }
        try {
            List result = this.myClient.list(CloudConfigClientUtil.getName() + file);
            this.myNetworkStatistics.addBytes(result);
            this.myIOError = false;
            List list2 = result;
            list = list2;
        }
        catch (IOException e) {
            this.myIOError = true;
            throw e;
        }
        finally {
            this.myNetworkStatistics.save();
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "listFiles"));
        }
        return list;
    }

    @Nullable
    private Boolean getFile(@NotNull String name) throws IOException {
        InputStream stream;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "getFile"));
        }
        File file = new File(this.myCachesDir, name);
        try {
            stream = this.myClient.read(CloudConfigClientUtil.getName() + name);
            this.myIOError = false;
        }
        catch (FileNotFoundException ignored) {
            FileUtil.delete((File)file);
            return null;
        }
        catch (IOException e) {
            this.myIOError = true;
            throw e;
        }
        if (stream != null) {
            FileUtil.createParentDirs((File)file);
            try (InputStream inputStream = stream;
                 FileOutputStream outputStream = new FileOutputStream(file);){
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                this.myNetworkStatistics.addBytes(file);
                this.myIOError = false;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                this.myIOError = true;
                throw e;
            }
            finally {
                this.myNetworkStatistics.save();
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void writeFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cloudConfig/CloudConfigManager", "writeFile"));
        }
        try (FileInputStream stream = new FileInputStream(file);){
            this.myClient.write(CloudConfigClientUtil.getName() + file.getName(), (InputStream)stream);
            this.myNetworkStatistics.addBytes(file);
            this.myIOError = false;
        }
        catch (IOException e) {
            this.myIOError = true;
            throw e;
        }
        finally {
            this.myNetworkStatistics.save();
        }
    }

    private void deleteFile(@NotNull String file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cloudConfig/CloudConfigManager", "deleteFile"));
        }
        try {
            this.myClient.delete(CloudConfigClientUtil.getName() + file);
            this.myIOError = false;
        }
        catch (IOException e) {
            this.myIOError = true;
            throw e;
        }
    }

    @NotNull
    private File getDisabledPluginsFile() {
        File file = new File(this.myIdeConfigPath, "disabled_plugins.txt");
        FileUtil.createIfDoesntExist((File)file);
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getDisabledPluginsFile"));
        }
        return file2;
    }

    @NotNull
    private File getLocalDisabledPluginsFile() {
        File file = new File(this.myConfigDir, LOCAL_DISABLED_PLUGINS_FILENAME);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getLocalDisabledPluginsFile"));
        }
        return file;
    }

    private static void logInfo(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cloudConfig/CloudConfigManager", "logInfo"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info((Throwable)e);
        } else {
            LOG.error((Throwable)e);
        }
    }

    static {
        KEYMAP_CONVERTER = (storageClass, name) -> {
            if (storageClass == KeymapManagerImpl.class) {
                return CloudConfigClientUtil.getOS() + "." + name;
            }
            return name;
        };
        OS_NAMES = new String[]{"mac", "win", "linux", "freebsd", "unix", "unknown"};
    }

    private class LocalChanges {
        private final Set<String> myFiles = new LinkedHashSet<String>();
        private final File myFile = new File(CloudConfigManager.access$1100(CloudConfigManager.this), "local.changes");

        private LocalChanges() {
        }

        public void load() {
            try {
                if (this.myFile.exists()) {
                    this.myFiles.addAll(FileUtil.loadLines((File)this.myFile));
                    LOG.info("=== Local Changes: " + this.myFiles + " ===");
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }

        public void addFiles(String ... fileNames) throws IOException {
            if (fileNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNames", "com/intellij/cloudConfig/CloudConfigManager$LocalChanges", "addFiles"));
            }
            if (Collections.addAll(this.myFiles, fileNames)) {
                this.save();
            }
        }

        @NotNull
        public Set<File> getFiles() {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (String file : this.myFiles) {
                files.add(new File(CloudConfigManager.this.myConfigDir, file));
            }
            LinkedHashSet<File> linkedHashSet = files;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager$LocalChanges", "getFiles"));
            }
            return linkedHashSet;
        }

        public void removeFiles(@NotNull Set<String> files) throws IOException {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/cloudConfig/CloudConfigManager$LocalChanges", "removeFiles"));
            }
            this.myFiles.removeAll(files);
            if (this.myFiles.isEmpty()) {
                FileUtil.delete((File)this.myFile);
            } else {
                this.save();
            }
        }

        private void save() throws IOException {
            FileUtil.writeToFile((File)this.myFile, (String)StringUtil.join(this.myFiles, (String)"\n"));
        }

        public void clean() {
            this.myFiles.clear();
            FileUtil.delete((File)this.myFile);
        }
    }

    private static class TestExecuteManager
    extends ExecuteManager {
        private TestExecuteManager() {
        }

        @Override
        public void executeOnPooledThread(@NotNull Runnable action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/cloudConfig/CloudConfigManager$TestExecuteManager", "executeOnPooledThread"));
            }
            action.run();
        }

        @Override
        public void invokeAndWait(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/cloudConfig/CloudConfigManager$TestExecuteManager", "invokeAndWait"));
            }
            runnable.run();
        }

        @Override
        public void invokeLater(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/cloudConfig/CloudConfigManager$TestExecuteManager", "invokeLater"));
            }
            runnable.run();
        }

        @Override
        public void runProcessWithProgressSynchronously(@NotNull Runnable process, @Nls @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project) {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/cloudConfig/CloudConfigManager$TestExecuteManager", "runProcessWithProgressSynchronously"));
            }
            if (progressTitle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/cloudConfig/CloudConfigManager$TestExecuteManager", "runProcessWithProgressSynchronously"));
            }
            process.run();
        }

        @Override
        public void schedule(Runnable command, long delay, TimeUnit unit) {
            command.run();
        }
    }

    private static class ExecuteManager {
        private ExecuteManager() {
        }

        public void executeOnPooledThread(@NotNull Runnable action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/cloudConfig/CloudConfigManager$ExecuteManager", "executeOnPooledThread"));
            }
            ApplicationManager.getApplication().executeOnPooledThread(action);
        }

        public void invokeAndWait(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/cloudConfig/CloudConfigManager$ExecuteManager", "invokeAndWait"));
            }
            ApplicationManager.getApplication().invokeAndWait(runnable);
        }

        public void invokeLater(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/cloudConfig/CloudConfigManager$ExecuteManager", "invokeLater"));
            }
            ApplicationManager.getApplication().invokeLater(runnable);
        }

        public void runProcessWithProgressSynchronously(@NotNull Runnable process, @Nls @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project) {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/cloudConfig/CloudConfigManager$ExecuteManager", "runProcessWithProgressSynchronously"));
            }
            if (progressTitle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/cloudConfig/CloudConfigManager$ExecuteManager", "runProcessWithProgressSynchronously"));
            }
            ProgressManager.getInstance().runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project);
        }

        public void schedule(Runnable command, long delay, TimeUnit unit) {
            JobScheduler.getScheduler().schedule(command, delay, unit);
        }
    }

    static enum ConnectionState {
        OLD,
        NEW,
        UPDATE,
        DELETE,
        IO_ERROR;

    }
}

