/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.cloudConfig.PluginState;
import com.intellij.cloudConfig.StatusInfo;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.ide.plugins.PluginsTableRenderer;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EmptyIcon;
import icons.CloudConfigIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import messages.CloudConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusBarInfoManager {
    private static final String ID = "CloudConfig";
    public static final StatusBarInfoManager EMPTY = new StatusBarInfoManager(){

        @Override
        public void update(boolean create) {
        }
    };

    public void update(boolean create) {
        WindowManager windowManager = WindowManager.getInstance();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            StatusBar statusBar = windowManager.getStatusBar(project);
            StatusBarWidget widget = statusBar.getWidget(ID);
            if (widget instanceof InfoComponent) {
                ((InfoComponent)widget).update();
                continue;
            }
            if (!create) continue;
            statusBar.addWidget((StatusBarWidget)new InfoComponent());
        }
    }

    private static void connectInstance(@Nullable Runnable successRun) {
        CloudConfigManager manager = CloudConfigManager.getInstance();
        if (manager.getStatusInfo() == StatusInfo.JBA_NOT_CONNECTED) {
            Boolean result = MyMessages.showDialog("connect.message", "connect.button", "connect.plugins.auto");
            if (result != null) {
                manager.setAutoUpdatePlugins(result);
                manager.connectFirstInstance(false, successRun);
            }
        } else {
            boolean[] autoUpdatePlugins = new boolean[1];
            int result = MyMessages.showCheckboxDialog(CloudConfigBundle.message("connect.this.message", CloudConfigClientUtil.getUserLogin()), new String[]{CloudConfigBundle.message("connect.this.remote.button", new Object[0]), CloudConfigBundle.message("connect.this.local.button", new Object[0]), Messages.CANCEL_BUTTON}, CloudConfigBundle.message("connect.plugins.auto", new Object[0]), Messages.getInformationIcon(), (PairFunction<Integer, JCheckBox, Integer>)((PairFunction)(exitCode, checkBox) -> {
                autoUpdatePlugins[0] = checkBox.isSelected();
                return exitCode;
            }));
            if (result == 0 || result == 1) {
                manager.setAutoUpdatePlugins(autoUpdatePlugins[0]);
                if (result == 0) {
                    manager.connectThisInstance(true, false, successRun);
                } else {
                    manager.connectFirstInstance(true, successRun);
                }
            }
        }
    }

    private static class PluginModel
    extends PluginTableModel {
        final Map<IdeaPluginDescriptor, PluginState> myStateMap = new HashMap<IdeaPluginDescriptor, PluginState>();
        final Set<IdeaPluginDescriptor> myExecuteList = new HashSet<IdeaPluginDescriptor>();
        Runnable myCheckedHandler;

        public PluginModel() {
            this.columns = new ColumnInfo[]{new ColumnInfo<IdeaPluginDescriptor, Boolean>(""){

                @Nullable
                public Boolean valueOf(IdeaPluginDescriptor descriptor) {
                    return myExecuteList.contains(descriptor);
                }

                public Class<?> getColumnClass() {
                    return Boolean.class;
                }

                @Nullable
                public TableCellRenderer getRenderer(IdeaPluginDescriptor descriptor) {
                    return new BooleanTableCellRenderer();
                }

                public boolean isCellEditable(IdeaPluginDescriptor descriptor) {
                    return true;
                }

                @Nullable
                public TableCellEditor getEditor(IdeaPluginDescriptor descriptor) {
                    return new BooleanTableCellEditor();
                }

                public void setValue(IdeaPluginDescriptor descriptor, Boolean value) {
                    if (value.booleanValue()) {
                        myExecuteList.add(descriptor);
                    } else {
                        myExecuteList.remove(descriptor);
                    }
                    myCheckedHandler.run();
                }
            }, new PluginManagerColumnInfo(0, this){

                public TableCellRenderer getRenderer(IdeaPluginDescriptor descriptor) {
                    return descriptor == null ? null : new PluginsTableRenderer(descriptor, false){

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            this.myName.append(" ").append(myStateMap.get(this.myPluginDescriptor).name(), SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                            return component;
                        }
                    };
                }
            }};
            CloudConfigManager manager = CloudConfigManager.getInstance();
            this.addItems(manager.getInstalledUninstalledPlugins());
            this.addItems(manager.getEnabledDisabledPlugins());
        }

        public void setCheckedHandler(@NotNull Runnable checkedHandler) {
            if (checkedHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedHandler", "com/intellij/cloudConfig/StatusBarInfoManager$PluginModel", "setCheckedHandler"));
            }
            this.myCheckedHandler = checkedHandler;
            checkedHandler.run();
        }

        private void addItems(@NotNull List<Pair<IdeaPluginDescriptor, PluginState>> descriptors) {
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/cloudConfig/StatusBarInfoManager$PluginModel", "addItems"));
            }
            for (Pair<IdeaPluginDescriptor, PluginState> info : descriptors) {
                this.view.add(info.first);
                this.myStateMap.put((IdeaPluginDescriptor)info.first, (PluginState)((Object)info.second));
            }
        }

        public void updatePluginsList(List<IdeaPluginDescriptor> list) {
        }

        public int getNameColumn() {
            return 1;
        }

        public boolean isPluginDescriptorAccepted(IdeaPluginDescriptor descriptor) {
            return true;
        }

        public boolean isSortable() {
            return false;
        }
    }

    private static class MyMessages
    extends Messages {
        private MyMessages() {
        }

        @NotNull
        private static String title() {
            String string = CloudConfigBundle.message("dialog.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages", "title"));
            }
            return string;
        }

        public static int showCheckboxDialog(String message, @NotNull String[] options, String checkboxText, Icon icon, @Nullable PairFunction<Integer, JCheckBox, Integer> exitFunc) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages", "showCheckboxDialog"));
            }
            Messages.TwoStepConfirmationDialog dialog = new Messages.TwoStepConfirmationDialog(message, MyMessages.title(), options, checkboxText, false, 0, 0, icon, exitFunc);
            dialog.setResizable(false);
            dialog.show();
            return dialog.getExitCode();
        }

        @Nullable
        public static Boolean showDialog(@NotNull String messageKey, @NotNull String okButtonKey, @NotNull String checkBoxKey) {
            if (messageKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageKey", "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages", "showDialog"));
            }
            if (okButtonKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okButtonKey", "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages", "showDialog"));
            }
            if (checkBoxKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkBoxKey", "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages", "showDialog"));
            }
            int result = MyMessages.showCheckboxDialog(CloudConfigBundle.message(messageKey, new Object[0]), new String[]{CloudConfigBundle.message(okButtonKey, new Object[0]), Messages.CANCEL_BUTTON}, CloudConfigBundle.message(checkBoxKey, new Object[0]), Messages.getInformationIcon(), (PairFunction<Integer, JCheckBox, Integer>)((PairFunction)(exitCode, checkBox) -> exitCode == 0 ? (checkBox.isSelected() ? 0 : 1) : 2));
            return result == 2 ? null : Boolean.valueOf(result == 0);
        }

        public static void showPluginsDialog() {
            final PluginModel pluginModel = new PluginModel();
            Messages.TwoStepConfirmationDialog dialog = new Messages.TwoStepConfirmationDialog(CloudConfigBundle.message("plugins.dialog.message", new Object[0]), MyMessages.title(), new String[]{CloudConfigBundle.message("plugins.dialog.button", new Object[0]), Messages.CANCEL_BUTTON}, null, false, 0, 0, Messages.getInformationIcon(), (exitCode, checkBox) -> exitCode){
                PluginTable myTable;

                @NotNull
                protected JComponent createCheckComponent() {
                    this.myTable = new PluginTable((PluginTableModel)pluginModel);
                    JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
                    pane.setPreferredSize(new Dimension(this.myTable.getPreferredScrollableViewportSize().width, 200));
                    this.myTable.registerKeyboardAction(e -> {
                        int[] selectedRows = this.myTable.getSelectedRows();
                        LinkedHashSet<IdeaPluginDescriptor> descriptors = new LinkedHashSet<IdeaPluginDescriptor>();
                        boolean currentlyMarked = true;
                        for (int selectedRow : selectedRows) {
                            if (selectedRow < 0) {
                                return;
                            }
                            IdeaPluginDescriptor descriptor = pluginModel.getObjectAt(this.myTable.convertRowIndexToModel(selectedRow));
                            descriptors.add(descriptor);
                            currentlyMarked &= pluginModel2.myExecuteList.contains(descriptor);
                        }
                        if (currentlyMarked) {
                            pluginModel2.myExecuteList.removeAll(descriptors);
                        } else {
                            pluginModel2.myExecuteList.addAll(descriptors);
                        }
                        this.myTable.repaint();
                        pluginModel2.myCheckedHandler.run();
                    }, KeyStroke.getKeyStroke(32, 0), 0);
                    JScrollPane jScrollPane = pane;
                    if (jScrollPane == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$1", "createCheckComponent"));
                    }
                    return jScrollPane;
                }

                public JComponent getPreferredFocusedComponent() {
                    return this.myTable;
                }

                @NotNull
                protected Action[] createActions() {
                    Action[] actions = super.createActions();
                    pluginModel.setCheckedHandler(() -> actions[0].setEnabled(!pluginModel2.myExecuteList.isEmpty()));
                    if (actions == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$1", "createActions"));
                    }
                    return actions;
                }
            };
            dialog.setResizable(false);
            dialog.show();
            if (dialog.getExitCode() == 0) {
                ArrayList<Pair<IdeaPluginDescriptor, PluginState>> executeList = new ArrayList<Pair<IdeaPluginDescriptor, PluginState>>();
                for (IdeaPluginDescriptor descriptor : pluginModel.myExecuteList) {
                    executeList.add((Pair<IdeaPluginDescriptor, PluginState>)Pair.create((Object)descriptor, (Object)((Object)pluginModel.myStateMap.get(descriptor))));
                }
                CloudConfigManager.getInstance().executePlugins(executeList);
            }
        }
    }

    private static class InfoComponent
    implements StatusBarWidget,
    StatusBarWidget.IconPresentation,
    DumbAware {
        private StatusBar myStatusBar;
        private Icon myIcon = EmptyIcon.ICON_16;
        private String myTooltip;
        private DefaultActionGroup myActions;
        private String myPopupTitle;
        private String myPopupBottomTitle;

        private InfoComponent() {
        }

        public void install(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/cloudConfig/StatusBarInfoManager$InfoComponent", "install"));
            }
            this.myStatusBar = statusBar;
            this.update();
        }

        public void update() {
            this.myActions = null;
            this.myPopupBottomTitle = null;
            this.myPopupTitle = null;
            CloudConfigManager manager = CloudConfigManager.getInstance();
            switch (manager.getStatusInfo()) {
                case OFFLINE: 
                case JBA_NOT_FOUND: 
                case DISABLED: {
                    this.myStatusBar.removeWidget(StatusBarInfoManager.ID);
                    return;
                }
                case JBA_IO_ERROR: {
                    this.myIcon = CloudConfigIcons.Io_error;
                    this.myTooltip = CloudConfigBundle.message("error.connected.message", new Object[0]);
                    break;
                }
                case JBA_IO_OPERATION: {
                    this.myIcon = CloudConfigIcons.Io_operation;
                    this.myTooltip = CloudConfigBundle.message("io.operation.message", new Object[0]);
                    break;
                }
                case JBA_NOT_CONNECTED: 
                case JBA_THIS_NOT_CONNECTED: {
                    this.myIcon = CloudConfigIcons.Not_connected;
                    this.myTooltip = CloudConfigBundle.message("not.connected.message", new Object[0]);
                    this.createNotConnectedActions();
                    break;
                }
                case JBA_CONNECTED: {
                    if (manager.hasPluginsUpdate()) {
                        this.myIcon = CloudConfigIcons.Update;
                        this.myTooltip = CloudConfigBundle.message("update.plugins.message", new Object[0]);
                    } else {
                        this.myIcon = CloudConfigIcons.Connected;
                        this.myTooltip = CloudConfigBundle.message("connected.message", new Object[0]);
                    }
                    this.createConnectedActions();
                }
            }
            this.myStatusBar.updateWidget(StatusBarInfoManager.ID);
        }

        private void createNotConnectedActions() {
            this.myActions = new DefaultActionGroup();
            this.myPopupTitle = CloudConfigBundle.message("not.connected.popup.title", new Object[0]);
            this.myActions.addAction((AnAction)new DumbAwareAction(CloudConfigBundle.message("enable.cloud.action", new Object[0])){

                public void actionPerformed(AnActionEvent e) {
                    StatusBarInfoManager.connectInstance(null);
                }
            });
            this.myActions.addSeparator();
            this.myActions.addAction((AnAction)new DumbAwareAction(CloudConfigBundle.message("hide.cloud.action", new Object[0])){

                public void actionPerformed(AnActionEvent e) {
                    CloudConfigManager.getInstance().disable();
                }
            });
        }

        private void createConnectedActions() {
            this.myActions = new DefaultActionGroup();
            this.myPopupBottomTitle = CloudConfigBundle.message("connected.popup.bottom.title", CloudConfigClientUtil.getUserLogin());
            class MyToggleAction
            extends ToggleAction
            implements DumbAware {
                public MyToggleAction() {
                    super(CloudConfigBundle.message("plugins.auto.update", new Object[0]));
                }

                public boolean isSelected(AnActionEvent e) {
                    return CloudConfigManager.getInstance().isAutoUpdatePlugins();
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    CloudConfigManager.getInstance().setAutoUpdatePlugins(state);
                }
            }
            this.myActions.add((AnAction)new MyToggleAction());
            if (CloudConfigManager.getInstance().hasPluginsUpdate()) {
                this.myPopupTitle = CloudConfigBundle.message("plugins.popup.title", new Object[0]);
                this.myActions.addAction((AnAction)new DumbAwareAction(CloudConfigBundle.message("update.plugins.action", new Object[0])){

                    public void actionPerformed(AnActionEvent e) {
                        MyMessages.showPluginsDialog();
                    }
                });
            } else {
                this.myPopupTitle = CloudConfigBundle.message("connected.popup.title", new Object[0]);
            }
            this.myActions.addSeparator();
            this.myActions.addAction((AnAction)new DumbAwareAction(CloudConfigBundle.message("disable.cloud.action", new Object[0])){

                public void actionPerformed(AnActionEvent e) {
                    Boolean result = MyMessages.showDialog("disconnect.message", "disconnect.button", "disconnect.remove.data");
                    if (result != null) {
                        CloudConfigManager.getInstance().disconnect(result);
                    }
                }
            });
        }

        public void dispose() {
            this.myStatusBar = null;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusBarInfoManager$InfoComponent", "getIcon"));
            }
            return icon;
        }

        @Nullable
        public String getTooltipText() {
            return this.myTooltip;
        }

        @Nullable
        public Consumer<MouseEvent> getClickConsumer() {
            return event -> {
                if (this.myActions == null) {
                    CloudConfigManager manager = CloudConfigManager.getInstance();
                    if (manager.getStatusInfo() == StatusInfo.JBA_IO_ERROR) {
                        manager.updateIO();
                    }
                } else {
                    final Component component = event.getComponent();
                    final ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(this.myPopupTitle, (ActionGroup)this.myActions, DataManager.getInstance().getDataContext(component), false, null, this.myActions.getChildrenCount());
                    if (this.myPopupBottomTitle != null) {
                        popup.setAdText(this.myPopupBottomTitle, 2);
                    }
                    popup.addListener((JBPopupListener)new JBPopupAdapter(){

                        public void beforeShown(LightweightWindowEvent event) {
                            popup.removeListener((JBPopupListener)this);
                            Point location = component.getLocationOnScreen();
                            Dimension size = popup.getSize();
                            popup.setLocation(new Point(location.x + component.getWidth() - size.width, location.y - size.height));
                        }
                    });
                    popup.show(component);
                }
            };
        }

        @Nullable
        public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/cloudConfig/StatusBarInfoManager$InfoComponent", "getPresentation"));
            }
            return this;
        }

        @NotNull
        public String ID() {
            if (StatusBarInfoManager.ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusBarInfoManager$InfoComponent", "ID"));
            }
            return StatusBarInfoManager.ID;
        }
    }

    public static class MenuAction
    extends DumbAwareAction {
        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(CloudConfigManager.getInstance().getStatusInfo().in(StatusInfo.DISABLED, StatusInfo.JBA_THIS_NOT_CONNECTED));
        }

        public void actionPerformed(AnActionEvent e) {
            CloudConfigManager manager = CloudConfigManager.getInstance();
            manager.recalculateInitStatus(e.getProject());
            if (manager.getStatusInfo() == StatusInfo.JBA_IO_ERROR) {
                Messages.showErrorDialog((String)"https://config-storage.labs.intellij.net/files not responded", (String)"Connection Error");
            } else {
                StatusBarInfoManager.connectInstance(() -> {
                    JComponent component = ((IdeStatusBarImpl)WindowManager.getInstance().getStatusBar(e.getProject())).getWidgetComponent(StatusBarInfoManager.ID);
                    assert (component != null);
                    String message = CloudConfigBundle.message(manager.hasPluginsUpdate() ? "update.plugins.message" : "connected.message", new Object[0]);
                    IdeTooltip tooltip = new IdeTooltip((Component)component, new Point(), (JComponent)new JLabel(message), new Object[0]);
                    IdeTooltipManager.getInstance().show(tooltip, true, false);
                });
            }
        }
    }

    public static class MyStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            StatusBar statusBar;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cloudConfig/StatusBarInfoManager$MyStartupActivity", "runActivity"));
            }
            if (CloudConfigManager.getInstance().getStatusInfo().notDisabled() && (statusBar = WindowManager.getInstance().getStatusBar(project)).getWidget(StatusBarInfoManager.ID) == null) {
                statusBar.addWidget((StatusBarWidget)new InfoComponent());
            }
        }
    }
}

