/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierBase;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ImportSpecifierStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportSpecifierImpl
extends ES6ImportExportSpecifierBase<ES6ImportSpecifierStub>
implements ES6ImportSpecifier,
BindablePsiReference,
HighlightSeverityHolder {
    public ES6ImportSpecifierImpl(ASTNode node) {
        super(node);
    }

    public ES6ImportSpecifierImpl(ES6ImportSpecifierStub stub) {
        super(stub, (IStubElementType)ES6ElementTypes.IMPORT_SPECIFIER);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitImportSpecifier((ES6ImportSpecifier)this);
        } else {
            super.accept(visitor);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl", "processDeclarations"));
        }
        ES6ImportSpecifierAlias alias = this.getAlias();
        if (place == this) {
            return true;
        }
        return alias != null ? alias.processDeclarations(processor, state, lastParent, place) : processor.execute((PsiElement)this, state);
    }

    @Nullable
    public ES6ImportSpecifierAlias getAlias() {
        return (ES6ImportSpecifierAlias)this.getStubOrPsiChild((IStubElementType)ES6ElementTypes.IMPORT_SPECIFIER_ALIAS);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)new ResolveCache.PolyVariantResolver<ES6ImportSpecifierImpl>(){

            @NotNull
            public ResolveResult[] resolve(@NotNull ES6ImportSpecifierImpl specifier, boolean incompleteCode) {
                if (specifier == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl$1", "resolve"));
                }
                ResolveResult[] resolveResultArray = ES6ImportSpecifierImpl.resolveImportSpecifier(ES6ImportSpecifierImpl.this);
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl$1", "resolve"));
                }
                return resolveResultArray;
            }
        }, true, incompleteCode);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    private static ResolveResult[] resolveImportSpecifier(@NotNull ES6ImportSpecifier specifier) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl", "resolveImportSpecifier"));
        }
        if (specifier.isDefault()) {
            ResolveResult[] resolveResultArray = ES6ImportSpecifierImpl.resolveDefaultExport((ES6ImportExportSpecifierBase)specifier);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl", "resolveImportSpecifier"));
            }
            return resolveResultArray;
        }
        String name = specifier.getReferenceName();
        if (name == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl", "resolveImportSpecifier"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)specifier, name, true);
        List<JSType> innerAliases = ES6PsiUtil.processSpecifier((ES6ImportExportSpecifier)specifier, sink);
        ResolveResult[] results = sink.getResultsAsResolveResults();
        if (Arrays.stream(results).noneMatch(ResolveResult::isValidResult) && !innerAliases.isEmpty()) {
            ResolveResult[] resolveResultArray = ES6ImportSpecifierImpl.resolveWithInnerAliases((ES6ImportExportSpecifier)specifier, innerAliases);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl", "resolveImportSpecifier"));
            }
            return resolveResultArray;
        }
        if (results == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl", "resolveImportSpecifier"));
        }
        return results;
    }

    public static ResolveResult[] resolveWithInnerAliases(@NotNull ES6ImportExportSpecifier specifier, @NotNull List<JSType> innerAliases) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl", "resolveWithInnerAliases"));
        }
        if (innerAliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerAliases", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl", "resolveWithInnerAliases"));
        }
        if (DialectDetector.isTypeScript((PsiElement)specifier)) {
            return ResolveResult.EMPTY_ARRAY;
        }
        String name = specifier.getReferenceName();
        if (name == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(name, specifier.getContainingFile(), (PsiElement)specifier);
        ES6PsiUtil.addInnerAliases(innerAliases, processor);
        processor.setAddOnlyCompleteMatches(true);
        JSReferenceExpressionResolver.processAllSymbols(processor);
        return processor.getResults();
    }

    @Nullable
    public ES6ImportDeclaration getDeclaration() {
        return (ES6ImportDeclaration)super.getDeclaration();
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

