/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRequireFrameworkIndexHandler
extends FrameworkIndexingHandler {
    @Override
    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        ASTNode methodExpression = node.getFirstChildNode();
        if (methodExpression.getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
            return false;
        }
        ASTNode referencedNameElement = methodExpression.getFirstChildNode();
        return "require".equalsIgnoreCase(referencedNameElement.getText());
    }

    @Override
    public boolean shouldCreateStubForLiteral(ASTNode node) {
        return this.checkRequireCall(node.getTreeParent());
    }

    private boolean checkRequireCall(@Nullable ASTNode parent) {
        if (parent != null && parent.getElementType() == JSElementTypes.ARGUMENT_LIST) {
            ASTNode grandParent = parent.getTreeParent();
            return grandParent != null && grandParent.getElementType() == JSStubElementTypes.CALL_EXPRESSION && this.shouldCreateStubForCallExpression(grandParent);
        }
        return false;
    }

    @Override
    public boolean hasSignificantValue(@NotNull JSLiteralExpression expression) {
        PsiElement grandParent;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/frameworks/modules/JSRequireFrameworkIndexHandler", "hasSignificantValue"));
        }
        PsiElement parent = expression.getParent();
        return parent instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression && ((JSCallExpression)grandParent).isRequireCall();
    }
}

