/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;

public class JSProblemFileHighlightFilter
implements Condition<VirtualFile> {
    private final Project myProject;

    public JSProblemFileHighlightFilter(Project project) {
        this.myProject = project;
    }

    public boolean value(VirtualFile file) {
        if (file.isDirectory()) {
            return false;
        }
        FileType fileType = file.getFileType();
        if (fileType == ActionScriptFileType.INSTANCE || JavaScriptSupportLoader.isMxmlOrFxgFile(file)) {
            return ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isInSource(file);
        }
        if (DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType) || TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(fileType)) {
            ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
            return !index.isExcluded(file) && !index.isInLibraryClasses(file) && !index.isInLibrarySource(file);
        }
        return false;
    }
}

