/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartFMap;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ES6ImportIndex
extends FileBasedIndexExtension<ImportKey, List<ImportInfo>> {
    public static final ID<ImportKey, List<ImportInfo>> INDEX_ID = ID.create((String)"es6.import.index");
    public static final int INDEX_VERSION = 0;

    @NotNull
    public ID<ImportKey, List<ImportInfo>> getName() {
        ID<ImportKey, List<ImportInfo>> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/ES6ImportIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<ImportKey, List<ImportInfo>, FileContent> getIndexer() {
        DataIndexer<ImportKey, List<ImportInfo>, FileContent> dataIndexer = new DataIndexer<ImportKey, List<ImportInfo>, FileContent>(){

            @NotNull
            public Map<ImportKey, List<ImportInfo>> map(@NotNull FileContent content) {
                if (content == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/lang/javascript/index/ES6ImportIndex$1", "map"));
                }
                JSFile file = (JSFile)ObjectUtils.tryCast((Object)content.getPsiFile(), JSFile.class);
                if (file == null) {
                    SmartFMap smartFMap = SmartFMap.emptyMap();
                    if (smartFMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/ES6ImportIndex$1", "map"));
                    }
                    return smartFMap;
                }
                Set paths = file.getReferencedPaths();
                if (paths.isEmpty()) {
                    SmartFMap smartFMap = SmartFMap.emptyMap();
                    if (smartFMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/ES6ImportIndex$1", "map"));
                    }
                    return smartFMap;
                }
                FactoryMap<ImportKey, List<ImportInfo>> map = new FactoryMap<ImportKey, List<ImportInfo>>(){

                    protected List<ImportInfo> create(ImportKey key) {
                        return new SmartList();
                    }
                };
                ImportFileKeyImpl fileKey = new ImportFileKeyImpl(content.getFile());
                List infos = (List)map.get(fileKey);
                for (String path : paths) {
                    int index = (path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)StringUtil.unquoteString((String)path)), (String)"/")).lastIndexOf("/");
                    String name = index >= 0 ? path.substring(index + 1, path.length()) : path;
                    String fixedName = TypeScriptUtil.getFileNameWithoutExtension(name);
                    ImportInfoImpl impl = new ImportInfoImpl(path);
                    ImportNameKeyImpl key = new ImportNameKeyImpl(fixedName);
                    ((List)map.get(key)).add(impl);
                    infos.add(impl);
                }
                FactoryMap<ImportKey, List<ImportInfo>> factoryMap = map;
                if (factoryMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/ES6ImportIndex$1", "map"));
                }
                return factoryMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/ES6ImportIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<ImportKey> getKeyDescriptor() {
        KeyDescriptor<ImportKey> keyDescriptor = new KeyDescriptor<ImportKey>(){

            public int getHashCode(ImportKey value) {
                return value.hashCode();
            }

            public boolean isEqual(ImportKey val1, ImportKey val2) {
                return val1.equals(val2);
            }

            public void save(@NotNull DataOutput out, ImportKey value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/lang/javascript/index/ES6ImportIndex$2", "save"));
                }
                out.writeBoolean(value.isName());
                value.writeValue(out);
            }

            public ImportKey read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/lang/javascript/index/ES6ImportIndex$2", "read"));
                }
                boolean isInclude = in.readBoolean();
                return isInclude ? new ImportNameKeyImpl(IOUtil.readUTF((DataInput)in)) : new ImportFileKeyImpl(in.readInt());
            }
        };
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/ES6ImportIndex", "getKeyDescriptor"));
        }
        return keyDescriptor;
    }

    public int getVersion() {
        return 0;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/ES6ImportIndex$3", "acceptInput"));
                }
                return file.getFileSystem() != JarFileSystem.getInstance();
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/ES6ImportIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public static MultiMap<VirtualFile, ImportInfo> getIncludingFileCandidates(String fileName, GlobalSearchScope scope) {
        MultiMap result = MultiMap.createSmart();
        FileBasedIndex.ValueProcessor processor = (file, value) -> {
            result.put((Object)file, (Collection)value);
            return true;
        };
        FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)new ImportNameKeyImpl(fileName), null, processor, scope);
        return result;
    }

    public static Collection<VirtualFile> getIncludingFileCandidateKeys(String fileName, GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().getContainingFiles(INDEX_ID, (Object)new ImportNameKeyImpl(fileName), scope);
    }

    @NotNull
    public DataExternalizer<List<ImportInfo>> getValueExternalizer() {
        DataExternalizer<List<ImportInfo>> dataExternalizer = new DataExternalizer<List<ImportInfo>>(){

            public void save(@NotNull DataOutput out, List<ImportInfo> value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/lang/javascript/index/ES6ImportIndex$4", "save"));
                }
                out.writeInt(value.size());
                for (ImportInfo info : value) {
                    IOUtil.writeUTF((DataOutput)out, (String)info.getPath());
                }
            }

            public List<ImportInfo> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/lang/javascript/index/ES6ImportIndex$4", "read"));
                }
                int size = in.readInt();
                ArrayList<ImportInfo> infos = new ArrayList<ImportInfo>(size);
                for (int i = 0; i < size; ++i) {
                    infos.add(new ImportInfoImpl(IOUtil.readUTF((DataInput)in)));
                }
                return infos;
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/ES6ImportIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    private static class ImportInfoImpl
    implements ImportInfo {
        private final String myPath;

        public ImportInfoImpl(String path) {
            this.myPath = path;
        }

        @Override
        public String getPath() {
            return this.myPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImportInfoImpl)) {
                return false;
            }
            ImportInfoImpl info = (ImportInfoImpl)o;
            return Objects.equals(this.myPath, info.myPath);
        }

        public int hashCode() {
            return Objects.hash(this.myPath);
        }
    }

    public static interface ImportInfo {
        public String getPath();
    }

    private static class ImportNameKeyImpl
    implements ImportKey {
        private final String myFileName;

        public ImportNameKeyImpl(String fileName) {
            this.myFileName = fileName;
        }

        @Override
        public boolean isName() {
            return true;
        }

        @Override
        public void writeValue(DataOutput out) throws IOException {
            IOUtil.writeUTF((DataOutput)out, (String)this.myFileName);
        }

        public int hashCode() {
            return this.myFileName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ImportNameKeyImpl && ((ImportNameKeyImpl)obj).myFileName.equals(this.myFileName);
        }
    }

    private static class ImportFileKeyImpl
    implements ImportKey {
        private final int myFileId;

        private ImportFileKeyImpl(int fileId) {
            this.myFileId = fileId;
        }

        private ImportFileKeyImpl(VirtualFile file) {
            this.myFileId = FileBasedIndex.getFileId((VirtualFile)file);
        }

        @Override
        public boolean isName() {
            return false;
        }

        @Override
        public void writeValue(DataOutput out) throws IOException {
            out.writeInt(this.myFileId);
        }

        public int hashCode() {
            return this.myFileId;
        }

        public boolean equals(Object obj) {
            return obj instanceof ImportFileKeyImpl && ((ImportFileKeyImpl)obj).myFileId == this.myFileId;
        }
    }

    public static interface ImportKey {
        public boolean isName();

        public void writeValue(DataOutput var1) throws IOException;
    }
}

