/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class IntentionActionWithTimeout
implements IntentionAction {
    private static long ourPrevInvokeFinishTimeMillis;
    private final int myTimeoutMillis;

    protected IntentionActionWithTimeout(int timeoutMillis) {
        this.myTimeoutMillis = timeoutMillis;
    }

    @NotNull
    public abstract String getText();

    @NotNull
    public abstract String getFamilyName();

    public abstract boolean isAvailable(@NotNull Project var1, Editor var2, PsiFile var3);

    public final void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/IntentionActionWithTimeout", "invoke"));
        }
        long passedTimeMillis = System.currentTimeMillis() - ourPrevInvokeFinishTimeMillis;
        if (passedTimeMillis > (long)this.myTimeoutMillis) {
            this.invokeReally(project, editor, file);
        }
        ourPrevInvokeFinishTimeMillis = System.currentTimeMillis();
    }

    public abstract void invokeReally(@NotNull Project var1, Editor var2, PsiFile var3) throws IncorrectOperationException;

    public abstract boolean startInWriteAction();
}

