/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.lang.javascript.linter.JSLinterNpmPackageDoesNotExistsException;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class EslintPackage {
    private final File myBin;
    private final SemVer myVersion;

    public EslintPackage(@NotNull Project project, @NotNull String eslintPackageDirPath) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintPackage", "<init>"));
        }
        if (eslintPackageDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eslintPackageDirPath", "com/intellij/lang/javascript/linter/eslint/EslintPackage", "<init>"));
        }
        if (StringUtil.isEmpty((String)eslintPackageDirPath)) {
            throw new IOException("Please specify ESLint package");
        }
        File dir = new File(eslintPackageDirPath);
        if (!dir.isDirectory() || !dir.isAbsolute()) {
            throw new JSLinterNpmPackageDoesNotExistsException(JSLinterUtil.getLinterPackageMissingError(project, eslintPackageDirPath, "ESLint"));
        }
        this.myBin = new File(dir, "bin" + File.separator + "eslint.js");
        if (!this.myBin.isFile()) {
            throw new IOException("Please specify ESLint package correctly: \".../bin/eslint.js\" file not found");
        }
        this.myVersion = NodePackageVersionUtil.getPackageVersion(dir);
    }

    @NotNull
    public File getBin() {
        File file = this.myBin;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintPackage", "getBin"));
        }
        return file;
    }

    @NotNull
    public String getVersionStr() {
        String string = this.myVersion != null ? this.myVersion.getRawVersion() : "<unknown>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintPackage", "getVersionStr"));
        }
        return string;
    }

    public boolean isOneBasedColumn() {
        return this.myVersion == null || this.myVersion.getMajor() >= 1;
    }

    public boolean isStdinSupported() {
        if (this.myVersion == null || this.myVersion.getMajor() >= 1) {
            return true;
        }
        return this.myVersion.getMajor() == 0 && this.myVersion.getMinor() >= 21;
    }
}

