/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.standardjs;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterFixAction;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.eslint.EsLintExternalRunner;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.JSLinterReformatterTask;
import com.intellij.lang.javascript.linter.eslint.service.StandardJSService;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSConfiguration;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSExternalAnnotator;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class StandardJSFixAction
extends JSLinterFixAction {
    public StandardJSFixAction() {
        super(JSBundle.message((String)"standardjs.name", (Object[])new Object[0]), JSBundle.message((String)"standardjs.action.fix.problems.description", (Object[])new Object[0]), null);
    }

    @Override
    @NotNull
    protected StandardJSConfiguration getConfiguration(Project project) {
        StandardJSConfiguration standardJSConfiguration = StandardJSConfiguration.getInstance(project);
        if (standardJSConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSFixAction", "getConfiguration"));
        }
        return standardJSConfiguration;
    }

    @Override
    protected Task createTask(@NotNull Project project, @NotNull Collection<VirtualFile> scope, @NotNull Runnable completeCallback) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSFixAction", "createTask"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSFixAction", "createTask"));
        }
        if (completeCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completeCallback", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSFixAction", "createTask"));
        }
        final EslintState eslintState = StandardJSExternalAnnotator.tryCreateESLintInput((StandardJSState)this.getConfiguration(project).getExtendedState().getState(), project);
        return new JSLinterReformatterTask(project, JSBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]), scope, completeCallback){

            @Override
            protected void runLinter(@NotNull PsiFile psiFile, @NotNull Document document) {
                if (psiFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSFixAction$1", "runLinter"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSFixAction$1", "runLinter"));
                }
                if (eslintState == null) {
                    return;
                }
                VirtualFile file = psiFile.getVirtualFile();
                JSLinterInput<EslintState> input = JSLinterInput.create(this.myProject, psiFile, psiFile.getText(), eslintState, null);
                StandardJSService languageService = StandardJSService.getInstance(this.myProject);
                JSLinterAnnotationResult<EslintState> result = new EsLintExternalRunner(false, true, languageService).execute(input);
                this.processLinterRunnerOutput(file, result, true);
            }
        };
    }
}

