/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.gjslint;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.FilesMirror;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.gjslint.GjsLintConfigFileChangeTracker;
import com.intellij.lang.javascript.linter.gjslint.GjsLintConfigurable;
import com.intellij.lang.javascript.linter.gjslint.GjsLintConfiguration;
import com.intellij.lang.javascript.linter.gjslint.GjsLintInspection;
import com.intellij.lang.javascript.linter.gjslint.GjsLintState;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GjsLintExternalAnnotator
extends JSLinterExternalAnnotator<GjsLintState> {
    private static final Logger LOG = Logger.getInstance(GjsLintExternalAnnotator.class);
    private static final GjsLintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new GjsLintExternalAnnotator(false);
    private static final Pattern ERROR_PATTERN = Pattern.compile("^Line (\\d+), E:\\d+: (.*)$");
    private static final String CODE_TEMP_FILE_MAP_KEY_NAME = "CODE_TEMP_FILE_MAP_KEY";
    private static final String CONFIG_TEMP_FILE_MAP_KEY_NAME = "CONFIG_TEMP_FILE_MAP_KEY";
    private final FilesMirror myCodeFilesMirror = new FilesMirror("CODE_TEMP_FILE_MAP_KEY", "intellij-js-closure-linter");
    private final FilesMirror myConfigFilesMirror = new FilesMirror("CONFIG_TEMP_FILE_MAP_KEY", "intellij-js-closure-linter");

    public GjsLintExternalAnnotator() {
        this(true);
    }

    public GjsLintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @NotNull
    public static GjsLintExternalAnnotator getInstanceForBatchInspection() {
        GjsLintExternalAnnotator gjsLintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (gjsLintExternalAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "getInstanceForBatchInspection"));
        }
        return gjsLintExternalAnnotator;
    }

    @Override
    @NotNull
    protected JSLinterConfigurable<GjsLintState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "createSettingsConfigurable"));
        }
        GjsLintConfigurable gjsLintConfigurable = new GjsLintConfigurable(project, true);
        if (gjsLintConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "createSettingsConfigurable"));
        }
        return gjsLintConfigurable;
    }

    @Override
    protected Class<? extends JSLinterConfiguration<GjsLintState>> getConfigurationClass() {
        return GjsLintConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return GjsLintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "acceptPsiFile"));
        }
        return file instanceof JSFile && JSUtils.isJavaScriptFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public JSLinterAnnotationResult<GjsLintState> annotate(@NotNull JSLinterInput<GjsLintState> collectedInfo) {
        JSLinterAnnotationResult<GjsLintState> jSLinterAnnotationResult;
        if (collectedInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectedInfo", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "annotate"));
        }
        GjsLintState state = collectedInfo.getState();
        String exeFilePath = state.getLinterExePath();
        if (StringUtil.isEmpty((String)exeFilePath)) {
            return JSLinterAnnotationResult.create(collectedInfo, new JSLinterFileLevelAnnotation("Closure Linter executable file is not specified"), null);
        }
        File exeFile = new File(exeFilePath);
        if (!(exeFile.isFile() && exeFile.isAbsolute() && exeFile.canExecute())) {
            return JSLinterAnnotationResult.create(collectedInfo, new JSLinterFileLevelAnnotation("Closure Linter executable file is not found"), null);
        }
        String configFilePath = state.getConfigFilePath();
        if (StringUtil.isEmpty((String)configFilePath)) {
            return JSLinterAnnotationResult.create(collectedInfo, new JSLinterFileLevelAnnotation("Configuration file for Closure Linter is not specified"), null);
        }
        File configFile = new File(configFilePath);
        if (!configFile.isFile() || !configFile.isAbsolute()) {
            return JSLinterAnnotationResult.create(collectedInfo, new JSLinterFileLevelAnnotation("Configuration file for Closure Linter is not found"), null);
        }
        VirtualFile codeVirtualFile = collectedInfo.getPsiFile().getVirtualFile();
        if (codeVirtualFile == null || !codeVirtualFile.isValid()) {
            return null;
        }
        VirtualFile configVirtualFile = VfsUtil.findFileByIoFile((File)configFile, (boolean)false);
        if (configVirtualFile == null || !configVirtualFile.isValid()) {
            return null;
        }
        File actualCodeFile = this.myCodeFilesMirror.getOrCreateFileWithActualContent(collectedInfo.getProject(), codeVirtualFile, collectedInfo.getFileContent());
        if (actualCodeFile == null) {
            return null;
        }
        File actualConfigFile = this.myConfigFilesMirror.getOrCreateFileWithActualContent(collectedInfo.getProject(), configVirtualFile, null);
        if (actualConfigFile == null) {
            return null;
        }
        GjsLintConfigFileChangeTracker.startTracking();
        long startTimeNano = System.nanoTime();
        try {
            jSLinterAnnotationResult = GjsLintExternalAnnotator.startProcess(collectedInfo, exeFile, configVirtualFile, actualConfigFile, codeVirtualFile, actualCodeFile);
        }
        catch (Throwable throwable) {
            long durationNano = System.nanoTime() - startTimeNano;
            if (durationNano > TimeUnit.MILLISECONDS.toNanos(500L)) {
                LOG.info("[Closure Linter] Taken time " + String.format("%d ms", TimeUnit.NANOSECONDS.toMillis(durationNano)));
            }
            throw throwable;
        }
        long durationNano = System.nanoTime() - startTimeNano;
        if (durationNano > TimeUnit.MILLISECONDS.toNanos(500L)) {
            LOG.info("[Closure Linter] Taken time " + String.format("%d ms", TimeUnit.NANOSECONDS.toMillis(durationNano)));
        }
        return jSLinterAnnotationResult;
    }

    @Nullable
    private static JSLinterAnnotationResult<GjsLintState> startProcess(@NotNull JSLinterInput<GjsLintState> collectedInfo, @NotNull File exeFile, @NotNull VirtualFile configVirtualFile, @NotNull File configFile, @NotNull VirtualFile codeVirtualFile, @NotNull File codeFile) {
        KillableColoredProcessHandler processHandler;
        if (collectedInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectedInfo", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "startProcess"));
        }
        if (exeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exeFile", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "startProcess"));
        }
        if (configVirtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configVirtualFile", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "startProcess"));
        }
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "startProcess"));
        }
        if (codeVirtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeVirtualFile", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "startProcess"));
        }
        if (codeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFile", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "startProcess"));
        }
        File workingDir = codeFile.getParentFile();
        if (workingDir == null) {
            return null;
        }
        GeneralCommandLine commandLine = GjsLintExternalAnnotator.createCommandLine(workingDir, exeFile, configVirtualFile, configFile, codeVirtualFile, codeFile);
        String runError = null;
        final ProcessOutput output = new ProcessOutput();
        try {
            processHandler = new KillableColoredProcessHandler(commandLine, true);
        }
        catch (ExecutionException e) {
            runError = "Can not start gjslint process: " + e.getMessage();
            processHandler = null;
        }
        final ArrayList errors = ContainerUtil.newArrayList();
        final Ref runErrorRef = Ref.create(runError);
        if (runErrorRef.isNull() && processHandler != null) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    if (event == null) {
                        return;
                    }
                    String text = event.getText().trim();
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        output.appendStdout(text);
                        JSLinterError error = GjsLintExternalAnnotator.toError(text);
                        if (error != null) {
                            errors.add(error);
                        }
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        output.appendStderr(text);
                        String prefix = "gflags.UnrecognizedFlagError: ";
                        if (text.startsWith(prefix) && runErrorRef.isNull()) {
                            String unrecognizedFlag = text.substring(prefix.length());
                            String fix = GjsLintExternalAnnotator.findPossibleFixedFlag(unrecognizedFlag);
                            StringBuilder message = new StringBuilder("Closure Linter: ").append(unrecognizedFlag);
                            if (fix != null) {
                                message.append(". Try '").append(fix).append("'");
                            }
                            runErrorRef.set((Object)message.toString());
                        }
                    }
                }
            });
            processHandler.startNotify();
            processHandler.waitFor();
        }
        if ((runError = (String)runErrorRef.get()) != null) {
            IntentionAction detailsAction = processHandler == null ? null : JSLinterUtil.createDetailsAction(collectedInfo.getProject(), configVirtualFile, commandLine, output, null);
            return JSLinterAnnotationResult.create(collectedInfo, new JSLinterFileLevelAnnotation(null, runError, HighlightSeverity.ERROR, new JSLinterStandardFixes().setDetailsAction(detailsAction)), configVirtualFile);
        }
        return JSLinterAnnotationResult.createLinterResult(collectedInfo, errors, configVirtualFile);
    }

    @Nullable
    private static String findPossibleFixedFlag(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "findPossibleFixedFlag"));
        }
        String prefix = "Unknown command line flag '";
        String suffix = "'";
        if (message.startsWith(prefix) && message.endsWith(suffix)) {
            String unrecognizedFlag = message.substring(prefix.length(), message.length() - suffix.length());
            int ind = (unrecognizedFlag = unrecognizedFlag.trim()).indexOf(" ");
            if (ind > 0) {
                String first = unrecognizedFlag.substring(0, ind).trim();
                String second = unrecognizedFlag.substring(ind + 1).trim();
                return first + "=" + second;
            }
        }
        return null;
    }

    @Nullable
    private static JSLinterError toError(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "toError"));
        }
        Matcher matcher = ERROR_PATTERN.matcher(text);
        if (matcher.find() && matcher.groupCount() == 2) {
            int line;
            String lineStr = matcher.group(1);
            try {
                line = Integer.parseInt(lineStr);
            }
            catch (NumberFormatException ignored) {
                LOG.warn("Can't parse line number in '" + lineStr + "'");
                return null;
            }
            String message = matcher.group(2);
            return new JSLinterError(line, 0, message, null);
        }
        return null;
    }

    @NotNull
    public static GeneralCommandLine createCommandLine(@NotNull File workingDir, @NotNull File gjslintExeFile, @NotNull VirtualFile configVirtualFile, @NotNull File configFile, @NotNull VirtualFile codeVirtualFile, @NotNull File codeFile) {
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "createCommandLine"));
        }
        if (gjslintExeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gjslintExeFile", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "createCommandLine"));
        }
        if (configVirtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configVirtualFile", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "createCommandLine"));
        }
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "createCommandLine"));
        }
        if (codeVirtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeVirtualFile", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "createCommandLine"));
        }
        if (codeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFile", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "createCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.setWorkDirectory(workingDir);
        commandLine.setExePath(gjslintExeFile.getAbsolutePath());
        commandLine.addParameter("--flagfile");
        commandLine.addParameters(new String[]{configFile.getAbsolutePath()});
        commandLine.addParameter("--recurse=no");
        commandLine.addParameter(codeFile.getAbsolutePath());
        boolean passRealFilePath = GjsLintConfigFileChangeTracker.checkPassRealPath(configVirtualFile);
        if (passRealFilePath) {
            String configRealPath = FileUtil.toSystemDependentName((String)codeVirtualFile.getPath());
            commandLine.addParameter("--realFilePath=" + configRealPath);
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @Override
    public void apply(@NotNull PsiFile file, @Nullable JSLinterAnnotationResult<GjsLintState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator", "apply"));
        }
        if (annotationResult == null) {
            return;
        }
        HighlightDisplayKey inspectionKey = GjsLintInspection.getHighlightDisplayKey();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        GjsLintConfigurable configurable = new GjsLintConfigurable(file.getProject(), true);
        new JSLinterAnnotationsBuilder<GjsLintState>(file, annotationResult, holder, inspectionKey, configurable, "Closure Linter: ", this.getInspectionClass(), JSLinterStandardFixes.DEFAULT).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.line).apply();
    }
}

