/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.gjslint;

import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.gjslint.GjsLintConfiguration;
import com.intellij.lang.javascript.linter.gjslint.GjsLintState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GjsLintView
extends JSLinterBaseView<GjsLintState> {
    private final TextFieldWithBrowseButton myLinterExeFileTextField;
    private final TextFieldWithBrowseButton myConfigFileTextField;
    private final boolean mySingleDialog;

    public GjsLintView(@NotNull Project project, boolean singleDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/gjslint/GjsLintView", "<init>"));
        }
        this.myLinterExeFileTextField = JSLinterUtil.createTextFieldWithBrowseButton(project, "Select Closure Linter executable file - " + GjsLintConfiguration.DEFAULT_EXE_FILE_BASE_NAME);
        this.myConfigFileTextField = JSLinterUtil.createTextFieldWithBrowseButton(project, "Select configuration file");
        this.mySingleDialog = singleDialog;
    }

    @NotNull
    private static JPanel createConfigFileInfoPanel() {
        String[] lines = new String[]{"--strict", "--jsdoc", "--custom_jsdoc_tags=my_custom_tag"};
        StringBuilder html = new StringBuilder();
        for (String line : lines) {
            html.append("<div style='padding-top:1px;'>").append(line).append("</div");
        }
        JEditorPane pane = GjsLintView.createEditorPane();
        pane.setText(String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont(), (Color)UIUtil.getLabelForeground(), null, null), html.toString()));
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.add((Component)new JLabel("Example of a configuration file:"), "North");
        JPanel wrapper = new JPanel(new BorderLayout(0, 0));
        wrapper.add((Component)pane, "Center");
        wrapper.setBorder((Border)new RoundedLineBorder((Color)JBColor.lightGray, 5, 1));
        panel.add((Component)wrapper, "Center");
        panel.add((Component)new JLabel("Type \"gjslint --help\" for more information."), "South");
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintView", "createConfigFileInfoPanel"));
        }
        return jPanel;
    }

    @NotNull
    private static JEditorPane createEditorPane() {
        JEditorPane pane = ComponentsKt.htmlComponent();
        pane.setOpaque(true);
        pane.setBackground(UIUtil.getPanelBackground());
        pane.setForeground(UIUtil.getLabelForeground());
        pane.setBorder(BorderFactory.createEmptyBorder(3, 7, 3, 7));
        JEditorPane jEditorPane = pane;
        if (jEditorPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintView", "createEditorPane"));
        }
        return jEditorPane;
    }

    @Override
    @Nullable
    protected Component createTopRightComponent() {
        HyperlinkLabel usageLink = SwingHelper.createWebHyperlink((String)"How to Use Closure Linter", (String)"https://developers.google.com/closure/utilities/docs/linter_howto");
        JPanel usageLinkPanel = new JPanel(new BorderLayout(0, 0));
        usageLinkPanel.add((Component)usageLink, "East");
        return usageLinkPanel;
    }

    @Override
    @NotNull
    protected Component createCenterComponent() {
        JPanel centerPanel = new JPanel(new GridBagLayout());
        centerPanel.add((Component)new JLabel("Closure Linter executable file:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 4, 6), 0, 0));
        centerPanel.add((Component)this.myLinterExeFileTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 4, 0), 0, 0));
        centerPanel.add((Component)new JLabel("Configuration file:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 6), 0, 0));
        centerPanel.add((Component)this.myConfigFileTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel configFileInfoPanel = GjsLintView.createConfigFileInfoPanel();
        centerPanel.add((Component)configFileInfoPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(15, 20, 0, 0), 0, 0));
        centerPanel.add((Component)new JPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JPanel jPanel = centerPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintView", "createCenterComponent"));
        }
        return jPanel;
    }

    @Override
    protected void handleEnableStatusChanged(boolean enabled) {
    }

    @Override
    @NotNull
    protected GjsLintState getState() {
        GjsLintState gjsLintState = new GjsLintState.Builder().setLinterExePath(this.myLinterExeFileTextField.getText()).setConfigFilePath(this.myConfigFileTextField.getText()).build();
        if (gjsLintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintView", "getState"));
        }
        return gjsLintState;
    }

    @Override
    protected void setState(@NotNull GjsLintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/gjslint/GjsLintView", "setState"));
        }
        this.myLinterExeFileTextField.setText(state.getLinterExePath());
        this.myConfigFileTextField.setText(state.getConfigFilePath());
        if (this.mySingleDialog) {
            ApplicationManager.getApplication().invokeLater(() -> {
                SwingHelper.setPreferredWidthToFitText((JTextField)this.myLinterExeFileTextField.getTextField());
                SwingHelper.setPreferredWidthToFitText((JTextField)this.myConfigFileTextField.getTextField());
                DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)this.myLinterExeFileTextField);
                if (dialogWrapper != null) {
                    SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)dialogWrapper);
                }
            }, ModalityState.any());
        }
    }
}

