/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.linter.jscs.config.JscsOption;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsConfigCopier {
    private final Project myProject;
    private final VirtualFile myConfig;
    private final boolean myConfigWasCopied;
    private boolean myUseEsNext;
    private boolean myUseEs3;
    private String myEsPrimaPath;
    private StringBuilder myText;
    private String myError;

    public JscsConfigCopier(Project project, VirtualFile config, boolean configWasCopied) {
        this.myProject = project;
        this.myConfig = config;
        this.myConfigWasCopied = configWasCopied;
    }

    @Nullable
    public String process() {
        this.myText = new StringBuilder();
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myConfig);
            if (psiFile == null) {
                return;
            }
            JsonFile file = (JsonFile)ObjectUtils.tryCast((Object)psiFile, JsonFile.class);
            if (file == null) {
                return;
            }
            boolean mainChecked = false;
            for (PsiElement element : file.getChildren()) {
                JsonObject objectLiteralExpression = (JsonObject)ObjectUtils.tryCast((Object)element, JsonObject.class);
                if (!mainChecked && objectLiteralExpression != null) {
                    this.reviewProperties(objectLiteralExpression);
                    mainChecked = true;
                    continue;
                }
                this.myText.append(element.getText());
            }
        });
        if (this.myEsPrimaPath != null && this.myConfigWasCopied) {
            return this.myText.toString();
        }
        return null;
    }

    private void reviewProperties(@NotNull JsonObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/javascript/linter/jscs/JscsConfigCopier", "reviewProperties"));
        }
        List list = object.getPropertyList();
        for (JsonProperty property : list) {
            if (JscsOption.esnext.name().equals(property.getName()) && JscsConfigCopier.isTrue(property.getValue())) {
                this.myUseEsNext = true;
            } else if (JscsOption.es3.name().equals(property.getName()) && JscsConfigCopier.isTrue(property.getValue())) {
                this.myUseEs3 = true;
            } else if (JscsOption.esprima.name().equals(property.getName()) && JscsConfigCopier.isNotEmptyString(property.getValue())) {
                this.myEsPrimaPath = StringUtil.unquoteString((String)property.getValue().getText());
                if (this.myConfigWasCopied && this.replaceEsprimaPath()) {
                    continue;
                }
            } else if (JscsOption.excludeFiles.name().equals(property.getName())) continue;
            this.appendProperty(property);
        }
        if (this.myText.length() > 0) {
            this.myText.append("}");
        }
    }

    private boolean replaceEsprimaPath() {
        File esPrimaFile = new File(this.myEsPrimaPath);
        if (!esPrimaFile.isAbsolute()) {
            String absolutePath = this.findAbsolutePath();
            if (absolutePath != null) {
                this.myEsPrimaPath = FileUtil.toSystemIndependentName((String)absolutePath);
                this.beforeProperty();
                this.myText.append("\"esprima\": \"").append(this.myEsPrimaPath).append("\"");
                return true;
            }
            this.myError = "Can not find module '" + this.myEsPrimaPath + "'";
        }
        return false;
    }

    private String findAbsolutePath() {
        File esPrimaFile;
        String[] parts;
        String name;
        ResolvedModuleInfo info;
        String path = FileUtil.toSystemIndependentName((String)this.myEsPrimaPath);
        if (!(path.startsWith("/") || path.startsWith("./") || path.startsWith("../") || (info = NodeModuleSearchUtil.resolveModule(name = (parts = path.split("/"))[0], this.myConfig, null, Collections.emptyList(), false, this.myProject)) == null)) {
            String basePath = info.getModuleSourceRoot().getPath();
            if (parts.length == 1) {
                return basePath;
            }
            String suffix = StringUtil.join((String[])parts, (int)1, (int)parts.length, (String)"/");
            return basePath.endsWith("/") ? basePath + suffix : basePath + "/" + suffix;
        }
        if (this.myConfig.getParent() != null && (esPrimaFile = new File(this.myConfig.getParent().getPath(), this.myEsPrimaPath)).exists()) {
            return FileUtil.toSystemIndependentName((String)esPrimaFile.getAbsolutePath());
        }
        return null;
    }

    private void appendProperty(JsonProperty property) {
        this.beforeProperty();
        this.myText.append(property.getText());
    }

    private void beforeProperty() {
        if (this.myText.length() > 0) {
            this.myText.append(",");
        } else {
            this.myText.append("{");
        }
    }

    private static boolean isTrue(JsonValue value) {
        JsonBooleanLiteral boolLiteral = (JsonBooleanLiteral)ObjectUtils.tryCast((Object)value, JsonBooleanLiteral.class);
        if (boolLiteral == null) {
            return false;
        }
        return boolLiteral.getValue();
    }

    private static boolean isNotEmptyString(JsonValue value) {
        JsonStringLiteral stringLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)value, JsonStringLiteral.class);
        if (stringLiteral == null) {
            return false;
        }
        return !StringUtil.isEmptyOrSpaces((String)stringLiteral.getValue());
    }

    public boolean isUseEsNext() {
        return this.myUseEsNext;
    }

    public boolean isUseEs3() {
        return this.myUseEs3;
    }

    public String getEsPrimaPath() {
        return this.myEsPrimaPath;
    }

    public String getError() {
        return this.myError;
    }
}

