/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintOptionGroup {
    private final String myTitle;
    private final String myDescription;
    private final Map<JSHintOption, String> myHtmlDescriptionByOptionMap;

    public JSHintOptionGroup(@NotNull String title, @NotNull String description) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/lang/javascript/linter/jshint/JSHintOptionGroup", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/linter/jshint/JSHintOptionGroup", "<init>"));
        }
        this.myTitle = title;
        this.myDescription = JSHintOptionGroup.htmlWrap(description);
        this.myHtmlDescriptionByOptionMap = new EnumMap<JSHintOption, String>(JSHintOption.class);
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintOptionGroup", "getTitle"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintOptionGroup", "getDescription"));
        }
        return string;
    }

    @NotNull
    public Collection<JSHintOption> getOptions() {
        Set<JSHintOption> set = this.myHtmlDescriptionByOptionMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintOptionGroup", "getOptions"));
        }
        return set;
    }

    @Nullable
    public String getHtmlDescriptionByOption(@NotNull JSHintOption option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/JSHintOptionGroup", "getHtmlDescriptionByOption"));
        }
        return this.myHtmlDescriptionByOptionMap.get(option);
    }

    public String toString() {
        return "(title: " + this.myTitle + ")";
    }

    public void add(@NotNull JSHintOption option, @NotNull String description) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/JSHintOptionGroup", "add"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/linter/jshint/JSHintOptionGroup", "add"));
        }
        this.myHtmlDescriptionByOptionMap.put(option, JSHintOptionGroup.htmlWrap(description));
    }

    private static String htmlWrap(@NotNull String bodyHtml) {
        if (bodyHtml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyHtml", "com/intellij/lang/javascript/linter/jshint/JSHintOptionGroup", "htmlWrap"));
        }
        String openingTags = "<html><body>";
        if (bodyHtml.startsWith(openingTags)) {
            return bodyHtml;
        }
        return openingTags + bodyHtml + "</body></html>";
    }
}

