/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.version;

import com.intellij.lang.javascript.linter.jshint.version.JSHintVersionUtil;
import org.jetbrains.annotations.NotNull;

public class JSHintVersionDescriptor {
    private final String myVersion;
    private final String myUrl;

    public JSHintVersionDescriptor(@NotNull String version, @NotNull String url) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionDescriptor", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionDescriptor", "<init>"));
        }
        this.myVersion = version;
        this.myUrl = url;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionDescriptor", "getVersion"));
        }
        return string;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionDescriptor", "getUrl"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSHintVersionDescriptor that = (JSHintVersionDescriptor)o;
        return this.myUrl.equals(that.myUrl) && this.myVersion.equals(that.myVersion);
    }

    public int hashCode() {
        int result = this.myVersion.hashCode();
        result = 31 * result + this.myUrl.hashCode();
        return result;
    }

    public boolean isBundled() {
        return JSHintVersionUtil.isBundledVersion(this.myVersion);
    }

    public String toString() {
        return "(version:" + this.myVersion + ", url:" + this.myUrl + ")";
    }
}

