/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.actions.TypeDeclarationProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptTypeDeclarationProvider
implements TypeDeclarationProvider {
    public PsiElement[] getSymbolTypeDeclarations(@NotNull PsiElement symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/lang/javascript/navigation/JavaScriptTypeDeclarationProvider", "getSymbolTypeDeclarations"));
        }
        if (!(symbol instanceof JSNamedElement)) {
            return null;
        }
        JSType type = null;
        if (symbol instanceof JSFunction) {
            type = ((JSFunction)symbol).getReturnType();
        } else if (symbol instanceof JSVariable) {
            PsiElement constructor = JavaScriptTypeDeclarationProvider.findReferencedModuleConstructor((JSVariable)symbol);
            if (constructor != null) {
                return new PsiElement[]{constructor};
            }
            type = ((JSVariable)symbol).getType();
        } else if (symbol instanceof JSExpression) {
            type = JSResolveUtil.getExpressionJSType((JSExpression)symbol);
        }
        if (type != null) {
            PsiFile containingFile = symbol.getContainingFile();
            String s = type.getResolvedTypeText();
            boolean ecmaL4 = DialectDetector.isActionScript((PsiElement)containingFile);
            GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)containingFile);
            PsiElement item = JSDialectSpecificHandlersFactory.forElement(symbol).getClassResolver().findClassByQName(s, symbol);
            if (item == null) {
                ArrayList result = new ArrayList();
                JSClassResolver.processElementsByNameIncludingImplicit(s, scope, false, (Processor<JSPsiElementBase>)((Processor)namedElement -> {
                    boolean ecmalL4File = DialectDetector.isActionScript((PsiElement)namedElement.getContainingFile());
                    if (ecmalL4File != ecmaL4) {
                        return true;
                    }
                    result.add(0, namedElement);
                    return true;
                }));
                if (!result.isEmpty()) {
                    item = (PsiElement)result.get(0);
                }
            }
            if (item != null && item.isPhysical()) {
                return new PsiElement[]{item};
            }
        }
        return new PsiElement[]{symbol};
    }

    @Nullable
    private static PsiElement findReferencedModuleConstructor(JSVariable element) {
        if (element instanceof JSParameter) {
            PsiElement resolve;
            PsiReference[] references;
            JSLiteralExpression argument = JSSymbolUtil.getParameterInitializationIfRequireArgument((JSParameter)element);
            if (argument != null && (references = argument.getReferences()).length > 0 && (resolve = references[references.length - 1].resolve()) instanceof JSFile) {
                JSPsiElementBase exportedElement = JSResolveUtil.getExportedElement((JSFile)resolve);
                return exportedElement != null ? exportedElement : resolve;
            }
        } else {
            JSExpression initializer = element.getInitializer();
            if (initializer instanceof JSCallExpression) {
                return JavaScriptTypeDeclarationProvider.findReferencedModuleConstructorIfRequireCall((JSCallExpression)initializer);
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement findReferencedModuleConstructorIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/navigation/JavaScriptTypeDeclarationProvider", "findReferencedModuleConstructorIfRequireCall"));
        }
        PsiElement module = CommonJSUtil.findReferencedModuleIfRequireCall(callExpression);
        if (module instanceof JSFile) {
            JSPsiElementBase exportedElement = JSResolveUtil.getExportedElement((JSFile)module);
            return exportedElement != null ? exportedElement : module;
        }
        return module;
    }
}

