/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSReferenceListMemberStub;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceListMemberImpl
extends JSStubElementImpl<JSReferenceListMemberStub>
implements JSReferenceListMember,
StubBasedPsiElement {
    public JSReferenceListMemberImpl(ASTNode node) {
        super(node);
    }

    public JSReferenceListMemberImpl(JSReferenceListMemberStub t, IStubElementType type) {
        super(t, type);
    }

    @NotNull
    public JSExpression getExpression() {
        JSExpression result = (JSExpression)this.findChildByClass(JSExpression.class);
        assert (result != null);
        JSExpression jSExpression = result;
        if (jSExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/JSReferenceListMemberImpl", "getExpression"));
        }
        return jSExpression;
    }

    @Nullable
    public String getReferenceText() {
        JSReferenceListMemberStub stub = (JSReferenceListMemberStub)this.getGreenStub();
        if (stub != null) {
            return stub.getReferenceText();
        }
        JSExpression expression = this.getExpression();
        if (JSReferenceListMemberImpl.isAccurateRefExpression(expression)) {
            return expression.getText();
        }
        return null;
    }

    @NotNull
    public JSTypeDeclaration[] getTypeArguments() {
        TypeScriptTypeArgumentList child = (TypeScriptTypeArgumentList)this.getStubOrPsiChild((IStubElementType)TypeScriptElementTypes.TYPE_ARGUMENT_LIST);
        JSTypeDeclaration[] jSTypeDeclarationArray = child == null ? JSTypeDeclaration.EMPTY_ARRAY : child.getTypeArguments();
        if (jSTypeDeclarationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/JSReferenceListMemberImpl", "getTypeArguments"));
        }
        return jSTypeDeclarationArray;
    }

    private static boolean isAccurateRefExpression(JSExpression expression) {
        return expression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)expression);
    }
}

