/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.json.psi.impl.JSStringLiteralEscaper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSInjectionController;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvidersRegistry;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSLiteralExpressionStub;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLiteralExpressionImpl
extends JSImplicitElementProviderImpl<JSLiteralExpressionStub>
implements JSLiteralExpression,
StubBasedPsiElement<JSLiteralExpressionStub>,
PsiLanguageInjectionHost {
    private static final Key<ParameterizedCachedValue<PsiReference[], JSLiteralExpressionImpl>> REFERENCES_KEY = new Key("js.literal.expression.references");
    private static final ParameterizedCachedValueProvider<PsiReference[], JSLiteralExpressionImpl> REFERENCES_PROVIDER = new ParameterizedCachedValueProvider<PsiReference[], JSLiteralExpressionImpl>(){

        @Nullable
        public CachedValueProvider.Result<PsiReference[]> compute(JSLiteralExpressionImpl param) {
            return CachedValueProvider.Result.create((Object)param.createRefs(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    };

    public JSLiteralExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSLiteralExpressionImpl(@NotNull JSLiteralExpressionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl", "<init>"));
        }
        super(stub, (IStubElementType)JSStubElementTypes.LITERAL_EXPRESSION);
    }

    protected JSLiteralExpressionImpl(@NotNull JSLiteralExpressionStub stub, IStubElementType type) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl", "<init>"));
        }
        super(stub, type);
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, REFERENCES_KEY, REFERENCES_PROVIDER, false, (Object)this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    private PsiReference[] createRefs() {
        if (JSInjectionController.willInjectSomething(this)) {
            return PsiReference.EMPTY_ARRAY;
        }
        JSElementIndexingData indexingData = this.getIndexingData();
        if (indexingData != null && !ContainerUtil.isEmpty((Collection)indexingData.getImplicitElements())) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] result = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (result.length == 0 && this.getTextLength() < 4096) {
            JSReferenceSet refSet = new JSReferenceSet((PsiElement)this);
            refSet.update(this.getText(), 0);
            return refSet.getReferences();
        }
        return result;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSLiteralExpression((JSLiteralExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean isValidHost() {
        return this.isQuotedLiteral() || this.isRegExpLiteral();
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl", "updateText"));
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<JSLiteralExpressionImpl> createLiteralTextEscaper() {
        JSStringLiteralEscaper<JSLiteralExpressionImpl> jSStringLiteralEscaper = new JSStringLiteralEscaper<JSLiteralExpressionImpl>(this){

            protected boolean isRegExpLiteral() {
                return ((JSLiteralExpressionImpl)this.myHost).isRegExpLiteral();
            }

            public boolean isOneLine() {
                return !(JSLiteralExpressionImpl.this instanceof JSStringTemplateExpression);
            }
        };
        if (jSStringLiteralEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl", "createLiteralTextEscaper"));
        }
        return jSStringLiteralEscaper;
    }

    public boolean isQuotedLiteral() {
        return JSLiteralExpressionImpl.isQuotedLiteral(this.getNode());
    }

    public static boolean isQuotedLiteral(ASTNode node) {
        return node.getElementType() == JSStubElementTypes.LITERAL_EXPRESSION && node.findChildByType(JSTokenTypes.STRING_LITERALS) != null;
    }

    public boolean isRegExpLiteral() {
        return this.getNode().findChildByType(JSTokenTypes.REGEXP_LITERAL) != null;
    }

    public boolean isBinaryLiteral() {
        if (!this.isNumericLiteral()) {
            return false;
        }
        String text = this.getText();
        return JSLiteralExpressionImpl.textHasBinaryPrefix(text) && JSLiteralExpressionImpl.textIsIntegerValue(text);
    }

    public boolean isOctalLiteral() {
        if (!this.isNumericLiteral()) {
            return false;
        }
        String text = this.getText();
        return JSLiteralExpressionImpl.textHasOctalPrefix(text) && JSLiteralExpressionImpl.textIsIntegerValue(text);
    }

    public boolean isHexLiteral() {
        if (!this.isNumericLiteral()) {
            return false;
        }
        String text = this.getText();
        return JSLiteralExpressionImpl.textHasHexPrefix(text) && JSLiteralExpressionImpl.textIsIntegerValue(text);
    }

    private static boolean textIsIntegerValue(String text) {
        return !text.contains(".") && (!text.contains("e") && !text.contains("E") || JSLiteralExpressionImpl.textHasHexPrefix(text));
    }

    private static boolean textHasHexPrefix(String text) {
        return text.startsWith("0x") || text.startsWith("0X");
    }

    private static boolean textHasBinaryPrefix(String text) {
        return text.startsWith("0b") || text.startsWith("0B");
    }

    private static boolean textHasOctalPrefix(String text) {
        return JSLiteralExpressionImpl.textHasOctalJSPrefix(text) || JSLiteralExpressionImpl.textHasOctalES6Prefix(text);
    }

    public static boolean textHasOctalES6Prefix(String text) {
        return text.startsWith("0o") || text.startsWith("0O");
    }

    private static boolean textHasOctalJSPrefix(String text) {
        return text.startsWith("0") && !"0".equals(text) && !JSLiteralExpressionImpl.textHasHexPrefix(text) && !JSLiteralExpressionImpl.textHasBinaryPrefix(text);
    }

    @Nullable
    public String getNumericLiteralTextWithoutPrefix() {
        if (!this.isNumericLiteral()) {
            return null;
        }
        String text = this.getText();
        if (!JSLiteralExpressionImpl.textIsIntegerValue(text)) {
            return text;
        }
        if (JSLiteralExpressionImpl.textHasBinaryPrefix(text) || JSLiteralExpressionImpl.textHasHexPrefix(text) || JSLiteralExpressionImpl.textHasOctalES6Prefix(text)) {
            return text.substring(2);
        }
        if (JSLiteralExpressionImpl.textHasOctalJSPrefix(text)) {
            return text.substring(1);
        }
        return this.getText();
    }

    public boolean isNumericLiteral() {
        return this.getNode().findChildByType(JSTokenTypes.NUMERIC_LITERAL) != null;
    }

    public boolean isBooleanLiteral() {
        return this.getNode().findChildByType(JSTokenTypes.BOOLEAN_LITERALS) != null;
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression((JSExpression)this, other);
    }

    @Override
    @Nullable
    public JSElementIndexingData calculateIndexingData() {
        return JSLiteralImplicitElementProvidersRegistry.calculateIndexingData(this);
    }

    @Nullable
    public String getValueAsPropertyName() {
        String text = this.getText();
        if (this.isQuotedLiteral() && !StringUtil.isJavaIdentifier((String)(text = StringUtil.unquoteString((String)text)))) {
            text = null;
        }
        return text;
    }

    @Nullable
    public Object getValue() {
        String expressionText = this.getText();
        if (StringUtil.isEmpty((String)expressionText)) {
            return null;
        }
        if (this.isNumericLiteral()) {
            try {
                String numberValue;
                if (!JSLiteralExpressionImpl.textIsIntegerValue(expressionText)) {
                    return Double.parseDouble(expressionText);
                }
                int radix = 10;
                if (this.isHexLiteral()) {
                    radix = 16;
                }
                if (this.isOctalLiteral()) {
                    radix = 8;
                }
                if (this.isBinaryLiteral()) {
                    radix = 2;
                }
                if ((numberValue = this.getNumericLiteralTextWithoutPrefix()) == null) {
                    return 0L;
                }
                return new BigInteger(numberValue, radix).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (this.isBooleanLiteral()) {
            return null != this.findChildByType(JSTokenTypes.TRUE_KEYWORD);
        }
        if (this.isQuotedLiteral()) {
            return StringUtil.unquoteString((String)expressionText);
        }
        return this.getText();
    }

    @Nullable
    public String getSignificantValue() {
        JSLiteralExpressionStub stub = (JSLiteralExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.getSignificantValue();
        }
        FrameworkIndexingHandler[] extensions = (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            if (!extensions[i].hasSignificantValue(this)) continue;
            return this.getText();
        }
        return null;
    }

    public static boolean isNullExpression(@NotNull ASTNode literalExpression) {
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl", "isNullExpression"));
        }
        return literalExpression.findChildByType(JSTokenTypes.NULL_KEYWORD) != null;
    }
}

