/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.psi.PsiElement;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImplicitFunctionStructureImpl
extends JSImplicitElementStructureImpl {
    @NotNull
    private final List<JSImplicitParameterStructure> myParameters;

    public JSImplicitFunctionStructureImpl(@NotNull JSImplicitElementImpl.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionStructureImpl", "<init>"));
        }
        super(builder);
        this.myParameters = builder.myParameters != null ? builder.myParameters : Collections.emptyList();
    }

    @NotNull
    public List<JSImplicitParameterStructure> getParameters() {
        List<JSImplicitParameterStructure> list = this.myParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionStructureImpl", "getParameters"));
        }
        return list;
    }

    public boolean isGetProperty() {
        return ((EnumSet)this.readFlag(PROPERTIES_FLAG)).contains(JSImplicitElement.Property.GetFunction);
    }

    public boolean isSetProperty() {
        return ((EnumSet)this.readFlag(PROPERTIES_FLAG)).contains(JSImplicitElement.Property.SetFunction);
    }

    @Override
    @NotNull
    public JSImplicitFunctionImpl toImplicitElement(@Nullable PsiElement provider) {
        JSImplicitFunctionImpl jSImplicitFunctionImpl = new JSImplicitFunctionImpl(this, this.myParameters, provider);
        if (jSImplicitFunctionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionStructureImpl", "toImplicitElement"));
        }
        return jSImplicitFunctionImpl;
    }

    @Override
    public void serialize(@NotNull DataOutput dataStream) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionStructureImpl", "serialize"));
        }
        super.serialize(dataStream);
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)this.myParameters.size());
        for (JSImplicitParameterStructure parameter : this.myParameters) {
            parameter.serialize(dataStream);
        }
    }

    static void deserializeParameters(DataInput dataStream, JSImplicitElementImpl.Builder builder) throws IOException {
        int b = DataInputOutputUtil.readINT((DataInput)dataStream);
        ArrayList<JSImplicitParameterStructure> parameters = new ArrayList<JSImplicitParameterStructure>();
        while (b-- > 0) {
            JSImplicitParameterStructure p = JSImplicitParameterStructure.deserialize(dataStream);
            parameters.add(p);
        }
        builder.setParameters(parameters);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof JSImplicitFunctionStructureImpl)) {
            return false;
        }
        return super.equals(obj) && this.myParameters.equals(((JSImplicitFunctionStructureImpl)obj).myParameters);
    }
}

