/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSArrayTypeImpl
extends JSTypeBaseImpl
implements JSArrayType,
JSType.CompositeStructure {
    @NotNull
    private final JSType myType;
    @Nullable
    private JSGenericTypeImpl myNamedArray;

    @Override
    @NotNull
    public JSGenericTypeImpl asGenericType() {
        if (this.myNamedArray != null) {
            JSGenericTypeImpl jSGenericTypeImpl = this.myNamedArray;
            if (jSGenericTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "asGenericType"));
            }
            return jSGenericTypeImpl;
        }
        JSGenericTypeImpl jSGenericTypeImpl = this.myNamedArray = JSArrayType.GenericArrayBuilder.getGenericType(this, this.myType);
        if (jSGenericTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "asGenericType"));
        }
        return jSGenericTypeImpl;
    }

    public JSArrayTypeImpl(JSType type, @NotNull JSTypeSource typeSource) {
        if (typeSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSource", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "<init>"));
        }
        super(typeSource);
        this.myType = type != null ? type : JSAnyType.get((PsiElement)typeSource.getScope(), false);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myType.accept(visitor);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.CODE && this.isEcma()) {
            if ("Array" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "getTypeText"));
            }
            return "Array";
        }
        boolean wrapInBrackets = JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
        StringBuilder builder = new StringBuilder();
        if (wrapInBrackets) {
            builder.append("(");
        }
        builder.append(this.myType.getTypeText(format));
        if (wrapInBrackets) {
            builder.append(")");
        }
        builder.append("[]");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        if (!this.isEcma()) {
            return null;
        }
        PsiElement clazz = JSResolveUtil.findType("Array", (PsiElement)this.getScope(), true);
        if (clazz instanceof JSClass) {
            return (JSClass)clazz;
        }
        return null;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        if (elementType instanceof JSArrayTypeImpl) {
            return this.myType.isDirectlyAssignableType(((JSArrayTypeImpl)elementType).getType(), processingContext);
        }
        if (elementType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)elementType;
            if (JSArrayTypeImpl.isGenericArray(genericType)) {
                return this.myType.isDirectlyAssignableType(genericType.getArguments().get(0), processingContext);
            }
            return this.asGenericType().isDirectlyAssignableType(elementType, processingContext);
        }
        if (elementType instanceof JSPrimitiveArrayType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "isDirectlyAssignableTypeCommon"));
        }
        JSTypeCastUtil.AssignableResult assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext);
        if (assignableResult.isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult2;
        }
        JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.asGenericType().isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "isDirectlyAssignableTypeCommon"));
        }
        return assignableResult3;
    }

    public static boolean isGenericArray(JSGenericTypeImpl genericType) {
        return genericType.getType() instanceof JSPrimitiveArrayType && genericType.getArguments().size() == 1;
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "isEquivalentToImpl"));
        }
        if (type instanceof JSArrayTypeImpl && this.myType.isEquivalentTo(((JSArrayTypeImpl)type).getType(), processingContext, allowResolve)) {
            return true;
        }
        if (type instanceof JSGenericTypeImpl) {
            if (JSArrayTypeImpl.isGenericArray((JSGenericTypeImpl)type)) {
                return this.myType.isEquivalentTo(((JSGenericTypeImpl)type).getArguments().get(0), processingContext, allowResolve);
            }
            return this.asGenericType().isEquivalentTo(type, processingContext, allowResolve);
        }
        return false;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "getType"));
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        JSType newComponentType;
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "copyTypeHierarchy"));
        }
        JSType oldComponentType = this.getType();
        if (oldComponentType == (newComponentType = JSTypeUtils.transformTypeHierarchySafe(oldComponentType, childTransform))) {
            JSArrayTypeImpl jSArrayTypeImpl = this;
            if (jSArrayTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "copyTypeHierarchy"));
            }
            return jSArrayTypeImpl;
        }
        JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(newComponentType, this.getSource());
        if (jSArrayTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "copyTypeHierarchy"));
        }
        return jSArrayTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "copyWithNewSource"));
        }
        JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(this.getType(), source);
        if (jSArrayTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl", "copyWithNewSource"));
        }
        return jSArrayTypeImpl;
    }
}

