/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntersectionTypeImpl
extends JSCompositeTypeBaseImpl
implements JSUnionOrIntersectionType {
    public static final String SEPARATOR = "&";

    public static JSType getIntersectionType(@NotNull Collection<JSType> types, JSTypeSource source) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl", "getIntersectionType"));
        }
        LinkedHashSet plainTypes = ContainerUtil.newLinkedHashSet();
        JSIntersectionTypeImpl.addTypesOverIntersection(types, plainTypes);
        if (plainTypes.size() == 0) {
            return JSAnyType.get(null, false);
        }
        if (plainTypes.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem((Collection)plainTypes);
        }
        if (JSIntersectionTypeImpl.hasAnyType(plainTypes)) {
            JSType item = (JSType)ContainerUtil.getFirstItem((Collection)plainTypes);
            assert (item != null);
            return JSAnyType.get(null, true);
        }
        return new JSIntersectionTypeImpl(source, plainTypes);
    }

    public static boolean hasAnyType(@NotNull Collection<JSType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl", "hasAnyType"));
        }
        for (JSType type : types) {
            if (!(type instanceof JSAnyType)) continue;
            return true;
        }
        return false;
    }

    private static void addTypesOverIntersection(@Nullable Collection<JSType> typesToAdd, @NotNull Collection<JSType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl", "addTypesOverIntersection"));
        }
        if (typesToAdd == null) {
            return;
        }
        for (JSType type : typesToAdd) {
            if (type instanceof JSIntersectionTypeImpl) {
                JSIntersectionTypeImpl.addTypesOverIntersection(((JSIntersectionTypeImpl)type).getTypes(), types);
                continue;
            }
            types.add(type);
        }
    }

    public JSIntersectionTypeImpl(JSTypeSource source, Collection<JSType> _types) {
        super(source, _types);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        if (this.isEquivalentTo(elementType, processingContext)) {
            return true;
        }
        boolean allAssignable = true;
        for (JSType type : this.getTypes()) {
            if (type.isDirectlyAssignableType(elementType, processingContext)) continue;
            allAssignable = false;
            break;
        }
        if (allAssignable) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    protected String getTypeSeparator() {
        return SEPARATOR;
    }

    @Override
    protected JSIntersectionTypeImpl createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource) {
        if (transformedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformedTypes", "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl", "createType"));
        }
        if (newSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSource", "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl", "createType"));
        }
        return new JSIntersectionTypeImpl(newSource, transformedTypes);
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType result = this.getSimpleCompositeTypeResult();
        if (result != null) {
            JSType jSType = result;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl", "substitute"));
            }
            return jSType;
        }
        Collection<JSRecordType> resolvedTypes = this.getNestedTypesAsRecordType();
        if (resolvedTypes.isEmpty()) {
            JSAnyType jSAnyType = JSAnyType.get(this.getSource().getSourceElement(), this.isExplicitlyDeclared());
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl", "substitute"));
            }
            return jSAnyType;
        }
        ArrayList resultMembers = ContainerUtil.newArrayList();
        LinkedMultiMap map = new LinkedMultiMap();
        for (JSRecordType resolvedType : resolvedTypes) {
            for (JSRecordType.TypeMember member : resolvedType.getTypeMembers()) {
                if (member instanceof JSRecordType.PropertySignature) {
                    JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)member;
                    map.putValue((Object)propertySignature.getMemberName(), (Object)propertySignature);
                    continue;
                }
                resultMembers.add(member);
            }
        }
        if (map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                Collection value = (Collection)entry.getValue();
                if (value.size() == 1) {
                    resultMembers.add(ContainerUtil.getFirstItem((Collection)value));
                    continue;
                }
                boolean isOptional = true;
                ArrayList types = ContainerUtil.newArrayList();
                PsiElement propertySource = null;
                for (JSRecordType.PropertySignature signature : value) {
                    if (!signature.isOptional()) {
                        isOptional = false;
                    }
                    if (signature.getType() == null) continue;
                    types.add(signature.getType());
                    propertySource = signature.getSource();
                }
                JSType resultType = JSIntersectionTypeImpl.getIntersectionType(types, this.getSource());
                if (types.size() != 1) {
                    propertySource = null;
                }
                resultMembers.add(new JSRecordTypeImpl.PropertySignatureImpl((String)entry.getKey(), resultType, isOptional, propertySource));
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), resultMembers);
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl", "substitute"));
        }
        return jSRecordTypeImpl;
    }
}

