/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeSourceFactory {
    @NotNull
    public static JSTypeSource createTypeSource(@NotNull PsiElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory", "createTypeSource"));
        }
        JSTypeSource jSTypeSource = JSTypeSourceFactory.createTypeSource(scope, false);
        if (jSTypeSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory", "createTypeSource"));
        }
        return jSTypeSource;
    }

    @NotNull
    public static JSTypeSource createTypeSource(@Nullable PsiElement scope, boolean isExplicitlyDeclared) {
        PsiFile file = scope != null ? scope.getContainingFile() : null;
        JSTypeSource jSTypeSource = new JSTypeSource(file, scope, JSTypeSourceFactory.sourceFileLanguage(file), isExplicitlyDeclared);
        if (jSTypeSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory", "createTypeSource"));
        }
        return jSTypeSource;
    }

    public static JSTypeSource copyTypeSource(JSTypeSource source, boolean isExplicitlyDeclared) {
        return new JSTypeSource(source.getScope(), source.getSourceElement(), source.getLanguage(), isExplicitlyDeclared);
    }

    @NotNull
    public static JSTypeSource.SourceLanguage sourceFileLanguage(PsiFile file) {
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(file);
        JSTypeSource.SourceLanguage sourceLanguage = dialect != null ? JSTypeSourceFactory.ofDialectOptionsHolder(dialect) : JSTypeSource.SourceLanguage.JS;
        if (sourceLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory", "sourceFileLanguage"));
        }
        return sourceLanguage;
    }

    @NotNull
    private static JSTypeSource.SourceLanguage ofDialectOptionsHolder(@NotNull DialectOptionHolder dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory", "ofDialectOptionsHolder"));
        }
        switch (dialect) {
            case ECMA_4: {
                JSTypeSource.SourceLanguage sourceLanguage = JSTypeSource.SourceLanguage.AS;
                if (sourceLanguage == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory", "ofDialectOptionsHolder"));
                }
                return sourceLanguage;
            }
            case TS: 
            case TSX: {
                JSTypeSource.SourceLanguage sourceLanguage = JSTypeSource.SourceLanguage.TS;
                if (sourceLanguage == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory", "ofDialectOptionsHolder"));
                }
                return sourceLanguage;
            }
        }
        JSTypeSource.SourceLanguage sourceLanguage = JSTypeSource.SourceLanguage.JS;
        if (sourceLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory", "ofDialectOptionsHolder"));
        }
        return sourceLanguage;
    }
}

