/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractSuperProcessor;
import com.intellij.lang.javascript.refactoring.ui.JSReferenceEditor;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseDialog;
import com.intellij.util.ThreeState;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public abstract class JSExtractSuperBaseDialog
extends ExtractSuperBaseDialog<JSClass, JSMemberInfo> {
    private static final String DESTINATION_PACKAGE_RECENT_KEY = "JSExtractSuperBase.RECENT_KEYS";
    private JRadioButton myExtractAndTurnRefsRB;

    public JSExtractSuperBaseDialog(Project project, JSClass sourceClass, List<JSMemberInfo> members, String refactoringName) {
        super(project, (PsiElement)sourceClass, members, refactoringName);
    }

    protected void customizeRadiobuttons(Box box, ButtonGroup buttonGroup) {
        this.myExtractAndTurnRefsRB = new JRadioButton(JSBundle.message((String)"extract.0.turn.refs", (Object[])new Object[]{StringUtil.decapitalize((String)this.getEntityName())}));
        buttonGroup.add(this.myExtractAndTurnRefsRB);
        box.add((Component)this.myExtractAndTurnRefsRB, 1);
        this.myExtractAndTurnRefsRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JSExtractSuperBaseDialog.this.updateDialog();
            }
        });
    }

    protected ComponentWithBrowseButton createPackageNameField() {
        String packageName = StringUtil.getPackageName((String)((JSClass)this.mySourceClass).getQualifiedName());
        return JSReferenceEditor.forPackageName(packageName, this.myProject, DESTINATION_PACKAGE_RECENT_KEY, this.getScope(), RefactoringBundle.message((String)"choose.destination.package"));
    }

    protected String getTargetPackageName() {
        return ((JSReferenceEditor)this.myPackageNameField).getText();
    }

    protected JTextField createSourceClassField() {
        JTextField result = new JTextField(((JSClass)this.mySourceClass).getQualifiedName());
        result.setEditable(false);
        return result;
    }

    @Nullable
    protected String validateName(String name) {
        if ("".equals(name)) {
            return RefactoringBundle.message((String)"no.destination.class.specified");
        }
        if (!JSUtils.isValidClassName(name, false)) {
            return JSBundle.message((String)"0.is.not.a.legal.name", (Object[])new Object[]{name});
        }
        return null;
    }

    protected void preparePackage() throws ExtractSuperBaseDialog.OperationFailedException {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.mySourceClass);
        PsiDirectory baseDir = PlatformPackageUtil.getDirectory((PsiElement)this.mySourceClass);
        this.myTargetDirectory = JSRefactoringUtil.chooseOrCreateDirectoryForClass(this.myProject, module, this.getScope(), this.getTargetPackageName(), this.getExtractedSuperName(), baseDir, ThreeState.UNSURE);
        if (this.myTargetDirectory == null) {
            throw new ExtractSuperBaseDialog.OperationFailedException("");
        }
    }

    private GlobalSearchScope getScope() {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.mySourceClass);
        PsiDirectory baseDir = PlatformPackageUtil.getDirectory((PsiElement)this.mySourceClass);
        if (this.getMode() == JSExtractSuperProcessor.Mode.RenameImplementation) {
            return PlatformPackageUtil.adjustScope((PsiDirectory)baseDir, (GlobalSearchScope)GlobalSearchScope.moduleWithDependentsScope((Module)module), (boolean)true, (boolean)false);
        }
        return PlatformPackageUtil.adjustScope((PsiDirectory)baseDir, (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)module), (boolean)false, (boolean)true);
    }

    protected String getDestinationPackageRecentKey() {
        return DESTINATION_PACKAGE_RECENT_KEY;
    }

    public Collection<JSMemberInfo> getSelectedMemberInfos() {
        return Arrays.asList(JSMemberInfo.getSelected(this.myMemberInfos, (JSClass)this.mySourceClass, (Condition<JSMemberInfo>)Conditions.alwaysTrue()));
    }

    protected void executeRefactoring() {
        this.invokeRefactoring(this.createProcessor());
    }

    protected JSExtractSuperProcessor.Mode getMode() {
        if (this.isExtractSuperclass()) {
            return JSExtractSuperProcessor.Mode.ExtractSuper;
        }
        if (this.myExtractAndTurnRefsRB != null && this.myExtractAndTurnRefsRB.isSelected()) {
            return JSExtractSuperProcessor.Mode.ExtractSuperTurnRefs;
        }
        return JSExtractSuperProcessor.Mode.RenameImplementation;
    }

    protected static List<JSMemberInfo> collectMembers(JSClass sourceClass, JSElement selectedElement, boolean pullingToInterface) {
        ArrayList<JSMemberInfo> result = new ArrayList<JSMemberInfo>();
        MemberInfoBase.Filter<JSAttributeListOwner> filter = pullingToInterface ? new MemberInfoBase.Filter<JSAttributeListOwner>(){

            public boolean includeMember(JSAttributeListOwner member) {
                return member instanceof JSClass || member instanceof JSFunction && !member.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC);
            }
        } : new MemberInfoBase.EmptyFilter();
        JSMemberInfo.extractClassMembers(sourceClass, result, filter);
        JSMemberInfo.sortByOffset(result);
        for (JSMemberInfo memberInfo : result) {
            memberInfo.setChecked(Collections.singletonList(selectedElement));
        }
        return result;
    }

    protected String getDocCommentPanelName() {
        return JSBundle.message((String)"asdoc", (Object[])new Object[0]);
    }

    protected int getDocCommentPolicySetting() {
        return 1;
    }

    protected void setDocCommentPolicySetting(int policy) {
    }

    protected void updateDialog() {
        super.updateDialog();
        boolean canSetPackage = this.getMode() != JSExtractSuperProcessor.Mode.RenameImplementation || !JSResolveUtil.isFileLocalSymbol(this.mySourceClass);
        this.myPackageNameField.setEnabled(canSetPackage);
        this.myPackageNameLabel.setEnabled(canSetPackage);
        ((JSReferenceEditor)this.myPackageNameField).setScope(this.getScope());
    }
}

