/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public interface JSLanguageServiceProvider {
    public static final ExtensionPointName<JSLanguageServiceProvider> EP = ExtensionPointName.create((String)"JavaScript.LanguageServiceProvider");

    public static List<JSLanguageService> getLanguageServices(Project project) {
        JSLanguageServiceProvider[] filters = JSLanguageServiceProvider.getProviders(project);
        if (filters.length == 0) {
            return ContainerUtil.emptyList();
        }
        return Arrays.stream(filters).map(el -> el.getService()).collect(Collectors.toList());
    }

    @NotNull
    public static JSLanguageServiceProvider[] getProviders(Project project) {
        if (!Extensions.getArea((AreaInstance)project).hasExtensionPoint(EP.getName())) {
            JSLanguageServiceProvider[] jSLanguageServiceProviderArray = new JSLanguageServiceProvider[]{};
            if (jSLanguageServiceProviderArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceProvider", "getProviders"));
            }
            return jSLanguageServiceProviderArray;
        }
        JSLanguageServiceProvider[] jSLanguageServiceProviderArray = (JSLanguageServiceProvider[])EP.getExtensions((AreaInstance)project);
        if (jSLanguageServiceProviderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceProvider", "getProviders"));
        }
        return jSLanguageServiceProviderArray;
    }

    @NotNull
    public JSLanguageService getService();
}

