/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class MarkerPsiElementPointer {
    private final PsiFile containingFile;
    private final RangeMarker marker;
    private final Class contextClass;

    public MarkerPsiElementPointer(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/validation/fixes/MarkerPsiElementPointer", "<init>"));
        }
        this.containingFile = context.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)context.getProject()).getDocument(this.containingFile);
        this.marker = document.createRangeMarker(context.getTextRange());
        this.contextClass = context.getClass();
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement elementAt;
        PsiElement parent;
        assert (this.containingFile.isValid());
        int offset = this.marker.getStartOffset();
        if (offset >= this.containingFile.getTextLength()) {
            offset = this.containingFile.getTextLength() - 1;
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)(elementAt = this.containingFile.getViewProvider().findElementAt(offset)), (Class)this.contextClass, (boolean)false)) == null) {
            throw new IllegalStateException("lost parent of type " + this.contextClass + " at offset " + offset);
        }
        PsiElement psiElement = parent;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/MarkerPsiElementPointer", "getElement"));
        }
        return psiElement;
    }
}

