/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceAnnotationResult
extends JSLanguageServiceAnnotationResult {
    public static final int CANNOT_FIND_NAME_CODE = 2304;

    public TypeScriptLanguageServiceAnnotationResult(@NotNull String errorText, @Nullable String fileAbsolutePath, @Nullable String category, int line, int column, int lineEnd, int columnEnd) {
        if (errorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorText", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceAnnotationResult", "<init>"));
        }
        super(errorText, fileAbsolutePath, category, line, column, lineEnd, columnEnd);
    }

    public int getErrorCode() {
        String prefix = "TS";
        if (this.myErrorText.startsWith(prefix)) {
            int endCode = this.myErrorText.indexOf(":");
            if (endCode == -1) {
                return -1;
            }
            String code = this.myErrorText.substring(prefix.length(), endCode);
            try {
                return Integer.valueOf(code.trim());
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public ProblemHighlightType getHighlightType() {
        int code = this.getErrorCode();
        if (code != -1 && 2304 == code) {
            return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        }
        return null;
    }
}

