/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.ES6CodeStyleImportsPanel;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListItemsDialogWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCodeStyleImportsPanel
extends ES6CodeStyleImportsPanel {
    protected JBCheckBox myUseNodeModulesResolutionImports;
    protected TextFieldWithBrowseButton myBlacklistImports;

    public TypeScriptCodeStyleImportsPanel() {
        super(TypeScriptCodeStyleSettings.class);
    }

    @Override
    protected void fillGeneralPanel(@NotNull OptionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/lang/typescript/formatter/TypeScriptCodeStyleImportsPanel", "fillGeneralPanel"));
        }
        super.fillGeneralPanel(group);
        this.myUseNodeModulesResolutionImports = new JBCheckBox(JSBundle.message((String)"js.import.options.use.node.resolution", (Object[])new Object[0]));
        this.myBlacklistImports = new TextFieldWithBrowseButton();
        TypeScriptCodeStyleImportsPanel.customizeField(this.myBlacklistImports);
        group.add((JComponent)this.myUseNodeModulesResolutionImports);
        LabeledComponent bannedListWithLabel = LabeledComponent.create((JComponent)this.myBlacklistImports, (String)JSBundle.message((String)"typescript.import.options.blacklist.title", (Object[])new Object[0]), (String)"West");
        bannedListWithLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)bannedListWithLabel, "West");
        group.add((JComponent)wrapper);
    }

    @Override
    public boolean isModified(@NotNull CodeStyleSettings commonSettings) {
        if (commonSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonSettings", "com/intellij/lang/typescript/formatter/TypeScriptCodeStyleImportsPanel", "isModified"));
        }
        JSCodeStyleSettings jsSettings = this.getCustomJSSettings(commonSettings);
        return super.isModified(commonSettings) || this.getUseNodeModulesResolution(jsSettings) != this.myUseNodeModulesResolutionImports.isSelected() || !StringUtil.equals((CharSequence)TypeScriptCodeStyleImportsPanel.getBannedListString(jsSettings), (CharSequence)this.myBlacklistImports.getText());
    }

    @Override
    public void reset(@NotNull CodeStyleSettings commonSettings) {
        if (commonSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonSettings", "com/intellij/lang/typescript/formatter/TypeScriptCodeStyleImportsPanel", "reset"));
        }
        super.reset(commonSettings);
        JSCodeStyleSettings jsSettings = this.getCustomJSSettings(commonSettings);
        this.myUseNodeModulesResolutionImports.setSelected(this.getUseNodeModulesResolution(jsSettings));
        this.myBlacklistImports.setText(TypeScriptCodeStyleImportsPanel.getBannedListString(jsSettings));
    }

    @Override
    public void apply(@NotNull CodeStyleSettings commonSettings) {
        if (commonSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonSettings", "com/intellij/lang/typescript/formatter/TypeScriptCodeStyleImportsPanel", "apply"));
        }
        super.apply(commonSettings);
        JSCodeStyleSettings jsSettings = this.getCustomJSSettings(commonSettings);
        this.applyUseNodeModulesResolution(jsSettings, this.myUseNodeModulesResolutionImports.isSelected());
        TypeScriptCodeStyleImportsPanel.applyBlacklist(jsSettings, this.myBlacklistImports.getText());
    }

    private static String getBannedListString(@NotNull JSCodeStyleSettings jsSettings) {
        if (jsSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsSettings", "com/intellij/lang/typescript/formatter/TypeScriptCodeStyleImportsPanel", "getBannedListString"));
        }
        return jsSettings.BLACKLIST_IMPORTS;
    }

    private boolean getUseNodeModulesResolution(@NotNull JSCodeStyleSettings jsSettings) {
        if (jsSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsSettings", "com/intellij/lang/typescript/formatter/TypeScriptCodeStyleImportsPanel", "getUseNodeModulesResolution"));
        }
        JSCodeStyleSettings.BooleanWithGlobalOption value = jsSettings.IMPORT_USE_NODE_RESOLUTION;
        return value == JSCodeStyleSettings.BooleanWithGlobalOption.GLOBAL ? this.appSettings.isUseNodeModulesResolutionImports() : value == JSCodeStyleSettings.BooleanWithGlobalOption.TRUE;
    }

    private void applyUseNodeModulesResolution(@NotNull JSCodeStyleSettings jsSettings, boolean value) {
        if (jsSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsSettings", "com/intellij/lang/typescript/formatter/TypeScriptCodeStyleImportsPanel", "applyUseNodeModulesResolution"));
        }
        if (this.appSettings.isUseNodeModulesResolutionImports() == value) {
            jsSettings.IMPORT_USE_NODE_RESOLUTION = JSCodeStyleSettings.BooleanWithGlobalOption.GLOBAL;
            return;
        }
        jsSettings.IMPORT_USE_NODE_RESOLUTION = value ? JSCodeStyleSettings.BooleanWithGlobalOption.TRUE : JSCodeStyleSettings.BooleanWithGlobalOption.FALSE;
    }

    @Override
    @NotNull
    protected String getAbsolutePathCheckboxTitle() {
        String string = JSBundle.message((String)"typescript.import.options.use.config", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/formatter/TypeScriptCodeStyleImportsPanel", "getAbsolutePathCheckboxTitle"));
        }
        return string;
    }

    private static void customizeField(TextFieldWithBrowseButton uiField) {
        ListItemsDialogWrapper.installListItemsDialogForTextField((TextFieldWithBrowseButton)uiField, () -> new ListItemsDialogWrapper(JSBundle.message((String)"typescript.import.options.blacklist.change.button", (Object[])new Object[0])){

            protected String createAddItemDialog() {
                return Messages.showInputDialog((String)JSBundle.message((String)"typescript.import.options.blacklist.change.dialog.text", (Object[])new Object[0]), (String)JSBundle.message((String)"typescript.import.options.blacklist.change.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            }
        });
    }

    private static void applyBlacklist(@NotNull JSCodeStyleSettings jsSettings, @Nullable String value) {
        if (jsSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsSettings", "com/intellij/lang/typescript/formatter/TypeScriptCodeStyleImportsPanel", "applyBlacklist"));
        }
        jsSettings.BLACKLIST_IMPORTS = StringUtil.notNullize((String)StringUtil.trim((String)value));
    }
}

