/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class DefaultNotLastCaseInSwitchJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/DefaultNotLastCaseInSwitchJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("default.not.last.case.in.switch.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/DefaultNotLastCaseInSwitchJSInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("default.branch.not.last.case.in.switch.error.string", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/DefaultNotLastCaseInSwitchJSInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DefaultNotLastCaseInSwitchVisitor();
    }

    private static class DefaultNotLastCaseInSwitchVisitor
    extends BaseInspectionVisitor {
        private DefaultNotLastCaseInSwitchVisitor() {
        }

        public void visitJSSwitchStatement(@NotNull JSSwitchStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/DefaultNotLastCaseInSwitchJSInspection$DefaultNotLastCaseInSwitchVisitor", "visitJSSwitchStatement"));
            }
            super.visitJSSwitchStatement(statement);
            JSCaseClause[] caseClauses = statement.getCaseClauses();
            if (caseClauses == null) {
                return;
            }
            for (int i = 0; i < caseClauses.length - 1; ++i) {
                JSCaseClause caseClause = caseClauses[i];
                if (!caseClause.isDefault()) continue;
                this.registerError(caseClause.getFirstChild());
            }
        }
    }
}

