/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import java.util.Collections;
import java.util.List;

public abstract class BatchDocumentJob
extends CompositeJob {
    private List<Job> subJobs;

    public BatchDocumentJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    public final List<Job> getSubJobs() {
        if (this.subJobs == null) {
            this.subJobs = Collections.unmodifiableList(this.makeSubJobs());
            assert (this.subJobs != null);
        }
        return this.subJobs;
    }

    @Override
    public final boolean isExecutable() {
        return !this.getSubJobs().isEmpty();
    }

    @Override
    public void execute() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        for (Job subJob : this.getSubJobs()) {
            subJob.execute();
        }
        fxomDocument.endUpdate();
    }

    @Override
    public void undo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        for (int i = this.getSubJobs().size() - 1; i >= 0; --i) {
            this.getSubJobs().get(i).undo();
        }
        fxomDocument.endUpdate();
    }

    @Override
    public void redo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        for (Job subJob : this.getSubJobs()) {
            subJob.redo();
        }
        fxomDocument.endUpdate();
    }

    protected abstract List<Job> makeSubJobs();
}

