/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import javafx.scene.input.InputEvent;
import javafx.scene.input.ZoomEvent;
import javafx.scene.layout.Pane;

public class ZoomGesture
extends AbstractGesture {
    private AbstractGesture.Observer observer;

    public ZoomGesture(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    @Override
    public void start(InputEvent e, AbstractGesture.Observer observer) {
        assert (e != null);
        assert (e.getEventType() == ZoomEvent.ZOOM_STARTED);
        assert (observer != null);
        this.observer = observer;
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        assert (glassLayer.getOnZoom() == null);
        assert (glassLayer.getOnZoomFinished() == null);
        glassLayer.setOnZoom(e1 -> this.updateContentPanelScaling((ZoomEvent)e1));
        glassLayer.setOnZoomFinished(e1 -> this.performTermination());
    }

    private void updateContentPanelScaling(ZoomEvent e) {
        assert (!Double.isNaN(e.getZoomFactor()));
        double scaling = this.contentPanelController.getScaling();
        this.contentPanelController.setScaling(Math.min(5.0, scaling * e.getZoomFactor()));
    }

    private void performTermination() {
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        glassLayer.setOnZoom(null);
        glassLayer.setOnZoomFinished(null);
        this.observer.gestureDidTerminate(this);
        this.observer = null;
    }
}

