/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifyCacheHintJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifySelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyFxIdJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.ModifySelectionToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AnchorPaneConstraintsEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.BooleanEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.BoundedDoubleEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.ButtonTypeEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.ColumnResizePolicyEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.CursorEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.DividerPositionsEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.DoubleEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.Editor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EnumEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EventHandlerEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.FxIdEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.GenericEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.I18nStringEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.ImageEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.InsetsEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.IntegerEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.Point3DEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertiesEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.RotateEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.StringEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.StyleClassEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.StyleEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.StylesheetEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.TextAlignmentEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.ToggleGroupEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.BoundsPopupEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.EffectPopupEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.FontPopupEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.KeyCombinationPopupEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.PaintPopupEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.Rectangle2DPopupEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMFxIdIndex;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.glossary.Glossary;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.BooleanPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.BoundsPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.CursorPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.EnumerationPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.EventHandlerPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.FontPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ImagePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.InsetsPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.IntegerPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.Point3DPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.Rectangle2DPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.StringPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.TableViewResizePolicyPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ToggleGroupPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.TreeTableViewResizePolicyPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.effect.EffectPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.keycombination.KeyCombinationPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.ListValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.paint.PaintPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ValuePropertyMetadataClassComparator;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ValuePropertyMetadataNameComparator;
import com.oracle.javafx.scenebuilder.kit.util.CssInternal;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Accordion;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class InspectorPanelController
extends AbstractFxmlPanelController {
    @FXML
    private TitledPane propertiesTitledPane;
    @FXML
    private ScrollPane propertiesScroll;
    @FXML
    private GridPane propertiesSection;
    @FXML
    private TitledPane layoutTitledPane;
    @FXML
    private ScrollPane layoutScroll;
    @FXML
    private GridPane layoutSection;
    @FXML
    private TitledPane codeTitledPane;
    @FXML
    private ScrollPane codeScroll;
    @FXML
    private GridPane codeSection;
    @FXML
    private TitledPane allTitledPane;
    @FXML
    private ScrollPane allScroll;
    @FXML
    private GridPane allContent;
    @FXML
    private StackPane searchStackPane;
    @FXML
    private GridPane searchContent;
    @FXML
    private Accordion accordion;
    @FXML
    private SplitPane inspectorRoot;
    private static final String fxmlFile = "Inspector.fxml";
    private static final String FXID_SUBSECTION_NAME = "Identity";
    private String searchPattern;
    private SectionId previousExpandedSection;
    private PropertyEditor lastPropertyEditorValueChanged = null;
    private boolean dragOnGoing = false;
    private final Stack<Editor> i18nStringEditorPool = new Stack();
    private final Stack<Editor> stringEditorPool = new Stack();
    private final Stack<Editor> doubleEditorPool = new Stack();
    private final Stack<Editor> integerEditorPool = new Stack();
    private final Stack<Editor> booleanEditorPool = new Stack();
    private final Stack<Editor> enumEditorPool = new Stack();
    private final Stack<Editor> effectPopupEditorPool = new Stack();
    private final Stack<Editor> fontPopupEditorPool = new Stack();
    private final Stack<Editor> genericEditorPool = new Stack();
    private final Stack<Editor> insetsEditorPool = new Stack();
    private final Stack<Editor> boundedDoubleEditorPool = new Stack();
    private final Stack<Editor> rotateEditorPool = new Stack();
    private final Stack<Editor> anchorPaneConstraintsEditorPool = new Stack();
    private final Stack<Editor> styleEditorPool = new Stack();
    private final Stack<Editor> styleClassEditorPool = new Stack();
    private final Stack<Editor> stylesheetEditorPool = new Stack();
    private final Stack<Editor> fxIdEditorPool = new Stack();
    private final Stack<Editor> eventHandlerEditorPool = new Stack();
    private final Stack<Editor> cursorEditorPool = new Stack();
    private final Stack<Editor> paintPopupEditorPool = new Stack();
    private final Stack<Editor> imageEditorPool = new Stack();
    private final Stack<Editor> boundsPopupEditorPool = new Stack();
    private final Stack<Editor> point3DEditorPool = new Stack();
    private final Stack<Editor> dividerPositionsEditorPool = new Stack();
    private final Stack<Editor> textAlignmentEditorPool = new Stack();
    private final Stack<Editor> keyCombinationPopupEditorPool = new Stack();
    private final Stack<Editor> columnResizePolicyEditorPool = new Stack();
    private final Stack<Editor> rectangle2DPopupEditorPool = new Stack();
    private final Stack<Editor> toggleGroupEditorPool = new Stack();
    private final Stack<Editor> buttonTypeEditorPool = new Stack();
    private final Stack<SubSectionTitle> subSectionTitlePool = new Stack();
    private final HashMap<Class<? extends Editor>, Stack<Editor>> editorPools = new HashMap();
    private final List<Editor> editorsInUse = new ArrayList<Editor>();
    private final List<SubSectionTitle> subSectionTitlesInUse = new ArrayList<SubSectionTitle>();
    private final SectionId[] sections = new SectionId[]{SectionId.PROPERTIES, SectionId.LAYOUT, SectionId.CODE};
    private final ObjectProperty<ViewMode> viewModeProperty = new SimpleObjectProperty();
    private final ObjectProperty<ShowMode> showModeProperty = new SimpleObjectProperty();
    private final ObjectProperty<SectionId> expandedSectionProperty = new SimpleObjectProperty();
    private SelectionState selectionState;
    private final EditorController editorController;
    private double searchResultDividerPosition;

    public InspectorPanelController(EditorController editorController) {
        super(InspectorPanelController.class.getResource(fxmlFile), I18N.getBundle(), editorController);
        this.editorController = editorController;
        this.viewModeProperty.setValue((Object)ViewMode.SECTION);
        this.viewModeProperty.addListener((ChangeListener)new ChangeListener<ViewMode>(){

            public void changed(ObservableValue<? extends ViewMode> arg0, ViewMode previousMode, ViewMode mode) {
                InspectorPanelController.this.viewModeChanged(previousMode, mode);
            }
        });
        this.showModeProperty.setValue((Object)ShowMode.ALL);
        this.showModeProperty.addListener((ChangeListener)new ChangeListener<ShowMode>(){

            public void changed(ObservableValue<? extends ShowMode> arg0, ShowMode previousMode, ShowMode mode) {
                InspectorPanelController.this.showModeChanged();
            }
        });
        this.expandedSectionProperty.setValue((Object)SectionId.PROPERTIES);
        this.expandedSectionProperty.addListener((ChangeListener)new ChangeListener<SectionId>(){

            public void changed(ObservableValue<? extends SectionId> arg0, SectionId previousSectionId, SectionId sectionId) {
                InspectorPanelController.this.expandedSectionChanged();
            }
        });
        this.editorPools.put(I18nStringEditor.class, this.i18nStringEditorPool);
        this.editorPools.put(StringEditor.class, this.stringEditorPool);
        this.editorPools.put(DoubleEditor.class, this.doubleEditorPool);
        this.editorPools.put(IntegerEditor.class, this.integerEditorPool);
        this.editorPools.put(BooleanEditor.class, this.booleanEditorPool);
        this.editorPools.put(EnumEditor.class, this.enumEditorPool);
        this.editorPools.put(EffectPopupEditor.class, this.effectPopupEditorPool);
        this.editorPools.put(FontPopupEditor.class, this.fontPopupEditorPool);
        this.editorPools.put(GenericEditor.class, this.genericEditorPool);
        this.editorPools.put(InsetsEditor.class, this.insetsEditorPool);
        this.editorPools.put(BoundedDoubleEditor.class, this.boundedDoubleEditorPool);
        this.editorPools.put(RotateEditor.class, this.rotateEditorPool);
        this.editorPools.put(AnchorPaneConstraintsEditor.class, this.anchorPaneConstraintsEditorPool);
        this.editorPools.put(StyleEditor.class, this.styleEditorPool);
        this.editorPools.put(StyleClassEditor.class, this.styleClassEditorPool);
        this.editorPools.put(StylesheetEditor.class, this.stylesheetEditorPool);
        this.editorPools.put(FxIdEditor.class, this.fxIdEditorPool);
        this.editorPools.put(EventHandlerEditor.class, this.eventHandlerEditorPool);
        this.editorPools.put(CursorEditor.class, this.cursorEditorPool);
        this.editorPools.put(PaintPopupEditor.class, this.paintPopupEditorPool);
        this.editorPools.put(ImageEditor.class, this.imageEditorPool);
        this.editorPools.put(BoundsPopupEditor.class, this.boundsPopupEditorPool);
        this.editorPools.put(Point3DEditor.class, this.point3DEditorPool);
        this.editorPools.put(DividerPositionsEditor.class, this.dividerPositionsEditorPool);
        this.editorPools.put(TextAlignmentEditor.class, this.textAlignmentEditorPool);
        this.editorPools.put(KeyCombinationPopupEditor.class, this.keyCombinationPopupEditorPool);
        this.editorPools.put(ColumnResizePolicyEditor.class, this.columnResizePolicyEditorPool);
        this.editorPools.put(Rectangle2DPopupEditor.class, this.rectangle2DPopupEditorPool);
        this.editorPools.put(ToggleGroupEditor.class, this.toggleGroupEditorPool);
        this.editorPools.put(ButtonTypeEditor.class, this.buttonTypeEditorPool);
    }

    public Accordion getAccordion() {
        return this.accordion;
    }

    public SectionId getExpandedSectionId() {
        SectionId result;
        if (!this.isInspectorLoaded()) {
            return null;
        }
        TitledPane expandedSection = this.accordion.getExpandedPane();
        if (expandedSection == null) {
            result = SectionId.NONE;
        } else if (expandedSection == this.propertiesTitledPane) {
            result = SectionId.PROPERTIES;
        } else if (expandedSection == this.layoutTitledPane) {
            result = SectionId.LAYOUT;
        } else if (expandedSection == this.codeTitledPane) {
            result = SectionId.CODE;
        } else {
            return null;
        }
        return result;
    }

    public ViewMode getViewMode() {
        return (ViewMode)((Object)this.viewModeProperty.getValue());
    }

    public void setViewMode(ViewMode mode) {
        assert (mode != null);
        this.viewModeProperty.setValue((Object)mode);
    }

    private void viewModeChanged(ViewMode previousMode, ViewMode mode) {
        if (!this.isInspectorLoaded()) {
            return;
        }
        if (previousMode == ViewMode.SECTION) {
            this.previousExpandedSection = this.getExpandedSectionId();
        }
        this.accordion.getPanes().clear();
        switch (mode) {
            case SECTION: {
                this.accordion.getPanes().addAll((Object[])new TitledPane[]{this.propertiesTitledPane, this.layoutTitledPane, this.codeTitledPane});
                if (this.previousExpandedSection == null) break;
                this.setExpandedSection(this.previousExpandedSection);
                break;
            }
            case PROPERTY_NAME: 
            case PROPERTY_TYPE: {
                this.accordion.getPanes().add((Object)this.allTitledPane);
                this.allTitledPane.setExpanded(true);
                this.rebuild();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected view mode " + (Object)((Object)mode));
            }
        }
        this.updateClassNameInSectionTitles();
    }

    public ShowMode getShowMode() {
        return (ShowMode)((Object)this.showModeProperty.getValue());
    }

    public void setShowMode(ShowMode mode) {
        assert (mode != null);
        this.showModeProperty.setValue((Object)mode);
    }

    private void showModeChanged() {
        if (!this.isInspectorLoaded()) {
            return;
        }
        this.rebuild();
    }

    public SectionId getExpandedSection() {
        return (SectionId)((Object)this.expandedSectionProperty.getValue());
    }

    public void setExpandedSection(SectionId sectionId) {
        assert (sectionId != null);
        this.expandedSectionProperty.setValue((Object)sectionId);
    }

    private void expandedSectionChanged() {
        TitledPane tp;
        if (!this.isInspectorLoaded()) {
            return;
        }
        switch (this.getExpandedSection()) {
            case NONE: {
                tp = null;
                break;
            }
            case PROPERTIES: {
                tp = this.propertiesTitledPane;
                break;
            }
            case LAYOUT: {
                tp = this.layoutTitledPane;
                break;
            }
            case CODE: {
                tp = this.codeTitledPane;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected section id " + (Object)((Object)this.getExpandedSection()));
            }
        }
        this.accordion.setExpandedPane(tp);
    }

    public boolean isEditedMode() {
        return this.getShowMode() == ShowMode.EDITED;
    }

    public String getSearchPattern() {
        return this.searchPattern;
    }

    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
        this.searchPatternDidChange();
    }

    @Override
    protected void fxomDocumentDidChange(FXOMDocument oldDocument) {
        if (this.isInspectorLoaded() && this.hasFxomDocument()) {
            this.selectionState.initialize();
            this.rebuild();
        }
    }

    @Override
    protected void sceneGraphRevisionDidChange() {
        if (!this.dragOnGoing) {
            this.updateInspector();
        }
    }

    @Override
    protected void cssRevisionDidChange() {
        Platform.runLater(() -> {
            if (!this.dragOnGoing) {
                this.updateInspector();
            }
        });
    }

    @Override
    protected void jobManagerRevisionDidChange() {
    }

    @Override
    protected void editorSelectionDidChange() {
        if (!this.dragOnGoing) {
            this.updateInspector();
        }
    }

    @Override
    protected void controllerDidLoadFxml() {
        assert (this.propertiesTitledPane != null);
        assert (this.propertiesScroll != null);
        assert (this.propertiesSection != null);
        assert (this.layoutTitledPane != null);
        assert (this.layoutScroll != null);
        assert (this.layoutSection != null);
        assert (this.codeTitledPane != null);
        assert (this.codeScroll != null);
        assert (this.codeSection != null);
        assert (this.allTitledPane != null);
        assert (this.allScroll != null);
        assert (this.allContent != null);
        assert (this.searchStackPane != null);
        assert (this.searchContent != null);
        assert (this.accordion != null);
        assert (this.inspectorRoot != null);
        this.propertiesTitledPane.expandedProperty().addListener((ov, wasExpanded, expanded) -> this.handleTitledPane((boolean)wasExpanded, (boolean)expanded, SectionId.PROPERTIES));
        this.layoutTitledPane.expandedProperty().addListener((ov, wasExpanded, expanded) -> this.handleTitledPane((boolean)wasExpanded, (boolean)expanded, SectionId.LAYOUT));
        this.codeTitledPane.expandedProperty().addListener((ov, wasExpanded, expanded) -> this.handleTitledPane((boolean)wasExpanded, (boolean)expanded, SectionId.CODE));
        this.clearSections();
        this.getEditorController().getDragController().dragSourceProperty().addListener((ov, oldVal, newVal) -> {
            if (newVal != null) {
                this.dragOnGoing = true;
            } else {
                this.dragOnGoing = false;
                this.updateInspector();
            }
        });
        this.getEditorController().sceneStyleSheetProperty().addListener((ov, t, t1) -> this.updateInspector());
        this.selectionState = new SelectionState(this.editorController);
        this.viewModeChanged(null, this.getViewMode());
        this.expandedSectionChanged();
        this.accordion.expandedPaneProperty().addListener((ov, t, t1) -> this.expandedSectionProperty.setValue((Object)this.getExpandedSectionId()));
        this.accordion.setPrefSize(300.0, 700.0);
        this.buildExpandedSection();
        this.updateClassNameInSectionTitles();
        this.searchResultDividerPosition = this.inspectorRoot.getDividerPositions()[0];
        this.searchPatternDidChange();
    }

    private void updateInspector() {
        if (this.isInspectorLoaded() && this.hasFxomDocument()) {
            SelectionState newSelectionState = new SelectionState(this.editorController);
            if (this.isInspectorStateChanged(newSelectionState) || this.isEditedMode()) {
                this.selectionState = newSelectionState;
                this.rebuild();
            } else {
                this.selectionState = newSelectionState;
                this.reset();
            }
        }
    }

    private boolean isInspectorStateChanged(SelectionState newSelectionState) {
        return !newSelectionState.getSelectedClasses().equals(this.selectionState.getSelectedClasses()) || newSelectionState.getCommonParentClass() != this.selectionState.getCommonParentClass() || !newSelectionState.getUnresolvedInstances().equals(this.selectionState.getUnresolvedInstances());
    }

    private void searchPatternDidChange() {
        if (this.isInspectorLoaded()) {
            if (this.hasSearchPattern()) {
                if (!this.inspectorRoot.getItems().contains((Object)this.searchStackPane)) {
                    this.inspectorRoot.getItems().add(0, (Object)this.searchStackPane);
                    this.inspectorRoot.setDividerPositions(new double[]{this.searchResultDividerPosition});
                }
            } else {
                this.searchResultDividerPosition = this.inspectorRoot.getDividerPositions()[0];
                if (this.inspectorRoot.getItems().contains((Object)this.searchStackPane)) {
                    this.inspectorRoot.getItems().remove((Object)this.searchStackPane);
                }
            }
            this.buildFlatContent(this.searchContent);
        }
    }

    private void rebuild() {
        this.clearSections();
        if (this.getViewMode() == ViewMode.SECTION) {
            this.buildExpandedSection();
        } else {
            this.buildFlatContent(this.allContent);
        }
        this.updateClassNameInSectionTitles();
        if (this.hasSearchPattern()) {
            this.buildFlatContent(this.searchContent);
        }
    }

    private void reset() {
        for (Editor editor : this.editorsInUse) {
            if (editor instanceof PropertyEditor) {
                if (editor == this.lastPropertyEditorValueChanged) {
                    this.lastPropertyEditorValueChanged = null;
                    continue;
                }
                this.resetPropertyEditor((PropertyEditor)editor);
            }
            this.setEditorValueFromSelection(editor);
        }
    }

    private void buildExpandedSection() {
        this.buildSection(this.getExpandedSectionId());
    }

    private void buildSection(SectionId sectionId) {
        if (sectionId == SectionId.NONE) {
            return;
        }
        GridPane gridPane = this.getSectionContent(sectionId);
        gridPane.getChildren().clear();
        if (this.handleSelectionMessage(gridPane)) {
            return;
        }
        Set<ValuePropertyMetadata> propMetaAll = this.getValuePropertyMetadata();
        TreeMap<InspectorPath, ValuePropertyMetadata> propMetaSection = new TreeMap<InspectorPath, ValuePropertyMetadata>(Metadata.getMetadata().INSPECTOR_PATH_COMPARATOR);
        assert (propMetaAll != null);
        for (ValuePropertyMetadata valuePropMeta : propMetaAll) {
            InspectorPath inspectorPath = valuePropMeta.getInspectorPath();
            if (!this.isSameSection(inspectorPath.getSectionTag(), sectionId) || valuePropMeta.isStaticProperty() && !this.isStaticPropertyRelevant(valuePropMeta.getName()) || this.isEditedMode() && !this.isPropertyEdited(valuePropMeta, propMetaAll)) continue;
            propMetaSection.put(valuePropMeta.getInspectorPath(), valuePropMeta);
        }
        if (propMetaSection.isEmpty()) {
            this.displayEmptyMessage(gridPane);
            return;
        }
        Iterator iter = propMetaSection.entrySet().iterator();
        String currentSubSection = "";
        int lineIndex = 0;
        if (sectionId == SectionId.CODE) {
            this.addSubSectionSeparator(gridPane, lineIndex, FXID_SUBSECTION_NAME);
            ++lineIndex;
            currentSubSection = FXID_SUBSECTION_NAME;
            lineIndex = this.addFxIdEditor(gridPane, lineIndex);
        }
        HashSet<PropertyName> groupProperties = new HashSet<PropertyName>();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            InspectorPath inspectorPath = (InspectorPath)entry.getKey();
            ValuePropertyMetadata propMeta = (ValuePropertyMetadata)entry.getValue();
            String newSubSection = inspectorPath.getSubSectionTag();
            if (!currentSubSection.equalsIgnoreCase(newSubSection)) {
                this.addSubSectionSeparator(gridPane, lineIndex, newSubSection);
                ++lineIndex;
                currentSubSection = newSubSection;
            }
            if (this.isGroupedProperty(propMeta.getName())) {
                PropertiesEditor propertiesEditor;
                if (groupProperties.contains(propMeta.getName()) || (propertiesEditor = this.getInitializedPropertiesEditor(propMeta.getName(), propMetaSection.values(), groupProperties)) == null) continue;
                lineIndex = this.addInGridPane(gridPane, propertiesEditor, lineIndex);
                continue;
            }
            lineIndex = this.addInGridPane(gridPane, this.getInitializedPropertyEditor(propMeta), lineIndex);
        }
    }

    private void addSubSectionSeparator(GridPane gridPane, int lineIndex, String titleStr) {
        Node title = this.getSubSectionTitle(titleStr);
        gridPane.add(title, 0, lineIndex);
        GridPane.setColumnSpan((Node)title, (Integer)Integer.MAX_VALUE);
        RowConstraints rowConstraint = new RowConstraints();
        rowConstraint.setValignment(VPos.CENTER);
        gridPane.getRowConstraints().add((Object)rowConstraint);
    }

    private PropertiesEditor getInitializedPropertiesEditor(PropertyName groupedPropName, Collection<ValuePropertyMetadata> propMetas, Set<PropertyName> groupProperties) {
        ValuePropertyMetadata[] propMetaGroup = this.getGroupedPropertiesMetadata(groupedPropName, propMetas, groupProperties);
        PropertiesEditor propertiesEditor = this.getPropertiesEditor(propMetaGroup);
        if (propertiesEditor == null) {
            return null;
        }
        for (PropertyEditor propertyEditor : propertiesEditor.getPropertyEditors()) {
            this.setEditorValueFromSelection(propertyEditor);
            this.handlePropertyEditorChanges(propertyEditor);
        }
        return propertiesEditor;
    }

    private PropertyEditor getInitializedPropertyEditor(ValuePropertyMetadata propMeta) {
        PropertyEditor propertyEditor = this.getPropertyEditor(propMeta);
        this.setEditorValueFromSelection(propertyEditor);
        this.handlePropertyEditorChanges(propertyEditor);
        return propertyEditor;
    }

    private int addFxIdEditor(GridPane gridPane, int lineIndex) {
        PropertyEditor propertyEditor = this.makePropertyEditor(FxIdEditor.class, null);
        this.setFxIdFromSelection(propertyEditor);
        this.handlePropertyEditorChanges(propertyEditor);
        return this.addInGridPane(gridPane, propertyEditor, lineIndex);
    }

    private void handlePropertyEditorChanges(PropertyEditor propertyEditor) {
        this.handleValueChange(propertyEditor);
        this.handleTransientValueChange(propertyEditor);
        this.handleEditingChange(propertyEditor);
        this.handleNavigateRequest(propertyEditor);
    }

    private boolean isGroupedProperty(PropertyName propName) {
        return this.isAnchorConstraintsProp(propName);
    }

    private boolean isGroupEdited(Collection<ValuePropertyMetadata> propMetaAll) {
        return this.isAnchorConstraintsEdited(propMetaAll);
    }

    private boolean isPropertyEdited(ValuePropertyMetadata valuePropMeta, Collection<ValuePropertyMetadata> propMetadatas) {
        PropertyName propName = valuePropMeta.getName();
        boolean groupedProperty = this.isGroupedProperty(propName);
        if (!groupedProperty && !this.isPropertyEdited(valuePropMeta)) {
            return false;
        }
        return !groupedProperty || this.isGroupEdited(new HashSet<ValuePropertyMetadata>(propMetadatas));
    }

    private boolean isAnchorConstraintsProp(PropertyName propName) {
        String[] anchorPropNames = new String[]{"AnchorPane.topAnchor", "AnchorPane.rightAnchor", "AnchorPane.bottomAnchor", "AnchorPane.leftAnchor"};
        return Arrays.asList(anchorPropNames).contains(propName.toString());
    }

    private boolean isAnchorConstraintsEdited(Collection<ValuePropertyMetadata> propMetaAll) {
        for (ValuePropertyMetadata valuePropMeta : propMetaAll) {
            if (!this.isAnchorConstraintsProp(valuePropMeta.getName()) || !this.isPropertyEdited(valuePropMeta)) continue;
            return true;
        }
        return false;
    }

    private ValuePropertyMetadata[] getGroupedPropertiesMetadata(PropertyName groupedPropName, Collection<ValuePropertyMetadata> propMetas, Set<PropertyName> groupProperties) {
        assert (this.isAnchorConstraintsProp(groupedPropName));
        int anchorsNb = 4;
        ArrayList<ValuePropertyMetadata> propMetaGroup = new ArrayList<ValuePropertyMetadata>();
        for (int ii = 0; ii < anchorsNb; ++ii) {
            propMetaGroup.add(null);
        }
        block13: for (ValuePropertyMetadata propMeta : propMetas) {
            PropertyName propName = propMeta.getName();
            if (!this.isAnchorConstraintsProp(propName)) continue;
            groupProperties.add(propName);
            switch (propName.toString()) {
                case "AnchorPane.topAnchor": {
                    propMetaGroup.set(0, propMeta);
                    continue block13;
                }
                case "AnchorPane.rightAnchor": {
                    propMetaGroup.set(1, propMeta);
                    continue block13;
                }
                case "AnchorPane.bottomAnchor": {
                    propMetaGroup.set(2, propMeta);
                    continue block13;
                }
                case "AnchorPane.leftAnchor": {
                    propMetaGroup.set(3, propMeta);
                    continue block13;
                }
            }
            assert (false);
        }
        return propMetaGroup.toArray(new ValuePropertyMetadata[propMetaGroup.size()]);
    }

    private boolean isSameSection(String sectionStr, SectionId sectionId) {
        return sectionStr.equalsIgnoreCase(sectionId.toString());
    }

    private boolean isStaticPropertyRelevant(PropertyName propName) {
        if (this.getCommonParent() == null) {
            return false;
        }
        return this.getCommonParent() == propName.getResidenceClass();
    }

    private boolean hasSelectedElement() {
        return this.hasFxomDocument() && !this.selectionState.isSelectionEmpty();
    }

    private boolean hasSelectedElementNothingForInspector() {
        return this.hasFxomDocument() && this.getSelectedInstances().isEmpty();
    }

    private boolean hasMultipleSelection() {
        return this.getSelectedInstances().size() > 1;
    }

    private boolean hasUnresolvedInstance() {
        return this.getUnresolvedInstances().size() > 0;
    }

    private void buildFlatContent(GridPane gridPane) {
        gridPane.getChildren().clear();
        gridPane.getRowConstraints().clear();
        if (this.handleSelectionMessage(gridPane)) {
            return;
        }
        if (this.isSearch(gridPane) && !this.hasSearchPattern()) {
            this.addMessage(gridPane, I18N.getString("inspector.message.searchpattern.empty"));
            return;
        }
        boolean isOrderdByType = this.getViewMode() == ViewMode.PROPERTY_TYPE;
        Set<ValuePropertyMetadata> propMetadatas = this.getValuePropertyMetadata();
        if (propMetadatas.isEmpty()) {
            this.addMessage(gridPane, I18N.getString("inspector.message.no.properties"));
            return;
        }
        List<ValuePropertyMetadata> propMetadataList = Arrays.asList(propMetadatas.toArray(new ValuePropertyMetadata[propMetadatas.size()]));
        if (isOrderdByType) {
            Collections.sort(propMetadataList, new ValuePropertyMetadataClassComparator());
        } else {
            Collections.sort(propMetadataList, new ValuePropertyMetadataNameComparator());
        }
        ArrayList<ValuePropertyMetadata> orderedPropMetadatas = new ArrayList<ValuePropertyMetadata>();
        for (ValuePropertyMetadata valuePropMeta : propMetadataList) {
            if (this.isSearch(gridPane) && !this.isSearchPatternMatch(valuePropMeta) || valuePropMeta.isStaticProperty() && !this.isStaticPropertyRelevant(valuePropMeta.getName()) || this.isEditedMode() && !this.isPropertyEdited(valuePropMeta, propMetadataList)) continue;
            orderedPropMetadatas.add(valuePropMeta);
        }
        if (orderedPropMetadatas.isEmpty()) {
            this.displayEmptyMessage(gridPane);
            return;
        }
        int lineIndex = 0;
        HashSet<PropertyName> groupProperties = new HashSet<PropertyName>();
        for (ValuePropertyMetadata propMeta : orderedPropMetadatas) {
            if (this.isGroupedProperty(propMeta.getName())) {
                PropertiesEditor propertiesEditor;
                if (groupProperties.contains(propMeta.getName()) || (propertiesEditor = this.getInitializedPropertiesEditor(propMeta.getName(), new HashSet<ValuePropertyMetadata>(orderedPropMetadatas), groupProperties)) == null) continue;
                lineIndex = this.addInGridPane(gridPane, propertiesEditor, lineIndex);
                continue;
            }
            lineIndex = this.addInGridPane(gridPane, this.getInitializedPropertyEditor(propMeta), lineIndex);
        }
    }

    private boolean handleSelectionMessage(GridPane gridPane) {
        if (!this.hasSelectedElement()) {
            this.addMessage(gridPane, I18N.getString("inspector.message.no.selected"));
            return true;
        }
        if (this.hasSelectedElementNothingForInspector()) {
            this.addMessage(gridPane, I18N.getString("inspector.message.no.thingforinspector"));
            return true;
        }
        if (this.hasUnresolvedInstance()) {
            this.addMessage(gridPane, I18N.getString("inspector.message.no.resolved"));
            return true;
        }
        return false;
    }

    private void displayEmptyMessage(GridPane gridPane) {
        String messKey = this.isSearch(gridPane) ? "label.search.noresults" : (this.isEditedMode() ? "inspector.message.no.propertiesedited" : "inspector.message.no.properties");
        this.addMessage(gridPane, I18N.getString(messKey));
    }

    private boolean isSearchPatternMatch(ValuePropertyMetadata propMeta) {
        String propSimpleName = propMeta.getName().getName();
        if (propSimpleName.toLowerCase(Locale.ENGLISH).contains(this.searchPattern.toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        return EditorUtils.toDisplayName(propSimpleName).toLowerCase(Locale.ENGLISH).contains(this.searchPattern.toLowerCase(Locale.ENGLISH));
    }

    private boolean hasSearchPattern() {
        return this.searchPattern != null && !this.searchPattern.isEmpty();
    }

    private boolean isSearch(GridPane gridPane) {
        return gridPane == this.searchContent;
    }

    private int addInGridPane(GridPane gridPane, Editor editor, int lineIndex) {
        PropertyEditor.LayoutFormat editorLayout;
        String propNameText;
        HBox propNameNode;
        RowConstraints row1Constraints = new RowConstraints();
        if (editor instanceof PropertyEditor) {
            propNameNode = ((PropertyEditor)editor).getPropNameNode();
            propNameText = ((PropertyEditor)editor).getPropertyNameText();
            editorLayout = ((PropertyEditor)editor).getLayoutFormat();
        } else {
            propNameNode = ((PropertiesEditor)editor).getNameNode();
            propNameText = ((PropertiesEditor)editor).getPropertyNameText();
            editorLayout = this.getViewMode() == ViewMode.SECTION ? PropertyEditor.LayoutFormat.SIMPLE_LINE_NO_NAME : PropertyEditor.LayoutFormat.DOUBLE_LINE;
        }
        propNameNode.setFocusTraversable(false);
        MenuButton menu = editor.getMenu();
        menu.setId(propNameText + " Menu");
        Node valueEditor = editor.getValueEditor();
        valueEditor.setId(propNameText + " Value");
        if (editorLayout == PropertyEditor.LayoutFormat.DOUBLE_LINE) {
            row1Constraints.setValignment(VPos.TOP);
            gridPane.getRowConstraints().add((Object)row1Constraints);
            VBox editorBox = new VBox();
            editorBox.getChildren().addAll((Object[])new Node[]{propNameNode, valueEditor});
            propNameNode.setAlignment(Pos.CENTER_LEFT);
            GridPane.setColumnSpan((Node)editorBox, (Integer)2);
            gridPane.add((Node)editorBox, 0, lineIndex);
        } else {
            gridPane.getRowConstraints().add(lineIndex, (Object)row1Constraints);
            if (editorLayout != PropertyEditor.LayoutFormat.SIMPLE_LINE_NO_NAME) {
                gridPane.add((Node)propNameNode, 0, lineIndex);
                if (editorLayout == PropertyEditor.LayoutFormat.SIMPLE_LINE_CENTERED) {
                    propNameNode.setAlignment(Pos.CENTER_LEFT);
                } else if (editorLayout == PropertyEditor.LayoutFormat.SIMPLE_LINE_TOP) {
                    propNameNode.setAlignment(Pos.TOP_LEFT);
                    row1Constraints.setValignment(VPos.TOP);
                } else if (editorLayout == PropertyEditor.LayoutFormat.SIMPLE_LINE_BOTTOM) {
                    propNameNode.setAlignment(Pos.BOTTOM_LEFT);
                    row1Constraints.setValignment(VPos.BOTTOM);
                }
                GridPane.setColumnSpan((Node)propNameNode, (Integer)1);
                GridPane.setColumnSpan((Node)valueEditor, (Integer)1);
                gridPane.add(valueEditor, 1, lineIndex);
            } else {
                row1Constraints.setValignment(VPos.CENTER);
                GridPane.setColumnSpan((Node)valueEditor, (Integer)2);
                gridPane.add(valueEditor, 0, lineIndex);
            }
        }
        gridPane.add((Node)menu, 2, lineIndex);
        return ++lineIndex;
    }

    private void handleValueChange(PropertyEditor propertyEditor) {
        propertyEditor.addValueListener((ChangeListener<Object>)((ChangeListener)(ov, oldValue, newValue) -> {
            if (!propertyEditor.isUpdateFromModel()) {
                this.lastPropertyEditorValueChanged = propertyEditor;
                this.updateValueInModel(propertyEditor, oldValue, newValue);
            }
            if (propertyEditor.isRuledByCss()) {
                this.editorController.getMessageLog().logWarningMessage("inspector.css.overridden", propertyEditor.getPropertyNameText());
            }
        }));
    }

    private void handleTransientValueChange(PropertyEditor propertyEditor) {
        propertyEditor.addTransientValueListener((ChangeListener<Object>)((ChangeListener)(ov, oldValue, newValue) -> {
            this.lastPropertyEditorValueChanged = propertyEditor;
            for (FXOMInstance fxomInstance : this.getSelectedInstances()) {
                propertyEditor.getPropertyMeta().setValueInSceneGraphObject(fxomInstance, newValue);
            }
        }));
    }

    private void updateValueInModel(PropertyEditor propertyEditor, Object oldValue, Object newValue) {
        if (propertyEditor.isUpdateFromModel()) {
            return;
        }
        if (propertyEditor instanceof FxIdEditor) {
            assert (newValue instanceof String || newValue == null);
            this.setSelectedFXOMInstanceFxId(this.getSelectedInstance(), (String)newValue);
        } else if (propertyEditor instanceof ToggleGroupEditor) {
            assert (newValue instanceof String || newValue == null);
            this.setSelectionToggleGroup((String)newValue);
        } else {
            this.setSelectedFXOMInstances(propertyEditor.getPropertyMeta(), newValue);
        }
    }

    private void handleEditingChange(PropertyEditor propertyEditor) {
        propertyEditor.addEditingListener((ChangeListener<Boolean>)((ChangeListener)(ov, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.editorController.textEditingSessionDidBegin((Callback<Void, Boolean>)((Callback)p -> {
                    boolean hasError;
                    if (propertyEditor.getCommitListener() != null) {
                        propertyEditor.getCommitListener().handle(null);
                    }
                    if (!(hasError = propertyEditor.isInvalidValue()) && this.editorController.isTextEditingSessionOnGoing()) {
                        this.editorController.textEditingSessionDidEnd();
                    }
                    return !hasError;
                }));
            } else if (this.editorController.isTextEditingSessionOnGoing()) {
                this.editorController.textEditingSessionDidEnd();
                if (propertyEditor.getCommitListener() != null) {
                    propertyEditor.getCommitListener().handle(null);
                }
            }
        }));
    }

    private void handleNavigateRequest(PropertyEditor propertyEditor) {
        propertyEditor.addNavigateListener((ChangeListener<String>)((ChangeListener)(ov, oldStr, newStr) -> {
            if (newStr != null) {
                this.setFocusToEditor(new PropertyName((String)newStr));
            }
        }));
    }

    private void setSelectedFXOMInstances(ValuePropertyMetadata propMeta, Object value) {
        PropertyName cacheHintPN = new PropertyName("cacheHint");
        ModifySelectionJob job = cacheHintPN.equals(propMeta.getName()) ? new ModifyCacheHintJob(propMeta, value, this.getEditorController()) : new ModifySelectionJob(propMeta, value, this.getEditorController());
        this.pushJob(job);
    }

    private void setSelectedFXOMInstanceFxId(FXOMObject fxomObject, String fxId) {
        ModifyFxIdJob job = new ModifyFxIdJob(fxomObject, fxId, this.getEditorController());
        this.pushJob(job);
    }

    private void setSelectionToggleGroup(String tgId) {
        ModifySelectionToggleGroupJob job = new ModifySelectionToggleGroupJob(tgId, this.getEditorController());
        this.pushJob(job);
    }

    private void pushJob(Job job) {
        if (job.isExecutable()) {
            this.getEditorController().getJobManager().push(job);
        } else {
            System.out.println("Modify job not executable (because no value change?)");
        }
    }

    private boolean isPropertyEdited(ValuePropertyMetadata propMeta) {
        for (FXOMInstance instance : this.getSelectedInstances()) {
            Object defaultValue;
            Object value;
            if (!propMeta.isReadWrite() || EditorUtils.areEqual(value = propMeta.getValueObject(instance), defaultValue = propMeta.getDefaultValueObject())) continue;
            return true;
        }
        return false;
    }

    private void setEditorValueFromSelection(Editor editor) {
        if (editor instanceof FxIdEditor) {
            this.setFxIdFromSelection(editor);
        } else if (this.isPropertyEditor(editor)) {
            this.setEditorValueFromSelection((PropertyEditor)editor);
        } else if (this.isPropertiesEditor(editor)) {
            for (PropertyEditor propertyEditor : ((PropertiesEditor)editor).getPropertyEditors()) {
                this.setEditorValueFromSelection(propertyEditor);
            }
        }
    }

    private void setFxIdFromSelection(Editor editor) {
        assert (editor instanceof FxIdEditor);
        FxIdEditor fxIdEditor = (FxIdEditor)editor;
        if (this.hasMultipleSelection()) {
            fxIdEditor.setIndeterminate(true);
            fxIdEditor.setDisable(true);
        } else {
            String instanceFxId = this.getSelectedInstance().getFxId();
            fxIdEditor.setDisable(false);
            fxIdEditor.setUpdateFromModel(true);
            fxIdEditor.reset(this.getSuggestedFxIds(this.getControllerClass()), this.getEditorController());
            fxIdEditor.setValue(instanceFxId);
            fxIdEditor.setUpdateFromModel(false);
        }
    }

    private void setEditorValueFromSelection(PropertyEditor propertyEditor) {
        Object val = null;
        boolean isIndeterminate = false;
        boolean isReadWrite = true;
        boolean isRuledByCss = false;
        CssInternal.CssPropAuthorInfo cssInfo = null;
        PropertyName propName = propertyEditor.getPropertyName();
        boolean first = true;
        for (FXOMInstance instance : this.getSelectedInstances()) {
            ValuePropertyMetadata propMeta = Metadata.getMetadata().queryValueProperty(instance, propName);
            assert (propMeta != null);
            Object newVal = propMeta.getValueObject(instance);
            if (!propMeta.isReadWrite()) {
                isReadWrite = false;
            }
            if (first) {
                val = newVal;
                first = false;
            } else if (!EditorUtils.areEqual(newVal, val)) {
                isIndeterminate = true;
            }
            if ((cssInfo = CssInternal.getCssInfo(instance.getSceneGraphObject(), propMeta)) == null) continue;
            isRuledByCss = true;
        }
        propertyEditor.setUpdateFromModel(true);
        if (isRuledByCss) {
            propertyEditor.setRuledByCss(true);
            propertyEditor.setCssInfo(cssInfo);
            if (propertyEditor.isDisablePropertyBound()) {
                propertyEditor.unbindDisableProperty();
            }
            propertyEditor.setValue(cssInfo.getFxValue());
            propertyEditor.getValueEditor().setDisable(true);
        } else {
            propertyEditor.setRuledByCss(false);
            propertyEditor.setCssInfo(null);
            if (propertyEditor.getValueEditor() != null && propertyEditor.getValueEditor().isDisabled() && !propertyEditor.isDisablePropertyBound()) {
                propertyEditor.getValueEditor().setDisable(false);
            }
            if (isIndeterminate) {
                propertyEditor.setIndeterminate(true);
            } else {
                propertyEditor.setValue(val);
            }
        }
        propertyEditor.setUpdateFromModel(false);
        if (!(propertyEditor instanceof GenericEditor)) {
            if (!isReadWrite) {
                propertyEditor.setDisable(true);
            } else {
                propertyEditor.setDisable(false);
            }
        }
    }

    private PropertyEditor getPropertyEditor(ValuePropertyMetadata propMeta) {
        PropertyEditor propertyEditor;
        if (propMeta instanceof StringPropertyMetadata) {
            switch (propMeta.getName().getName()) {
                case "style": {
                    propertyEditor = this.makePropertyEditor(StyleEditor.class, propMeta);
                    break;
                }
                case "id": {
                    propertyEditor = this.makePropertyEditor(StringEditor.class, propMeta);
                    break;
                }
                default: {
                    propertyEditor = this.makePropertyEditor(I18nStringEditor.class, propMeta);
                    break;
                }
            }
        } else if (propMeta instanceof ListValuePropertyMetadata) {
            switch (propMeta.getName().getName()) {
                case "styleClass": {
                    propertyEditor = this.makePropertyEditor(StyleClassEditor.class, propMeta);
                    break;
                }
                case "stylesheets": {
                    propertyEditor = this.makePropertyEditor(StylesheetEditor.class, propMeta);
                    break;
                }
                case "buttonTypes": {
                    propertyEditor = this.makePropertyEditor(ButtonTypeEditor.class, propMeta);
                    break;
                }
                case "dividerPositions": {
                    propertyEditor = this.makePropertyEditor(DividerPositionsEditor.class, propMeta);
                    break;
                }
                default: {
                    propertyEditor = this.makePropertyEditor(GenericEditor.class, propMeta);
                    break;
                }
            }
        } else if (propMeta instanceof DoublePropertyMetadata) {
            DoublePropertyMetadata doublePropMeta = (DoublePropertyMetadata)propMeta;
            DoublePropertyMetadata.DoubleKind kind = doublePropMeta.getKind();
            propertyEditor = kind == DoublePropertyMetadata.DoubleKind.OPACITY || kind == DoublePropertyMetadata.DoubleKind.PROGRESS || this.isBoundedByProperties(propMeta) ? this.makePropertyEditor(BoundedDoubleEditor.class, propMeta) : (kind == DoublePropertyMetadata.DoubleKind.COORDINATE || kind == DoublePropertyMetadata.DoubleKind.USE_COMPUTED_SIZE || kind == DoublePropertyMetadata.DoubleKind.USE_PREF_SIZE || kind == DoublePropertyMetadata.DoubleKind.NULLABLE_COORDINATE ? this.makePropertyEditor(DoubleEditor.class, propMeta) : (kind == DoublePropertyMetadata.DoubleKind.ANGLE ? this.makePropertyEditor(RotateEditor.class, propMeta) : this.makePropertyEditor(DoubleEditor.class, propMeta)));
        } else if (propMeta instanceof IntegerPropertyMetadata) {
            propertyEditor = this.makePropertyEditor(IntegerEditor.class, propMeta);
        } else if (propMeta instanceof BooleanPropertyMetadata) {
            propertyEditor = this.makePropertyEditor(BooleanEditor.class, propMeta);
        } else if (propMeta instanceof EnumerationPropertyMetadata) {
            switch (propMeta.getName().getName()) {
                case "textAlignment": {
                    propertyEditor = this.makePropertyEditor(TextAlignmentEditor.class, propMeta);
                    break;
                }
                default: {
                    propertyEditor = this.makePropertyEditor(EnumEditor.class, propMeta);
                    break;
                }
            }
        } else {
            propertyEditor = propMeta instanceof InsetsPropertyMetadata ? this.makePropertyEditor(InsetsEditor.class, propMeta) : (propMeta instanceof CursorPropertyMetadata ? this.makePropertyEditor(CursorEditor.class, propMeta) : (propMeta instanceof EventHandlerPropertyMetadata ? this.makePropertyEditor(EventHandlerEditor.class, propMeta) : (propMeta instanceof EffectPropertyMetadata ? this.makePropertyEditor(EffectPopupEditor.class, propMeta) : (propMeta instanceof FontPropertyMetadata ? this.makePropertyEditor(FontPopupEditor.class, propMeta) : (propMeta instanceof PaintPropertyMetadata ? this.makePropertyEditor(PaintPopupEditor.class, propMeta) : (propMeta instanceof ImagePropertyMetadata ? this.makePropertyEditor(ImageEditor.class, propMeta) : (propMeta instanceof BoundsPropertyMetadata ? this.makePropertyEditor(BoundsPopupEditor.class, propMeta) : (propMeta instanceof Point3DPropertyMetadata ? this.makePropertyEditor(Point3DEditor.class, propMeta) : (propMeta instanceof KeyCombinationPropertyMetadata ? this.makePropertyEditor(KeyCombinationPopupEditor.class, propMeta) : (propMeta instanceof TableViewResizePolicyPropertyMetadata || propMeta instanceof TreeTableViewResizePolicyPropertyMetadata ? this.makePropertyEditor(ColumnResizePolicyEditor.class, propMeta) : (propMeta instanceof Rectangle2DPropertyMetadata ? this.makePropertyEditor(Rectangle2DPopupEditor.class, propMeta) : (propMeta instanceof ToggleGroupPropertyMetadata ? this.makePropertyEditor(ToggleGroupEditor.class, propMeta) : this.makePropertyEditor(GenericEditor.class, propMeta)))))))))))));
        }
        if (this.isSameSection(propMeta.getInspectorPath().getSectionTag(), SectionId.CODE)) {
            propertyEditor.setLayoutFormat(PropertyEditor.LayoutFormat.DOUBLE_LINE);
        }
        return propertyEditor;
    }

    private PropertiesEditor getPropertiesEditor(ValuePropertyMetadata[] propMetas) {
        for (ValuePropertyMetadata propMeta : propMetas) {
            if (propMeta == null) {
                return null;
            }
            assert (this.isAnchorConstraintsProp(propMeta.getName()));
        }
        return this.makePropertiesEditor(AnchorPaneConstraintsEditor.class, propMetas);
    }

    private Map<String, Object> getConstants(DoublePropertyMetadata doublePropMeta) {
        TreeMap<String, Object> constants = new TreeMap<String, Object>();
        String propNameStr = doublePropMeta.getName().getName();
        DoublePropertyMetadata.DoubleKind kind = doublePropMeta.getKind();
        if (propNameStr.contains("maxWidth") || propNameStr.contains("maxHeight")) {
            constants.put("MAX_VALUE", Double.MAX_VALUE);
        }
        if (kind == DoublePropertyMetadata.DoubleKind.USE_COMPUTED_SIZE) {
            constants.put(DoublePropertyMetadata.DoubleKind.USE_COMPUTED_SIZE.toString(), -1.0);
        } else if (kind == DoublePropertyMetadata.DoubleKind.USE_PREF_SIZE) {
            constants.put(DoublePropertyMetadata.DoubleKind.USE_COMPUTED_SIZE.toString(), -1.0);
            constants.put(DoublePropertyMetadata.DoubleKind.USE_PREF_SIZE.toString(), Double.NEGATIVE_INFINITY);
        } else if (kind == DoublePropertyMetadata.DoubleKind.NULLABLE_COORDINATE) {
            constants.put("NULL", null);
        } else if (kind == DoublePropertyMetadata.DoubleKind.PROGRESS) {
            constants.put("INDETERMINATE", -1.0);
        }
        return constants;
    }

    private Map<String, Object> getConstants(IntegerPropertyMetadata integerPropMeta) {
        TreeMap<String, Object> constants = new TreeMap<String, Object>();
        String propNameStr = integerPropMeta.getName().getName();
        if (propNameStr.contains("columnSpan") || propNameStr.contains("rowSpan")) {
            constants.put("REMAINING", Integer.MAX_VALUE);
        } else if (propNameStr.contains("prefColumnCount")) {
            if (this.getSelectedClasses().size() == 1) {
                if (this.getSelectedClass() == TextField.class || this.getSelectedClass() == PasswordField.class) {
                    constants.put("DEFAULT_PREF_COLUMN_COUNT", 12);
                } else if (this.getSelectedClass() == TextArea.class) {
                    constants.put("DEFAULT_PREF_COLUMN_COUNT", 40);
                }
            }
        } else if (propNameStr.contains("prefRowCount")) {
            assert (this.getSelectedClass() == TextArea.class);
            constants.put("DEFAULT_PREF_ROW_COUNT", 10);
        }
        return constants;
    }

    private int getMax(IntegerPropertyMetadata integerPropMeta) {
        GridPane gridPane;
        String propNameStr = integerPropMeta.getName().getName();
        if (propNameStr.contains("columnIndex") || propNameStr.contains("columnSpan")) {
            gridPane = this.getGridPane(propNameStr);
            if (gridPane == null) {
                return this.getMin(integerPropMeta);
            }
            int nbColumns = Deprecation.getGridPaneColumnCount(gridPane);
            if (propNameStr.contains("columnIndex")) {
                return nbColumns - 1;
            }
            if (propNameStr.contains("columnSpan")) {
                int maxIndex = this.getSpanPropertyMaxIndex(propNameStr);
                return nbColumns - maxIndex;
            }
        }
        if (propNameStr.contains("rowIndex") || propNameStr.contains("rowSpan")) {
            gridPane = this.getGridPane(propNameStr);
            if (gridPane == null) {
                return this.getMin(integerPropMeta);
            }
            int nbRow = Deprecation.getGridPaneRowCount(gridPane);
            if (propNameStr.contains("rowIndex")) {
                return nbRow - 1;
            }
            if (propNameStr.contains("rowSpan")) {
                int maxIndex = this.getSpanPropertyMaxIndex(propNameStr);
                return nbRow - maxIndex;
            }
        }
        return Integer.MAX_VALUE;
    }

    private int getMin(IntegerPropertyMetadata integerPropMeta) {
        String propNameStr = integerPropMeta.getName().getName();
        if (propNameStr.contains("columnSpan") || propNameStr.contains("rowSpan")) {
            return 1;
        }
        return 0;
    }

    private boolean isMultiLinesSupported(Set<Class<?>> selectedClasses, ValuePropertyMetadata propMeta) {
        String propertyNameStr = propMeta.getName().getName();
        if ((selectedClasses.contains(TextField.class) || selectedClasses.contains(PasswordField.class)) && propertyNameStr.equalsIgnoreCase("text")) {
            return false;
        }
        if (propertyNameStr.equalsIgnoreCase("promptText")) {
            return false;
        }
        return !propertyNameStr.equalsIgnoreCase("ellipsisString");
    }

    private int getSpanPropertyMaxIndex(String propNameStr) {
        assert (propNameStr.contains("columnSpan") || propNameStr.contains("rowSpan"));
        int maxIndex = 0;
        for (FXOMInstance instance : this.getSelectedInstances()) {
            assert (instance.getSceneGraphObject() instanceof Node);
            Node node = (Node)instance.getSceneGraphObject();
            Integer index = propNameStr.contains("columnSpan") ? GridPane.getColumnIndex((Node)node) : GridPane.getRowIndex((Node)node);
            if (index == null) {
                index = 0;
            }
            if (index <= maxIndex) continue;
            maxIndex = index;
        }
        return maxIndex;
    }

    private GridPane getGridPane(String propNameStr) {
        assert (propNameStr.contains("columnIndex") || propNameStr.contains("columnSpan") || propNameStr.contains("rowIndex") || propNameStr.contains("rowSpan"));
        FXOMObject commonParent = this.selectionState.getCommonParentObject();
        if (commonParent == null) {
            return null;
        }
        Object parentObj = commonParent.getSceneGraphObject();
        assert (parentObj instanceof GridPane);
        return (GridPane)parentObj;
    }

    private boolean isInspectorLoaded() {
        return this.accordion != null;
    }

    private boolean hasFxomDocument() {
        return this.getEditorController().getFxomDocument() != null;
    }

    private void addMessage(GridPane gridPane, String mess) {
        Label label = new Label(mess);
        label.getStyleClass().add((Object)"inspector-message");
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        gridPane.add((Node)label, 0, 0, 3, 1);
    }

    private Set<ValuePropertyMetadata> getValuePropertyMetadata() {
        return Metadata.getMetadata().queryValueProperties(this.getSelectedClasses());
    }

    private void clearSections() {
        for (Editor editor : this.editorsInUse) {
            Stack<Editor> editorPool = this.editorPools.get(editor.getClass());
            assert (editorPool != null);
            editorPool.push(editor);
            editor.removeAllListeners();
        }
        this.editorsInUse.clear();
        for (SubSectionTitle subSectionTitle : this.subSectionTitlesInUse) {
            this.subSectionTitlePool.push(subSectionTitle);
        }
        this.subSectionTitlesInUse.clear();
        for (Iterator<Object> iterator : this.sections) {
            GridPane content = this.getSectionContent((SectionId)((Object)iterator));
            if (content == null) continue;
            this.getSectionContent((SectionId)((Object)iterator)).getChildren().clear();
            this.getSectionContent((SectionId)((Object)iterator)).getRowConstraints().clear();
        }
        this.allContent.getChildren().clear();
        this.allContent.getRowConstraints().clear();
        this.searchContent.getChildren().clear();
        this.searchContent.getRowConstraints().clear();
    }

    private GridPane getSectionContent(SectionId sectionId) {
        GridPane gp;
        assert (sectionId != SectionId.NONE);
        switch (sectionId) {
            case PROPERTIES: {
                gp = this.propertiesSection;
                break;
            }
            case LAYOUT: {
                gp = this.layoutSection;
                break;
            }
            case CODE: {
                gp = this.codeSection;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected section id " + (Object)((Object)sectionId));
            }
        }
        return gp;
    }

    private void handleTitledPane(boolean wasExpanded, boolean expanded, SectionId sectionId) {
        if (!wasExpanded && expanded && this.getSectionContent(sectionId).getChildren().isEmpty()) {
            this.buildSection(sectionId);
        }
    }

    private Node getSubSectionTitle(String title) {
        SubSectionTitle subSectionTitle;
        if (this.subSectionTitlePool.isEmpty()) {
            subSectionTitle = new SubSectionTitle(title);
        } else {
            subSectionTitle = this.subSectionTitlePool.pop();
            subSectionTitle.setTitle(title);
        }
        this.subSectionTitlesInUse.add(subSectionTitle);
        return subSectionTitle.getNode();
    }

    private PropertyEditor makePropertyEditor(Class<? extends Editor> editorClass, ValuePropertyMetadata propMeta) {
        PropertyEditor propertyEditor = null;
        Stack<Editor> editorPool = this.editorPools.get(editorClass);
        if (editorPool != null && !editorPool.isEmpty()) {
            Editor editor = editorPool.pop();
            assert (this.isPropertyEditor(editor));
            propertyEditor = (PropertyEditor)editor;
        }
        propertyEditor = this.makeOrResetPropertyEditor(editorClass, propMeta, propertyEditor);
        this.editorsInUse.add(propertyEditor);
        return propertyEditor;
    }

    private void resetPropertyEditor(PropertyEditor propertyEditor) {
        assert (propertyEditor != null);
        this.makeOrResetPropertyEditor(propertyEditor.getClass(), propertyEditor.getPropertyMeta(), propertyEditor);
    }

    private PropertyEditor makeOrResetPropertyEditor(Class<? extends Editor> editorClass, ValuePropertyMetadata propMeta, PropertyEditor propertyEditor) {
        if (propertyEditor != null) {
            propertyEditor.setUpdateFromModel(true);
        }
        Set<Class<?>> selectedClasses = this.getSelectedClasses();
        if (editorClass == I18nStringEditor.class) {
            if (propertyEditor != null) {
                ((I18nStringEditor)propertyEditor).reset(propMeta, selectedClasses, this.isMultiLinesSupported(selectedClasses, propMeta));
            } else {
                propertyEditor = new I18nStringEditor(propMeta, selectedClasses, this.isMultiLinesSupported(selectedClasses, propMeta));
            }
        } else if (editorClass == StringEditor.class) {
            if (propertyEditor != null) {
                ((StringEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new StringEditor(propMeta, selectedClasses);
            }
        } else if (editorClass == DoubleEditor.class) {
            assert (propMeta instanceof DoublePropertyMetadata);
            DoublePropertyMetadata doublePropMeta = (DoublePropertyMetadata)propMeta;
            if (propertyEditor != null) {
                ((DoubleEditor)propertyEditor).reset(propMeta, selectedClasses, this.getConstants(doublePropMeta));
            } else {
                propertyEditor = new DoubleEditor(propMeta, selectedClasses, this.getConstants(doublePropMeta));
            }
        } else if (editorClass == IntegerEditor.class) {
            assert (propMeta instanceof IntegerPropertyMetadata);
            IntegerPropertyMetadata integerPropMeta = (IntegerPropertyMetadata)propMeta;
            if (propertyEditor != null) {
                ((IntegerEditor)propertyEditor).reset(propMeta, selectedClasses, this.getConstants(integerPropMeta), this.getMin(integerPropMeta), this.getMax(integerPropMeta));
            } else {
                propertyEditor = new IntegerEditor(propMeta, selectedClasses, this.getConstants(integerPropMeta), this.getMin(integerPropMeta), this.getMax(integerPropMeta));
            }
        } else if (editorClass == BooleanEditor.class) {
            if (propertyEditor != null) {
                ((BooleanEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new BooleanEditor(propMeta, selectedClasses);
            }
        } else if (editorClass == EnumEditor.class) {
            if (propertyEditor != null) {
                ((EnumEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new EnumEditor(propMeta, selectedClasses);
            }
        } else if (editorClass == InsetsEditor.class) {
            if (propertyEditor != null) {
                ((InsetsEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new InsetsEditor(propMeta, selectedClasses);
            }
        } else if (editorClass == BoundedDoubleEditor.class) {
            assert (propMeta instanceof DoublePropertyMetadata);
            DoublePropertyMetadata doublePropMeta = (DoublePropertyMetadata)propMeta;
            if (propertyEditor != null) {
                ((BoundedDoubleEditor)propertyEditor).reset(propMeta, selectedClasses, this.getSelectedInstances(), this.getConstants(doublePropMeta));
            } else {
                propertyEditor = new BoundedDoubleEditor(propMeta, selectedClasses, this.getSelectedInstances(), this.getConstants(doublePropMeta));
            }
        } else if (editorClass == RotateEditor.class) {
            if (propertyEditor != null) {
                ((RotateEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new RotateEditor(propMeta, selectedClasses);
            }
        } else if (editorClass == StyleEditor.class) {
            if (propertyEditor != null) {
                ((StyleEditor)propertyEditor).reset(propMeta, selectedClasses, this.getEditorController());
            } else {
                propertyEditor = new StyleEditor(propMeta, selectedClasses, this.getEditorController());
            }
        } else if (editorClass == StyleClassEditor.class) {
            if (propertyEditor != null) {
                ((StyleClassEditor)propertyEditor).reset(propMeta, selectedClasses, this.getSelectedInstances(), this.getEditorController());
            } else {
                propertyEditor = new StyleClassEditor(propMeta, selectedClasses, this.getSelectedInstances(), this.getEditorController());
            }
        } else if (editorClass == StylesheetEditor.class) {
            if (propertyEditor != null) {
                ((StylesheetEditor)propertyEditor).reset(propMeta, selectedClasses, this.getEditorController().getFxmlLocation());
            } else {
                propertyEditor = new StylesheetEditor(propMeta, selectedClasses, this.getEditorController().getFxmlLocation());
            }
        } else if (editorClass == FxIdEditor.class) {
            String controllerClass = this.getControllerClass();
            if (propertyEditor != null) {
                ((FxIdEditor)propertyEditor).reset(this.getSuggestedFxIds(controllerClass), this.getEditorController());
            } else {
                propertyEditor = new FxIdEditor(this.getSuggestedFxIds(controllerClass), this.getEditorController());
            }
        } else if (editorClass == CursorEditor.class) {
            if (propertyEditor != null) {
                ((CursorEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new CursorEditor(propMeta, selectedClasses);
            }
        } else if (editorClass == EventHandlerEditor.class) {
            if (propertyEditor != null) {
                ((EventHandlerEditor)propertyEditor).reset(propMeta, selectedClasses, this.getSuggestedEventHandlers(this.getControllerClass()));
            } else {
                propertyEditor = new EventHandlerEditor(propMeta, selectedClasses, this.getSuggestedEventHandlers(this.getControllerClass()));
            }
        } else if (editorClass == EffectPopupEditor.class) {
            if (propertyEditor != null) {
                ((EffectPopupEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new EffectPopupEditor(propMeta, selectedClasses, this.getEditorController());
            }
        } else if (editorClass == FontPopupEditor.class) {
            if (propertyEditor != null) {
                ((FontPopupEditor)propertyEditor).reset(propMeta, selectedClasses, this.getEditorController());
            } else {
                propertyEditor = new FontPopupEditor(propMeta, selectedClasses, this.getEditorController());
            }
        } else if (editorClass == PaintPopupEditor.class) {
            if (propertyEditor != null) {
                ((PaintPopupEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new PaintPopupEditor(propMeta, selectedClasses, this.getEditorController());
            }
        } else if (editorClass == ImageEditor.class) {
            if (propertyEditor != null) {
                ((ImageEditor)propertyEditor).reset(propMeta, selectedClasses, this.getEditorController().getFxmlLocation());
            } else {
                propertyEditor = new ImageEditor(propMeta, selectedClasses, this.getEditorController().getFxmlLocation());
            }
        } else if (editorClass == BoundsPopupEditor.class) {
            if (propertyEditor != null) {
                ((BoundsPopupEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new BoundsPopupEditor(propMeta, selectedClasses);
            }
        } else if (editorClass == Point3DEditor.class) {
            if (propertyEditor != null) {
                ((Point3DEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new Point3DEditor(propMeta, selectedClasses);
            }
        } else if (editorClass == DividerPositionsEditor.class) {
            if (propertyEditor != null) {
                ((DividerPositionsEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new DividerPositionsEditor(propMeta, selectedClasses);
            }
        } else if (editorClass == TextAlignmentEditor.class) {
            if (propertyEditor != null) {
                ((TextAlignmentEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new TextAlignmentEditor(propMeta, selectedClasses);
            }
        } else if (editorClass == KeyCombinationPopupEditor.class) {
            if (propertyEditor != null) {
                ((KeyCombinationPopupEditor)propertyEditor).reset(propMeta, selectedClasses, this.getEditorController());
            } else {
                propertyEditor = new KeyCombinationPopupEditor(propMeta, selectedClasses, this.getEditorController());
            }
        } else if (editorClass == ColumnResizePolicyEditor.class) {
            if (propertyEditor != null) {
                ((ColumnResizePolicyEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new ColumnResizePolicyEditor(propMeta, selectedClasses);
            }
        } else if (editorClass == Rectangle2DPopupEditor.class) {
            if (propertyEditor != null) {
                ((Rectangle2DPopupEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new Rectangle2DPopupEditor(propMeta, selectedClasses);
            }
        } else if (editorClass == ToggleGroupEditor.class) {
            if (propertyEditor != null) {
                ((ToggleGroupEditor)propertyEditor).reset(propMeta, selectedClasses, this.getSuggestedToggleGroups());
            } else {
                propertyEditor = new ToggleGroupEditor(propMeta, selectedClasses, this.getSuggestedToggleGroups());
            }
        } else if (editorClass == ButtonTypeEditor.class) {
            if (propertyEditor != null) {
                ((ButtonTypeEditor)propertyEditor).reset(propMeta, selectedClasses);
            } else {
                propertyEditor = new ButtonTypeEditor(propMeta, selectedClasses);
            }
        } else if (propertyEditor != null) {
            ((GenericEditor)propertyEditor).reset(propMeta, selectedClasses);
        } else {
            propertyEditor = new GenericEditor(propMeta, selectedClasses);
        }
        propertyEditor.setUpdateFromModel(false);
        return propertyEditor;
    }

    private PropertiesEditor makePropertiesEditor(Class<? extends Editor> editorClass, ValuePropertyMetadata[] propMetas) {
        Editor editor = null;
        Stack<Editor> editorPool = this.editorPools.get(editorClass);
        if (editorPool != null && !editorPool.isEmpty()) {
            editor = editorPool.pop();
            assert (this.isPropertiesEditor(editor));
        }
        assert (editorClass == AnchorPaneConstraintsEditor.class);
        if (editor != null) {
            assert (editor instanceof AnchorPaneConstraintsEditor);
            ((AnchorPaneConstraintsEditor)editor).reset(propMetas[0], propMetas[1], propMetas[2], propMetas[3], this.getSelectedInstances());
        } else {
            editor = new AnchorPaneConstraintsEditor("AnchorPane Constraints", propMetas[0], propMetas[1], propMetas[2], propMetas[3], this.getSelectedInstances());
        }
        AnchorPaneConstraintsEditor propertiesEditor = (AnchorPaneConstraintsEditor)editor;
        this.editorsInUse.add(editor);
        return propertiesEditor;
    }

    private void updateClassNameInSectionTitles() {
        String selClass = "";
        if (this.getSelectedClasses().size() > 1) {
            selClass = I18N.getString("inspector.sectiontitle.multiple");
        } else if (this.getSelectedClasses().size() == 1) {
            selClass = this.getSelectedClass().getSimpleName();
        }
        for (TitledPane titledPane : this.accordion.getPanes()) {
            Node graphic = titledPane.getGraphic();
            assert (graphic instanceof Label);
            if (titledPane == this.allTitledPane) {
                this.allTitledPane.setText(null);
            } else if (!selClass.isEmpty() && !selClass.startsWith(" :")) {
                selClass = " : " + selClass;
            }
            ((Label)graphic).setText(selClass);
        }
    }

    private boolean isPropertyEditor(Editor editor) {
        return editor instanceof PropertyEditor;
    }

    private boolean isPropertiesEditor(Editor editor) {
        return editor instanceof PropertiesEditor;
    }

    private List<String> getSuggestedFxIds(String controllerClass) {
        if (controllerClass == null || this.hasMultipleSelection()) {
            return Collections.emptyList();
        }
        Glossary glossary = this.getEditorController().getGlossary();
        URL location = null;
        if (this.getEditorController().getFxomDocument() != null) {
            location = this.getEditorController().getFxomDocument().getLocation();
        }
        List<String> fxIds = glossary.queryFxIds(location, controllerClass, this.getSelectedClass());
        fxIds.removeAll(this.getFxIdsInUse());
        return fxIds;
    }

    private List<String> getFxIdsInUse() {
        FXOMFxIdIndex fxomIndex = new FXOMFxIdIndex(this.getEditorController().getFxomDocument());
        return new ArrayList<String>(fxomIndex.getFxIds().keySet());
    }

    private List<String> getSuggestedEventHandlers(String controllerClass) {
        if (controllerClass == null) {
            return Collections.emptyList();
        }
        Glossary glossary = this.getEditorController().getGlossary();
        URL location = null;
        if (this.getEditorController().getFxomDocument() != null) {
            location = this.getEditorController().getFxomDocument().getLocation();
        }
        return glossary.queryEventHandlers(location, controllerClass);
    }

    private List<String> getSuggestedToggleGroups() {
        FXOMFxIdIndex fxomIndex = new FXOMFxIdIndex(this.getEditorController().getFxomDocument());
        List<FXOMInstance> tgs = fxomIndex.collectToggleGroups();
        ArrayList<String> tgNames = new ArrayList<String>();
        for (FXOMInstance tg : tgs) {
            tgNames.add(tg.getFxId());
        }
        return tgNames;
    }

    private String getControllerClass() {
        return this.getEditorController().getFxomDocument().getFxomRoot().getFxController();
    }

    private Set<FXOMInstance> getSelectedInstances() {
        return this.selectionState.getSelectedInstances();
    }

    private FXOMInstance getSelectedInstance() {
        assert (this.getSelectedInstances().size() == 1);
        return (FXOMInstance)this.getSelectedInstances().toArray()[0];
    }

    private Set<FXOMInstance> getUnresolvedInstances() {
        return this.selectionState.getUnresolvedInstances();
    }

    private Set<Class<?>> getSelectedClasses() {
        return this.selectionState.getSelectedClasses();
    }

    private Class<?> getSelectedClass() {
        assert (this.getSelectedClasses().size() == 1);
        return (Class)this.getSelectedClasses().toArray()[0];
    }

    private Class<?> getCommonParent() {
        return this.selectionState.getCommonParentClass();
    }

    private boolean isBoundedByProperties(ValuePropertyMetadata propMeta) {
        return propMeta.getName().toString().equals("hvalue") || propMeta.getName().toString().equals("vvalue");
    }

    public void setFocusToEditor(PropertyName propName) {
        double contentHeight;
        double contentMiddle;
        Editor editor = null;
        for (Editor ed : this.editorsInUse) {
            if (!(ed instanceof PropertyEditor) || !propName.equals(((PropertyEditor)ed).getPropertyName())) continue;
            editor = (PropertyEditor)ed;
        }
        if (editor == null) {
            return;
        }
        Editor editorToFocus = editor;
        Node valueEditorNode = editorToFocus.getValueEditor();
        ScrollPane sp = null;
        for (Parent node = valueEditorNode.getParent(); node != null; node = node.getParent()) {
            if (!(node instanceof ScrollPane)) continue;
            sp = (ScrollPane)node;
            break;
        }
        if (sp == null) {
            return;
        }
        ScrollPane scrollPane = sp;
        double editorHeight = valueEditorNode.getLayoutBounds().getHeight();
        Point2D pt = Deprecation.localToLocal(valueEditorNode, 0.0, 0.0, scrollPane.getContent());
        double vpHeight = scrollPane.getViewportBounds().getHeight();
        double selY = pt.getY();
        selY = selY > (contentMiddle = (contentHeight = scrollPane.getContent().getLayoutBounds().getHeight()) / 2.0) ? (selY += editorHeight) : (selY -= editorHeight);
        double moveContent = selY - contentMiddle;
        double vpRatio = contentHeight / vpHeight;
        double moveVp = moveContent / vpRatio;
        double selYVp = vpHeight / 2.0 + moveVp;
        double scrollPos = selYVp / vpHeight;
        scrollPane.setVvalue(scrollPos);
        ((PropertyEditor)editorToFocus).requestFocus();
    }

    private final class SelectionState {
        private final Selection selection;
        private final Set<FXOMInstance> selectedInstances = new HashSet<FXOMInstance>();
        private final Set<Class<?>> selectedClasses = new HashSet();
        private Class<?> commonParentClass;
        private FXOMObject commonParentObject;
        private final Set<FXOMInstance> unresolvedInstances = new HashSet<FXOMInstance>();

        public SelectionState(EditorController editorController) {
            this.selection = editorController.getSelection();
            this.initialize();
        }

        protected void initialize() {
            this.selectedInstances.clear();
            if (this.selection.getGroup() instanceof ObjectSelectionGroup) {
                ObjectSelectionGroup osg = (ObjectSelectionGroup)this.selection.getGroup();
                for (FXOMObject obj : osg.getItems()) {
                    if (!(obj instanceof FXOMInstance)) continue;
                    this.selectedInstances.add((FXOMInstance)obj);
                }
            } else if (this.selection.getGroup() instanceof GridSelectionGroup) {
                GridSelectionGroup gsg = (GridSelectionGroup)this.selection.getGroup();
                for (FXOMInstance inst : gsg.collectConstraintInstances()) {
                    this.selectedInstances.add(inst);
                    if (InspectorPanelController.this.getExpandedSectionId() == SectionId.LAYOUT) continue;
                    InspectorPanelController.this.setExpandedSection(SectionId.LAYOUT);
                }
            }
            this.selectedClasses.clear();
            for (FXOMInstance instance : this.selectedInstances) {
                if (instance.getDeclaredClass() == null) continue;
                this.selectedClasses.add(instance.getDeclaredClass());
            }
            this.commonParentClass = null;
            for (FXOMInstance instance : this.selectedInstances) {
                if (this.commonParentClass == null) {
                    this.commonParentClass = this.getParentClass(instance);
                    continue;
                }
                if (this.getParentClass(instance) == this.commonParentClass) continue;
                this.commonParentClass = null;
                break;
            }
            this.commonParentObject = null;
            for (FXOMInstance instance : this.selectedInstances) {
                if (this.commonParentObject == null) {
                    this.commonParentObject = instance.getParentObject();
                    continue;
                }
                if (instance.getParentObject() == this.commonParentObject) continue;
                this.commonParentObject = null;
                break;
            }
            this.unresolvedInstances.clear();
            for (FXOMInstance instance : this.selectedInstances) {
                if (instance.getSceneGraphObject() != null) continue;
                this.unresolvedInstances.add(instance);
            }
        }

        private boolean isSelectionEmpty() {
            return this.selection.isEmpty();
        }

        private Set<Class<?>> getSelectedClasses() {
            return this.selectedClasses;
        }

        private Class<?> getCommonParentClass() {
            return this.commonParentClass;
        }

        private FXOMObject getCommonParentObject() {
            return this.commonParentObject;
        }

        private Set<FXOMInstance> getSelectedInstances() {
            return this.selectedInstances;
        }

        private Set<FXOMInstance> getUnresolvedInstances() {
            return this.unresolvedInstances;
        }

        private Class<?> getParentClass(FXOMInstance instance) {
            FXOMObject parent = instance.getParentObject();
            if (parent == null) {
                return null;
            }
            assert (parent instanceof FXOMInstance);
            return ((FXOMInstance)parent).getDeclaredClass();
        }
    }

    private static class SubSectionTitle {
        @FXML
        private Label titleLb;
        private Parent root;

        public SubSectionTitle(String title) {
            this.initialize(title);
        }

        private void initialize(String title) {
            URL fxmlURL = SubSectionTitle.class.getResource("SubSection.fxml");
            this.root = EditorUtils.loadFxml(fxmlURL, (Object)this);
            this.titleLb.setText(title);
        }

        public void setTitle(String title) {
            this.titleLb.setText(title);
        }

        public Node getNode() {
            return this.root;
        }
    }

    public static enum ShowMode {
        ALL,
        EDITED;

    }

    public static enum ViewMode {
        SECTION,
        PROPERTY_NAME,
        PROPERTY_TYPE;

    }

    public static enum SectionId {
        PROPERTIES,
        LAYOUT,
        CODE,
        NONE;

    }
}

