/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentUtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.CompilerRunnerUtil;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerServicesFacadeImpl;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinLogger;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.CompilerSettingsKt;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 92\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00019B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0012\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002JJ\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0(2\u0006\u0010)\u001a\u00020&J.\u0010*\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010-\u001a\u00020&J\u001b\u0010.\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010/J4\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020&2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\r0(2\u0006\u00103\u001a\u00020#H\u0002J\u0018\u00104\u001a\u00020 2\u0006\u0010-\u001a\u00020&2\u0006\u00103\u001a\u00020,H\u0002J\u0010\u00105\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001f\u00106\u001a\u00020 2\u0006\u00103\u001a\u00020\u00052\f\u00107\u001a\b\u0012\u0004\u0012\u00020 08H\u0082\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/JpsKotlinCompilerRunner;", "Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner;", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "()V", "compilerSettings", "Lorg/jetbrains/kotlin/config/CompilerSettings;", "log", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "getLog", "()Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "compileWithDaemon", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "compilerClassName", "", "compilerArgs", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "compileWithDaemonOrFallback", "fallbackCompileStrategy", "getDaemonConnection", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "getReturnCodeFromObject", "rc", "", "reportCategories", "", "", "verbose", "", "(Z)[Ljava/lang/Integer;", "reportSeverity", "runK2JsCompiler", "", "commonArguments", "k2jsArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "sourceFiles", "", "Ljava/io/File;", "libraries", "", "outputFile", "runK2JvmCompiler", "k2jvmArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "moduleFile", "serializeWithAdditionalCompilerArgs", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)[Ljava/lang/String;", "setupK2JsArguments", "_outputFile", "_libraries", "settings", "setupK2JvmArguments", "withAdditionalArguments", "withCompilerSettings", "fn", "Lkotlin/Function0;", "Companion", "jps-plugin"})
public final class JpsKotlinCompilerRunner
extends KotlinCompilerRunner<JpsCompilerEnvironment> {
    @NotNull
    private final KotlinLogger log;
    private CompilerSettings compilerSettings;
    private static volatile CompileServiceSession _jpsCompileServiceSession;
    public static final Companion Companion;

    @Override
    @NotNull
    protected KotlinLogger getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withCompilerSettings(CompilerSettings settings, Function0<Unit> fn) {
        CompilerSettings old = this.compilerSettings;
        try {
            this.compilerSettings = settings;
            fn.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.compilerSettings = old;
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runK2JvmCompiler(@NotNull CommonCompilerArguments commonArguments, @NotNull K2JVMCompilerArguments k2jvmArguments, @NotNull CompilerSettings compilerSettings, @NotNull JpsCompilerEnvironment environment, @NotNull File moduleFile) {
        K2JVMCompilerArguments arguments;
        Intrinsics.checkParameterIsNotNull((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkParameterIsNotNull((Object)k2jvmArguments, (String)"k2jvmArguments");
        Intrinsics.checkParameterIsNotNull((Object)compilerSettings, (String)"compilerSettings");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)moduleFile, (String)"moduleFile");
        K2JVMCompilerArguments k2JVMCompilerArguments = arguments = (K2JVMCompilerArguments)ArgumentUtilsKt.mergeBeans(commonArguments, XmlSerializerUtil.createCopy((Object)k2jvmArguments));
        Intrinsics.checkExpressionValueIsNotNull((Object)k2JVMCompilerArguments, (String)"arguments");
        this.setupK2JvmArguments(moduleFile, k2JVMCompilerArguments);
        JpsKotlinCompilerRunner this_$iv = this;
        CompilerSettings old$iv = this_$iv.compilerSettings;
        try {
            this_$iv.compilerSettings = compilerSettings;
            String string = this.getK2JVM_COMPILER();
            K2JVMCompilerArguments k2JVMCompilerArguments2 = arguments;
            Intrinsics.checkExpressionValueIsNotNull((Object)k2JVMCompilerArguments2, (String)"arguments");
            this.runCompiler(string, k2JVMCompilerArguments2, (CompilerEnvironment)environment);
        }
        finally {
            this_$iv.compilerSettings = old$iv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runK2JsCompiler(@NotNull CommonCompilerArguments commonArguments, @NotNull K2JSCompilerArguments k2jsArguments, @NotNull CompilerSettings compilerSettings, @NotNull JpsCompilerEnvironment environment, @NotNull Collection<? extends File> sourceFiles, @NotNull List<String> libraries, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkParameterIsNotNull((Object)k2jsArguments, (String)"k2jsArguments");
        Intrinsics.checkParameterIsNotNull((Object)compilerSettings, (String)"compilerSettings");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        this.getLog().debug("K2JS: common arguments: " + ArgumentUtils.convertArgumentsToStringList(commonArguments));
        this.getLog().debug("K2JS: JS arguments: " + ArgumentUtils.convertArgumentsToStringList(k2jsArguments));
        K2JSCompilerArguments arguments = (K2JSCompilerArguments)ArgumentUtilsKt.mergeBeans(commonArguments, XmlSerializerUtil.createCopy((Object)k2jsArguments));
        this.getLog().debug("K2JS: merged arguments: " + ArgumentUtils.convertArgumentsToStringList(arguments));
        K2JSCompilerArguments k2JSCompilerArguments = arguments;
        Intrinsics.checkExpressionValueIsNotNull((Object)k2JSCompilerArguments, (String)"arguments");
        this.setupK2JsArguments(outputFile, sourceFiles, libraries, k2JSCompilerArguments);
        this.getLog().debug("K2JS: arguments after setup" + ArgumentUtils.convertArgumentsToStringList(arguments));
        JpsKotlinCompilerRunner this_$iv = this;
        CompilerSettings old$iv = this_$iv.compilerSettings;
        try {
            this_$iv.compilerSettings = compilerSettings;
            String string = this.getK2JS_COMPILER();
            K2JSCompilerArguments k2JSCompilerArguments2 = arguments;
            Intrinsics.checkExpressionValueIsNotNull((Object)k2JSCompilerArguments2, (String)"arguments");
            this.runCompiler(string, k2JSCompilerArguments2, (CompilerEnvironment)environment);
        }
        finally {
            this_$iv.compilerSettings = old$iv;
        }
    }

    @Override
    @NotNull
    protected ExitCode compileWithDaemonOrFallback(@NotNull String compilerClassName, @NotNull CommonCompilerArguments compilerArgs, @NotNull JpsCompilerEnvironment environment) {
        ExitCode exitCode;
        Intrinsics.checkParameterIsNotNull((Object)compilerClassName, (String)"compilerClassName");
        Intrinsics.checkParameterIsNotNull((Object)compilerArgs, (String)"compilerArgs");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        environment.getMessageCollector().report(CompilerMessageSeverity.INFO, "Using kotlin-home = " + environment.getKotlinPaths().getHomePath(), CompilerMessageLocation.NO_LOCATION);
        if (DaemonParamsKt.isDaemonEnabled()) {
            ExitCode daemonExitCode = this.compileWithDaemon(compilerClassName, compilerArgs, environment);
            exitCode = daemonExitCode;
            if (exitCode == null) {
                exitCode = this.fallbackCompileStrategy(compilerArgs, compilerClassName, environment);
            }
        } else {
            exitCode = this.fallbackCompileStrategy(compilerArgs, compilerClassName, environment);
        }
        return exitCode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected ExitCode compileWithDaemon(@NotNull String compilerClassName, @NotNull CommonCompilerArguments compilerArgs, @NotNull JpsCompilerEnvironment environment) {
        void sessionId;
        void daemon;
        CompilationOptions compilationOptions;
        CompileService.TargetPlatform targetPlatform;
        Intrinsics.checkParameterIsNotNull((Object)compilerClassName, (String)"compilerClassName");
        Intrinsics.checkParameterIsNotNull((Object)compilerArgs, (String)"compilerArgs");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        String string = compilerClassName;
        if (Intrinsics.areEqual((Object)string, (Object)this.getK2JVM_COMPILER())) {
            targetPlatform = CompileService.TargetPlatform.JVM;
        } else if (Intrinsics.areEqual((Object)string, (Object)this.getK2JS_COMPILER())) {
            targetPlatform = CompileService.TargetPlatform.JS;
        } else if (Intrinsics.areEqual((Object)string, (Object)this.getK2METADATA_COMPILER())) {
            targetPlatform = CompileService.TargetPlatform.METADATA;
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown compiler type " + compilerClassName);
        }
        CompileService.TargetPlatform targetPlatform2 = targetPlatform;
        this.getLog().debug("Try to connect to daemon");
        CompileServiceSession connection2 = this.getDaemonConnection(environment);
        if (connection2 == null) {
            this.getLog().info("Could not connect to daemon");
            return null;
        }
        CompileServiceSession compileServiceSession = connection2;
        CompileService compileService = compileServiceSession.component1();
        int n = compileServiceSession.component2();
        compileServiceSession = null;
        CompilerMode compilerMode = CompilerMode.JPS_COMPILER;
        boolean verbose = compilerArgs.verbose;
        int n2 = this.reportSeverity(verbose);
        Integer[] integerArray = this.reportCategories(verbose);
        CompileService.TargetPlatform targetPlatform3 = targetPlatform2;
        CompilerMode compilerMode2 = compilerMode;
        CompilationOptions compilationOptions2 = compilationOptions;
        CompilationOptions compilationOptions3 = compilationOptions;
        Integer[] integerArray2 = new Integer[]{};
        compilationOptions2(compilerMode2, targetPlatform3, integerArray, n2, integerArray2);
        CompilationOptions options = compilationOptions3;
        CompileService.CallResult<Integer> res2 = daemon.compile((int)sessionId, this.serializeWithAdditionalCompilerArgs(compilerArgs), options, new JpsCompilerServicesFacadeImpl(environment, 0, 2, null), null);
        return this.exitCodeFromProcessExitCode(((Number)res2.get()).intValue());
    }

    private final CommonCompilerArguments withAdditionalArguments(CommonCompilerArguments compilerArgs) {
        Collection $receiver$iv;
        CommonCompilerArguments commonCompilerArguments;
        CompilerSettings compilerSettings = this.compilerSettings;
        if (compilerSettings == null) {
            return compilerArgs;
        }
        CompilerSettings compilerSettings2 = compilerSettings;
        CommonCompilerArguments $receiver = commonCompilerArguments = ArgumentUtilsKt.copyBean(compilerArgs);
        Collection collection = $receiver$iv = (Collection)CompilerSettingsKt.getAdditionalArgumentsAsList(compilerSettings2);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ArgumentUtilsKt.parseArguments$default(stringArray, $receiver, false, 4, null);
        List<String> list = $receiver.freeArgs;
        List<String> list2 = compilerArgs.freeArgs;
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"compilerArgs.freeArgs");
        list.addAll(0, (Collection<String>)list2);
        List<String> list3 = $receiver.unknownExtraFlags;
        List<String> list4 = compilerArgs.unknownExtraFlags;
        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"compilerArgs.unknownExtraFlags");
        list3.addAll(0, (Collection<String>)list4);
        CommonCompilerArguments commonCompilerArguments2 = commonCompilerArguments;
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCompilerArguments2, (String)"copyBean(compilerArgs).a\u2026nownExtraFlags)\n        }");
        return commonCompilerArguments2;
    }

    private final String[] serializeWithAdditionalCompilerArgs(CommonCompilerArguments compilerArgs) {
        Collection $receiver$iv;
        Collection collection = $receiver$iv = (Collection)ArgumentUtils.convertArgumentsToStringList(this.withAdditionalArguments(compilerArgs));
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    private final Integer[] reportCategories(boolean verbose) {
        void $receiver$iv$iv;
        ReportCategory[] reportCategoryArray;
        if (!verbose) {
            ReportCategory[] elements$iv = new ReportCategory[]{ReportCategory.COMPILER_MESSAGE, ReportCategory.EXCEPTION};
            reportCategoryArray = elements$iv;
        } else {
            reportCategoryArray = ReportCategory.values();
        }
        ReportCategory[] categories = reportCategoryArray;
        Object $receiver$iv = (Object[])categories;
        Object[] $i$f$arrayOf = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void it;
            void item$iv$iv = $receiver$iv$iv[i];
            ReportCategory reportCategory = (ReportCategory)item$iv$iv;
            Collection collection = destination$iv$iv;
            Integer n = it.getCode();
            collection.add(n);
        }
        $receiver$iv = (List)destination$iv$iv;
        Object thisCollection$iv = $receiver$iv;
        Integer[] integerArray = thisCollection$iv.toArray(new Integer[thisCollection$iv.size()]);
        if (integerArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return integerArray;
    }

    private final int reportSeverity(boolean verbose) {
        return !verbose ? ReportSeverity.INFO.getCode() : ReportSeverity.DEBUG.getCode();
    }

    private final ExitCode fallbackCompileStrategy(CommonCompilerArguments compilerArgs, String compilerClassName, JpsCompilerEnvironment environment) {
        this.getLog().info("Compile in-process");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(stream);
        String string = System.getProperty("compile.parallel", "false");
        if (Boolean.parseBoolean(string)) {
            System.setProperty(PropertiesKt.getKOTLIN_COMPILER_ENVIRONMENT_KEEPALIVE_PROPERTY(), "true");
        }
        Object rc = CompilerRunnerUtil.invokeExecMethod(compilerClassName, this.serializeWithAdditionalCompilerArgs(compilerArgs), environment, out);
        ExitCode exitCode = ExitCode.valueOf(this.getReturnCodeFromObject(rc));
        this.processCompilerOutput((CompilerEnvironment)environment, stream, exitCode);
        return exitCode;
    }

    private final void setupK2JvmArguments(File moduleFile, K2JVMCompilerArguments settings) {
        K2JVMCompilerArguments $receiver = settings;
        $receiver.module = moduleFile.getAbsolutePath();
        $receiver.noStdlib = true;
        $receiver.noReflect = true;
        $receiver.noJdk = true;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupK2JsArguments(File _outputFile, Collection<? extends File> sourceFiles, List<String> _libraries, K2JSCompilerArguments settings) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        K2JSCompilerArguments $receiver = settings;
        $receiver.noStdlib = true;
        Iterable iterable = sourceFiles;
        K2JSCompilerArguments k2JSCompilerArguments = $receiver;
        void var8_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            String string = it.getPath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        k2JSCompilerArguments.freeArgs = collection;
        $receiver.outputFile = _outputFile.getPath();
        $receiver.metaInfo = true;
        Iterable iterable2 = _libraries;
        String string = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
        $receiver.libraries = CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }

    private final String getReturnCodeFromObject(Object rc) {
        if (rc == null) {
            return this.getINTERNAL_ERROR();
        }
        if (Intrinsics.areEqual((Object)ExitCode.class.getName(), (Object)rc.getClass().getName())) {
            return rc.toString();
        }
        throw (Throwable)new IllegalStateException("Unexpected return: " + rc);
    }

    @Override
    @Nullable
    protected CompileServiceSession getDaemonConnection(@NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        return JpsKotlinCompilerRunner.Companion.getOrCreateDaemonConnection((Function0<CompileServiceSession>)((Function0)new Function0<CompileServiceSession>(this, environment){
            final /* synthetic */ JpsKotlinCompilerRunner this$0;
            final /* synthetic */ JpsCompilerEnvironment $environment;

            @Nullable
            public final CompileServiceSession invoke() {
                File libPath = CompilerRunnerUtil.getLibPath(this.$environment.getKotlinPaths(), this.$environment.getMessageCollector());
                File compilerPath = new File(libPath, "kotlin-compiler.jar");
                CompilerId compilerId = CompilerId.Companion.makeCompilerId(compilerPath);
                DaemonOptions daemonOptions = DaemonParamsKt.configureDaemonOptions();
                File clientFlagFile = KotlinCompilerClient.INSTANCE.getOrCreateClientFlagFile(daemonOptions);
                File sessionFlagFile = ClientUtilsKt.makeAutodeletingFlagFile("compiler-jps-session-", new File(DaemonParamsKt.getRunFilesPathOrDefault(daemonOptions)));
                return this.this$0.newDaemonConnection(compilerId, clientFlagFile, sessionFlagFile, (CompilerEnvironment)this.$environment, daemonOptions);
            }
            {
                this.this$0 = jpsKotlinCompilerRunner;
                this.$environment = jpsCompilerEnvironment;
                super(0);
            }
        }));
    }

    public JpsKotlinCompilerRunner() {
        Logger logger = KotlinBuilder.Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"KotlinBuilder.LOG");
        this.log = new JpsKotlinLogger(logger);
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000bH\u0003R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/JpsKotlinCompilerRunner$Companion;", "", "()V", "_jpsCompileServiceSession", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "get_jpsCompileServiceSession", "()Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "set_jpsCompileServiceSession", "(Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;)V", "getOrCreateDaemonConnection", "newConnection", "Lkotlin/Function0;", "jps-plugin"})
    public static final class Companion {
        private final CompileServiceSession get_jpsCompileServiceSession() {
            return _jpsCompileServiceSession;
        }

        private final void set_jpsCompileServiceSession(CompileServiceSession compileServiceSession) {
            _jpsCompileServiceSession = compileServiceSession;
        }

        private final synchronized CompileServiceSession getOrCreateDaemonConnection(Function0<CompileServiceSession> newConnection) {
            if (this.get_jpsCompileServiceSession() == null) {
                this.set_jpsCompileServiceSession((CompileServiceSession)newConnection.invoke());
            }
            return this.get_jpsCompileServiceSession();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

