/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.UnmarshalException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.daemon.client.BasicCompilerServicesWithResultsFacadeServer;
import org.jetbrains.kotlin.daemon.client.CompilationServices;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.client.CompilerCallbackServicesFacadeServer;
import org.jetbrains.kotlin.daemon.client.DaemonReportMessage;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient$ClientOptions$mappers$1;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient$WhenMappings;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClientKt;
import org.jetbrains.kotlin.daemon.client.NativePlatformUtilKt;
import org.jetbrains.kotlin.daemon.client.RemoteOutputStreamServer;
import org.jetbrains.kotlin.daemon.common.BoolPropMapper;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBaseKt;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.FileAgeComparator;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.PropMapper;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001_B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JQ\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010 J\u0087\u0001\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a2\u0006\u0010!\u001a\u00020\"2\"\b\u0002\u0010#\u001a\u001c\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0&\u0012\u0004\u0012\u00020'\u0018\u00010$2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020+2\b\b\u0002\u0010\u001d\u001a\u00020\b2\b\b\u0002\u0010,\u001a\u00020-\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u000200H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002JL\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020%2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u00102\n\b\u0002\u0010?\u001a\u0004\u0018\u00010%J.\u0010@\u001a\u0004\u0018\u0001HA\"\u0004\b\u0000\u0010A2\u0006\u0010;\u001a\u00020<2\u000e\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HA0CH\u0082\b\u00a2\u0006\u0002\u0010DJ:\u0010E\u001a\u0004\u0018\u00010\u00152\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020%2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\b\b\u0002\u0010=\u001a\u00020\u0010J<\u0010E\u001a\u0004\u0018\u00010\u00152\u0006\u00104\u001a\u0002052\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\b\b\u0002\u0010=\u001a\u00020\u00102\b\b\u0002\u0010F\u001a\u00020\u0010J\u000e\u0010G\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&J\u000e\u0010H\u001a\u00020%2\u0006\u00109\u001a\u00020:Jk\u0010I\u001a\u00020\b2\u0006\u0010J\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u001c2\u0006\u0010N\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\b2\b\b\u0002\u0010,\u001a\u00020-2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010OJ\u0018\u0010P\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010Q\u001a\u0004\u0018\u00010\u0004J!\u0010R\u001a\u00020'2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010SJ\u0016\u0010T\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010U\u001a\u00020'2\u0006\u00104\u001a\u000205J\u0016\u0010U\u001a\u00020'2\u0006\u00104\u001a\u0002052\u0006\u00109\u001a\u00020:J(\u0010V\u001a\u00020'2\u0006\u00104\u001a\u0002052\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002JH\u0010W\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u0002080X2\u0006\u0010Y\u001a\u00020%2\u0006\u00104\u001a\u0002052\u0006\u00107\u001a\u0002082\u0018\u0010Z\u001a\u0014\u0012\u0004\u0012\u00020[\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020'0$H\u0002J&\u0010Z\u001a\u00020'*\u00020<2\u0006\u0010\\\u001a\u00020[2\u0006\u0010]\u001a\u00020\u00042\b\b\u0002\u0010^\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006`"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient;", "", "()V", "COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "", "getCOMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "()Ljava/lang/String;", "DAEMON_CONNECT_CYCLE_ATTEMPTS", "", "getDAEMON_CONNECT_CYCLE_ATTEMPTS", "()I", "DAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "", "getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "()J", "verboseReporting", "", "getVerboseReporting", "()Z", "compile", "compilerService", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "args", "", "out", "Ljava/io/OutputStream;", "port", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "outputsCollector", "Lkotlin/Function2;", "Ljava/io/File;", "", "", "compilerMode", "Lorg/jetbrains/kotlin/daemon/common/CompilerMode;", "reportSeverity", "Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lkotlin/jvm/functions/Function2;Lorg/jetbrains/kotlin/daemon/common/CompilerMode;Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;ILorg/jetbrains/kotlin/daemon/common/Profiler;)I", "configureClientOptions", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "opts", "connectAndLease", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "clientAliveFlagFile", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "reportingTargets", "Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;", "autostart", "leaseSession", "sessionAliveFlagFile", "connectLoop", "R", "body", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "connectToCompileService", "checkId", "detectCompilerClasspath", "getOrCreateClientFlagFile", "incrementalCompile", "compileService", "callbackServices", "Lorg/jetbrains/kotlin/daemon/client/CompilationServices;", "compilerOut", "daemonOut", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/client/CompilationServices;Ljava/io/OutputStream;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/Profiler;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "leaseCompileSession", "aliveFlagPath", "main", "([Ljava/lang/String;)V", "releaseCompileSession", "shutdownCompileService", "startDaemon", "tryFindSuitableDaemonOrNewOpts", "Lkotlin/Pair;", "registryDir", "report", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "category", "message", "source", "ClientOptions", "daemon-client"})
public final class KotlinCompilerClient {
    private static final long DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
    private static final int DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
    private static final boolean verboseReporting;
    @NotNull
    private static final String COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY = "kotlin.daemon.client.options";
    public static final KotlinCompilerClient INSTANCE;

    public final long getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS() {
        return DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
    }

    public final int getDAEMON_CONNECT_CYCLE_ATTEMPTS() {
        return DAEMON_CONNECT_CYCLE_ATTEMPTS;
    }

    public final boolean getVerboseReporting() {
        return verboseReporting;
    }

    @NotNull
    public final File getOrCreateClientFlagFile(@NotNull DaemonOptions daemonOptions) {
        Object object;
        block3: {
            block2: {
                Object object2;
                Object p1;
                Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
                object = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_CLIENT_ALIVE_PATH_PROPERTY());
                if (object == null || (object = DaemonParamsKt.trimQuotes((String)(p1 = (object2 = object)))) == null || (object = !StringsKt.isBlank((CharSequence)((CharSequence)(p1 = (object2 = object)))) ? object2 : null) == null) break block2;
                p1 = object2 = object;
                object2 = new File((String)p1);
                object = ((File)(p1 = object2)).exists() ? object2 : null;
                if (object != null) break block3;
            }
            object = ClientUtilsKt.makeAutodeletingFlagFile$default(null, new File(DaemonParamsKt.getRunFilesPathOrDefault(daemonOptions)), 1, null);
        }
        return object;
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean checkId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
        File flagFile = this.getOrCreateClientFlagFile(daemonOptions);
        return this.connectToCompileService(compilerId, flagFile, daemonJVMOptions, daemonOptions, reportingTargets, autostart);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2);
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
        CompileServiceSession compileServiceSession = this.connectAndLease(compilerId, clientAliveFlagFile, daemonJVMOptions, daemonOptions, reportingTargets, autostart, false, null);
        return compileServiceSession != null ? compileServiceSession.getCompileService() : null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CompileServiceSession connectAndLease(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean leaseSession, @Nullable File sessionAliveFlagFile) {
        Object v2;
        block15: {
            Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
            Intrinsics.checkParameterIsNotNull((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
            Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
            Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
            Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
            KotlinCompilerClient this_$iv = this;
            try {
                int attempts$iv = 0;
                while (attempts$iv < this_$iv.getDAEMON_CONNECT_CYCLE_ATTEMPTS()) {
                    void err$iv;
                    void res$iv;
                    Pair pair;
                    ++attempts$iv;
                    try {
                        CompileServiceSession compileServiceSession;
                        void service;
                        NetworkUtilsKt.ensureServerHostnameIsSetUp();
                        Pair<CompileService, DaemonJVMOptions> pair2 = INSTANCE.tryFindSuitableDaemonOrNewOpts(new File(daemonOptions.getRunFilesPath()), compilerId, daemonJVMOptions, (Function2<? super DaemonReportCategory, ? super String, Unit>)((Function2)new Function2<DaemonReportCategory, String, Unit>(daemonOptions, compilerId, daemonJVMOptions, reportingTargets, clientAliveFlagFile, leaseSession, sessionAliveFlagFile, autostart){
                            final /* synthetic */ DaemonOptions $daemonOptions$inlined;
                            final /* synthetic */ CompilerId $compilerId$inlined;
                            final /* synthetic */ DaemonJVMOptions $daemonJVMOptions$inlined;
                            final /* synthetic */ DaemonReportingTargets $reportingTargets$inlined;
                            final /* synthetic */ File $clientAliveFlagFile$inlined;
                            final /* synthetic */ boolean $leaseSession$inlined;
                            final /* synthetic */ File $sessionAliveFlagFile$inlined;
                            final /* synthetic */ boolean $autostart$inlined;
                            {
                                this.$daemonOptions$inlined = daemonOptions;
                                this.$compilerId$inlined = compilerId;
                                this.$daemonJVMOptions$inlined = daemonJVMOptions;
                                this.$reportingTargets$inlined = daemonReportingTargets;
                                this.$clientAliveFlagFile$inlined = file;
                                this.$leaseSession$inlined = bl;
                                this.$sessionAliveFlagFile$inlined = file2;
                                this.$autostart$inlined = bl2;
                                super(2);
                            }

                            public final void invoke(DaemonReportCategory cat, String msg) {
                                KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, this.$reportingTargets$inlined, cat, msg, null, 4, null);
                            }
                        }));
                        CompileService compileService = (CompileService)pair2.component1();
                        DaemonJVMOptions daemonJVMOptions2 = (DaemonJVMOptions)pair2.component2();
                        pair2 = null;
                        if (service != null) {
                            service.registerClient(clientAliveFlagFile.getAbsolutePath());
                            KotlinCompilerClient.report$default(INSTANCE, reportingTargets, DaemonReportCategory.DEBUG, "connected to the daemon", null, 4, null);
                            if (!leaseSession) {
                                compileServiceSession = new CompileServiceSession((CompileService)service, CompileService.Companion.getNO_SESSION());
                            } else {
                                File file = sessionAliveFlagFile;
                                CompileService.CallResult<Integer> sessionId = service.leaseCompileSession(file != null ? file.getAbsolutePath() : null);
                                compileServiceSession = sessionId instanceof CompileService.CallResult.Dying ? null : new CompileServiceSession((CompileService)service, ((Number)sessionId.get()).intValue());
                            }
                        } else {
                            KotlinCompilerClient.report$default(INSTANCE, reportingTargets, DaemonReportCategory.DEBUG, "no suitable daemon found", null, 4, null);
                            if (autostart) {
                                void newJVMOptions;
                                INSTANCE.startDaemon(compilerId, (DaemonJVMOptions)newJVMOptions, daemonOptions, reportingTargets);
                                KotlinCompilerClient.report$default(INSTANCE, reportingTargets, DaemonReportCategory.DEBUG, "new daemon started, trying to find it", null, 4, null);
                            }
                            compileServiceSession = null;
                        }
                        pair = TuplesKt.to(compileServiceSession, null);
                    }
                    catch (SocketException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (ConnectException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (ConnectIOException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (UnmarshalException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    Pair pair3 = pair;
                    Object object = pair3.component1();
                    IOException iOException = (IOException)pair3.component2();
                    pair3 = null;
                    if (res$iv != null) {
                        v2 = res$iv;
                        break block15;
                    }
                    if (err$iv != null && attempts$iv >= this_$iv.getDAEMON_CONNECT_CYCLE_ATTEMPTS()) {
                        throw (Throwable)err$iv;
                    }
                    if (err$iv == null) continue;
                    KotlinCompilerClient.report$default(this_$iv, reportingTargets, DaemonReportCategory.INFO, "retrying(" + attempts$iv + ") on: " + err$iv.toString(), null, 4, null);
                }
            }
            catch (Throwable e$iv) {
                KotlinCompilerClient.report$default(this_$iv, reportingTargets, DaemonReportCategory.EXCEPTION, e$iv.toString(), null, 4, null);
            }
            v2 = null;
        }
        return v2;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileServiceSession connectAndLease$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, File file2, int n, Object object) {
        if ((n & 0x80) != 0) {
            file2 = null;
        }
        return kotlinCompilerClient.connectAndLease(compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2, file2);
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
            Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
            CompileService compileService = this.connectToCompileService(compilerId, new DaemonJVMOptions(null, null, null, null, 15, null), daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), false, false);
            if (compileService == null) break block0;
            compileService.shutdown();
        }
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        this.shutdownCompileService(compilerId, new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null));
    }

    public final int leaseCompileSession(@NotNull CompileService compilerService, @Nullable String aliveFlagPath) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        return ((Number)compilerService.leaseCompileSession(aliveFlagPath).get()).intValue();
    }

    public final void releaseCompileSession(@NotNull CompileService compilerService, int sessionId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        compilerService.releaseCompileSession(sessionId);
    }

    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull OutputStream out, int port, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(out, port);
        return ((Number)compilerService.remoteCompile(sessionId, targetPlatform, args, new CompilerCallbackServicesFacadeServer(null, null, port, 3, null), outStrm, CompileService.OutputFormat.PLAIN, outStrm, operationsTracer).get()).intValue();
    }

    public static /* bridge */ /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, OutputStream outputStream, int n2, RemoteOperationsTracer remoteOperationsTracer, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            n2 = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        if ((n3 & 0x40) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, outputStream, n2, remoteOperationsTracer);
    }

    public final int incrementalCompile(@NotNull CompileService compileService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilationServices callbackServices, @NotNull OutputStream compilerOut, @NotNull OutputStream daemonOut, int port, @NotNull Profiler profiler, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull((Object)compileService, (String)"compileService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)callbackServices, (String)"callbackServices");
        Intrinsics.checkParameterIsNotNull((Object)compilerOut, (String)"compilerOut");
        Intrinsics.checkParameterIsNotNull((Object)daemonOut, (String)"daemonOut");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        return ((Number)profiler.withMeasure(this, (Function0)new Function0<Integer>(compileService, sessionId, targetPlatform, args, callbackServices, port, compilerOut, daemonOut, operationsTracer){
            final /* synthetic */ CompileService $compileService;
            final /* synthetic */ int $sessionId;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilationServices $callbackServices;
            final /* synthetic */ int $port;
            final /* synthetic */ OutputStream $compilerOut;
            final /* synthetic */ OutputStream $daemonOut;
            final /* synthetic */ RemoteOperationsTracer $operationsTracer;

            public final int invoke() {
                return ((Number)this.$compileService.remoteIncrementalCompile(this.$sessionId, this.$targetPlatform, this.$args, new CompilerCallbackServicesFacadeServer(this.$callbackServices.getIncrementalCompilationComponents(), this.$callbackServices.getCompilationCanceledStatus(), this.$port), new RemoteOutputStreamServer(this.$compilerOut, this.$port), CompileService.OutputFormat.XML, new RemoteOutputStreamServer(this.$daemonOut, this.$port), this.$operationsTracer).get()).intValue();
            }
            {
                this.$compileService = compileService;
                this.$sessionId = n;
                this.$targetPlatform = targetPlatform;
                this.$args = stringArray;
                this.$callbackServices = compilationServices;
                this.$port = n2;
                this.$compilerOut = outputStream;
                this.$daemonOut = outputStream2;
                this.$operationsTracer = remoteOperationsTracer;
                super(0);
            }
        })).intValue();
    }

    public static /* bridge */ /* synthetic */ int incrementalCompile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, CompilationServices compilationServices, OutputStream outputStream, OutputStream outputStream2, int n2, Profiler profiler, RemoteOperationsTracer remoteOperationsTracer, int n3, Object object) {
        if ((n3 & 0x80) != 0) {
            n2 = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        if ((n3 & 0x100) != 0) {
            profiler = new DummyProfiler();
        }
        if ((n3 & 0x200) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.incrementalCompile(compileService, n, targetPlatform, stringArray, compilationServices, outputStream, outputStream2, n2, profiler, remoteOperationsTracer);
    }

    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull MessageCollector messageCollector, @Nullable Function2<? super File, ? super List<? extends File>, Unit> outputsCollector, @NotNull CompilerMode compilerMode, @NotNull ReportSeverity reportSeverity, int port, @NotNull Profiler profiler) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)compilerMode, (String)"compilerMode");
        Intrinsics.checkParameterIsNotNull((Object)((Object)reportSeverity), (String)"reportSeverity");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        return ((Number)profiler.withMeasure(this, (Function0)new Function0<Integer>(messageCollector, outputsCollector, port, compilerService, sessionId, args, compilerMode, targetPlatform, reportSeverity){
            final /* synthetic */ MessageCollector $messageCollector;
            final /* synthetic */ Function2 $outputsCollector;
            final /* synthetic */ int $port;
            final /* synthetic */ CompileService $compilerService;
            final /* synthetic */ int $sessionId;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilerMode $compilerMode;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ ReportSeverity $reportSeverity;

            /*
             * WARNING - void declaration
             */
            public final int invoke() {
                void elements$iv;
                CompilationOptions compilationOptions;
                BasicCompilerServicesWithResultsFacadeServer services = new BasicCompilerServicesWithResultsFacadeServer(this.$messageCollector, (Function2<? super File, ? super List<? extends File>, Unit>)this.$outputsCollector, this.$port);
                Integer[] integerArray = new Integer[]{ReportCategory.COMPILER_MESSAGE.getCode(), ReportCategory.DAEMON_MESSAGE.getCode(), ReportCategory.EXCEPTION.getCode(), ReportCategory.OUTPUT_MESSAGE.getCode()};
                CompileService.TargetPlatform targetPlatform = this.$targetPlatform;
                CompilerMode compilerMode = this.$compilerMode;
                CompilationOptions compilationOptions2 = compilationOptions;
                CompilationOptions compilationOptions3 = compilationOptions;
                String[] stringArray = this.$args;
                int n = this.$sessionId;
                CompileService compileService = this.$compilerService;
                void var11_10 = elements$iv;
                int n2 = this.$reportSeverity.getCode();
                Integer[] integerArray2 = new Integer[]{};
                compilationOptions2(compilerMode, targetPlatform, (Integer[])var11_10, n2, integerArray2);
                return ((Number)compileService.compile(n, stringArray, compilationOptions3, services, null).get()).intValue();
            }
            {
                this.$messageCollector = messageCollector;
                this.$outputsCollector = function2;
                this.$port = n;
                this.$compilerService = compileService;
                this.$sessionId = n2;
                this.$args = stringArray;
                this.$compilerMode = compilerMode;
                this.$targetPlatform = targetPlatform;
                this.$reportSeverity = reportSeverity;
                super(0);
            }
        })).intValue();
    }

    public static /* bridge */ /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, MessageCollector messageCollector, Function2 function2, CompilerMode compilerMode, ReportSeverity reportSeverity, int n2, Profiler profiler, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            function2 = null;
        }
        if ((n3 & 0x40) != 0) {
            compilerMode = CompilerMode.NON_INCREMENTAL_COMPILER;
        }
        if ((n3 & 0x80) != 0) {
            reportSeverity = ReportSeverity.INFO;
        }
        if ((n3 & 0x100) != 0) {
            n2 = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        if ((n3 & 0x200) != 0) {
            profiler = new DummyProfiler();
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, messageCollector, (Function2<? super File, ? super List<? extends File>, Unit>)function2, compilerMode, reportSeverity, n2, profiler);
    }

    @NotNull
    public final String getCOMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY() {
        return COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY;
    }

    private final ClientOptions configureClientOptions(ClientOptions opts) {
        String string = System.getProperty(COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY);
        if (string != null) {
            String string2;
            String it = string2 = string;
            Iterable unrecognized = DaemonParamsKt.filterExtractProps$default(StringsKt.split$default((CharSequence)DaemonParamsKt.trimQuotes(it), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null), opts.getMappers(), "", null, 4, null);
            if (CollectionsKt.any((Iterable)unrecognized)) {
                throw (Throwable)new IllegalArgumentException("Unrecognized client options passed via property " + DaemonParamsKt.getCOMPILE_DAEMON_OPTIONS_PROPERTY() + ": " + CollectionsKt.joinToString$default((Iterable)unrecognized, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\nSupported options: " + CollectionsKt.joinToString$default((Iterable)opts.getMappers(), (CharSequence)", ", null, null, (int)0, null, (Function1)configureClientOptions.1.1.INSTANCE, (int)30, null));
            }
        }
        return opts;
    }

    private final ClientOptions configureClientOptions() {
        return this.configureClientOptions(new ClientOptions(false, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void main(String ... args) {
        CompileService compileService;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = DaemonParamsKt.configureDaemonOptions();
        String[] stringArray = new String[]{};
        boolean bl = true;
        boolean bl2 = true;
        DaemonJVMOptions daemonLaunchingOptions = DaemonParamsKt.configureDaemonJVMOptions(stringArray, bl2, bl);
        ClientOptions clientOptions = INSTANCE.configureClientOptions();
        OptionsGroup[] optionsGroupArray = new OptionsGroup[]{compilerId, daemonOptions, daemonLaunchingOptions, clientOptions};
        String string = DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX();
        Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(ArraysKt.asIterable((Object[])args), optionsGroupArray, string);
        if (!clientOptions.getStop()) {
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                System.err.println("compiler wasn't explicitly specified, attempt to find appropriate jar");
                List<String> list = INSTANCE.detectCompilerClasspath();
                if (list != null) {
                    List<String> list2;
                    List<String> list3 = list2 = list;
                    compilerId.setCompilerClasspath(list3);
                }
            }
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                throw (Throwable)new IllegalArgumentException("Cannot find compiler jar");
            }
            StringBuilder stringBuilder = new StringBuilder().append("desired compiler classpath: ");
            Iterable iterable = compilerId.getCompilerClasspath();
            String string2 = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
            String string3 = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null)).toString();
            System.out.println((Object)string3);
        }
        if ((compileService = INSTANCE.connectToCompileService(compilerId, daemonLaunchingOptions, daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), !clientOptions.getStop(), !clientOptions.getStop())) == null) {
            if (!clientOptions.getStop()) throw (Throwable)new Exception("Unable to connect to daemon");
            System.err.println("No daemon found to shut down");
            return;
        }
        if (clientOptions.getStop()) {
            String string4 = "Shutdown the daemon";
            System.out.println((Object)string4);
            compileService.shutdown();
            String string5 = "Daemon shut down successfully";
            System.out.println((Object)string5);
            return;
        }
        if (CollectionsKt.none(filteredArgs)) {
            String string6 = "Warning: empty arguments list, only daemon check is performed: checkCompilerId() returns " + compileService.checkCompilerId(compilerId);
            System.out.println((Object)string6);
            return;
        }
        String string7 = "Executing daemon compilation with args: " + CollectionsKt.joinToString$default(filteredArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        System.out.println((Object)string7);
        PrintStream printStream = System.out;
        Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.out");
        RemoteOutputStreamServer remoteOutputStreamServer = new RemoteOutputStreamServer(printStream, 0, 2, null);
        CompilerCallbackServicesFacadeServer servicesFacade = new CompilerCallbackServicesFacadeServer(null, null, 0, 7, null);
        try {
            void $receiver$iv;
            long memBefore = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            long startTime = System.nanoTime();
            Collection collection = CollectionsKt.toList(filteredArgs);
            CompileService.TargetPlatform targetPlatform = CompileService.TargetPlatform.JVM;
            int n = CompileService.Companion.getNO_SESSION();
            Object object = compileService;
            void v5 = $receiver$iv;
            if (v5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v5;
            String[] stringArray2 = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray3 = stringArray2;
            CompileService.CallResult<Integer> res2 = object.remoteCompile(n, targetPlatform, stringArray3, servicesFacade, remoteOutputStreamServer, CompileService.OutputFormat.PLAIN, remoteOutputStreamServer, null);
            long endTime = System.nanoTime();
            String $i$f$toTypedArray = "Compilation " + (res2.isGood() ? "succeeded" : "failed") + ", result code: " + ((Number)res2.get()).intValue();
            System.out.println((Object)$i$f$toTypedArray);
            long memAfter = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            String string8 = "Compilation time: " + TimeUnit.NANOSECONDS.toMillis(endTime - startTime) + " ms";
            System.out.println((Object)string8);
            string8 = "%+d";
            Object[] objectArray = new Object[]{memAfter - memBefore};
            object = new StringBuilder().append("Used memory ").append(memAfter).append(" (");
            String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"java.lang.String.format(this, *args)");
            String string10 = string9;
            string8 = ((StringBuilder)object).append(string10).append(" kb)").toString();
            System.out.println((Object)string8);
            return;
        }
        finally {
            UnicastRemoteObject.unexportObject(servicesFacade, true);
            UnicastRemoteObject.unexportObject(remoteOutputStreamServer, true);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final List<String> detectCompilerClasspath() {
        Object object;
        Iterable $receiver$iv$iv;
        String string = System.getProperty("java.class.path");
        Object object2 = string;
        if (string == null) return null;
        CharSequence charSequence = (CharSequence)object2;
        String[] stringArray = new String[1];
        String string2 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
        stringArray[0] = string2;
        List list = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        object2 = list;
        if (list == null) return null;
        Iterable $receiver$iv = (Iterable)object2;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            File file = new File((String)it).getParentFile();
            collection.add(file);
        }
        List list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        object2 = list2;
        if (list2 == null) return null;
        $receiver$iv = (Iterable)object2;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            File file;
            File file2;
            Object element$iv$iv = element$iv$iv$iv;
            File it = (File)element$iv$iv;
            File file3 = it;
            if (file3 != null && (file3 = FilesKt.walk$default((File)file3, null, (int)1, null)) != null) {
                Object v8;
                block5: {
                    void $receiver$iv2;
                    Sequence $i$f$map = (Sequence)file3;
                    for (Object element$iv : $receiver$iv2) {
                        File it2 = (File)element$iv;
                        if (!StringsKt.equals((String)it2.getName(), (String)DaemonParamsKt.getCOMPILER_JAR_NAME(), (boolean)true)) continue;
                        v8 = element$iv;
                        break block5;
                    }
                    v8 = null;
                }
                file2 = v8;
            } else {
                file2 = null;
            }
            if (file2 == null) continue;
            File it$iv$iv = file = file2;
            destination$iv$iv.add(it$iv$iv);
        }
        File file = (File)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        object2 = file;
        if (file == null) return null;
        Object it = object = object2;
        List list3 = CollectionsKt.listOf((Object)((File)it).getAbsolutePath());
        return list3;
    }

    /*
     * WARNING - void declaration
     */
    private final <R> R connectLoop(DaemonReportingTargets reportingTargets, Function0<? extends R> body) {
        try {
            int attempts = 0;
            while (attempts < this.getDAEMON_CONNECT_CYCLE_ATTEMPTS()) {
                void err;
                void res2;
                Pair pair;
                ++attempts;
                try {
                    pair = TuplesKt.to((Object)body.invoke(), null);
                }
                catch (SocketException e) {
                    pair = TuplesKt.to(null, (Object)e);
                }
                catch (ConnectException e) {
                    pair = TuplesKt.to(null, (Object)e);
                }
                catch (ConnectIOException e) {
                    pair = TuplesKt.to(null, (Object)e);
                }
                catch (UnmarshalException e) {
                    pair = TuplesKt.to(null, (Object)e);
                }
                Pair pair2 = pair;
                Object object = pair2.component1();
                IOException iOException = (IOException)pair2.component2();
                pair2 = null;
                if (res2 != null) {
                    return res2;
                }
                if (err != null && attempts >= this.getDAEMON_CONNECT_CYCLE_ATTEMPTS()) {
                    throw (Throwable)err;
                }
                if (err == null) continue;
                KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.INFO, "retrying(" + attempts + ") on: " + err.toString(), null, 4, null);
            }
        }
        catch (Throwable e) {
            KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.EXCEPTION, e.toString(), null, 4, null);
        }
        return null;
    }

    private final void report(@NotNull DaemonReportingTargets $receiver, DaemonReportCategory category, String message, String source) {
        block14: {
            Object it;
            Object object;
            if (Intrinsics.areEqual((Object)((Object)category), (Object)((Object)DaemonReportCategory.DEBUG)) && !verboseReporting) {
                return;
            }
            PrintStream printStream = $receiver.getOut();
            if (printStream != null) {
                printStream.println("[" + source + "] " + category.name() + ": " + message);
            }
            Collection<DaemonReportMessage> collection = $receiver.getMessages();
            if (collection != null) {
                collection.add(new DaemonReportMessage(category, "[" + source + "] " + message));
            }
            MessageCollector messageCollector = $receiver.getMessageCollector();
            if (messageCollector != null) {
                it = object = messageCollector;
                switch (KotlinCompilerClient$WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
                    case 1: {
                        it.report(CompilerMessageSeverity.LOGGING, message, CompilerMessageLocation.NO_LOCATION);
                        break;
                    }
                    case 2: {
                        it.report(CompilerMessageSeverity.INFO, message, CompilerMessageLocation.NO_LOCATION);
                        break;
                    }
                    case 3: {
                        it.report(CompilerMessageSeverity.EXCEPTION, message, CompilerMessageLocation.NO_LOCATION);
                    }
                }
            }
            CompilerServicesFacadeBase compilerServicesFacadeBase = $receiver.getCompilerServices();
            if (compilerServicesFacadeBase == null) break block14;
            it = object = compilerServicesFacadeBase;
            switch (KotlinCompilerClient$WhenMappings.$EnumSwitchMapping$1[category.ordinal()]) {
                case 1: {
                    CompilerServicesFacadeBaseKt.report((CompilerServicesFacadeBase)it, ReportCategory.DAEMON_MESSAGE, ReportSeverity.DEBUG, message, (Serializable)((Object)source));
                    break;
                }
                case 2: {
                    CompilerServicesFacadeBaseKt.report((CompilerServicesFacadeBase)it, ReportCategory.DAEMON_MESSAGE, ReportSeverity.INFO, message, (Serializable)((Object)source));
                    break;
                }
                case 3: {
                    CompilerServicesFacadeBaseKt.report((CompilerServicesFacadeBase)it, ReportCategory.EXCEPTION, ReportSeverity.ERROR, message, (Serializable)((Object)source));
                }
            }
        }
    }

    static /* bridge */ /* synthetic */ void report$default(KotlinCompilerClient kotlinCompilerClient, DaemonReportingTargets daemonReportingTargets, DaemonReportCategory daemonReportCategory, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "daemon client";
        }
        kotlinCompilerClient.report(daemonReportingTargets, daemonReportCategory, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Pair<CompileService, DaemonJVMOptions> tryFindSuitableDaemonOrNewOpts(File registryDir, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        Pair pair;
        Object it;
        List list;
        registryDir.mkdirs();
        File timestampMarker = FilesKt.createTempFile$default((String)"kotlin-daemon-client-tsmarker", null, (File)registryDir, (int)2, null);
        try {
            list = SequencesKt.toList((Sequence)ClientUtilsKt.walkDaemons$default(registryDir, compilerId, timestampMarker, null, report2, 8, null));
        }
        finally {
            timestampMarker.delete();
        }
        List aliveWithMetadata = list;
        Comparator comparator = new DaemonJVMOptionsMemoryComparator();
        comparator = new Comparator<DaemonWithMetadata>(comparator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $captured_local_variable$0;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int compare(Object a, Object b) {
                DaemonWithMetadata it;
                Comparator comparator = this.$comparator;
                DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)b;
                Comparator comparator2 = comparator;
                DaemonJVMOptions daemonJVMOptions = it.getJvmOptions();
                it = (DaemonWithMetadata)a;
                DaemonJVMOptions daemonJVMOptions2 = it.getJvmOptions();
                return comparator2.compare(daemonJVMOptions, daemonJVMOptions2);
            }
        };
        Object object = new FileAgeComparator();
        Comparator comparator2 = new Comparator<DaemonWithMetadata>(comparator, (Comparator)object){
            final /* synthetic */ Comparator receiver$0;
            final /* synthetic */ Comparator $comparator;
            {
                this.receiver$0 = $receiver;
                this.$comparator = $captured_local_variable$1;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int compare(Object a, Object b) {
                int n;
                int previousCompare = this.receiver$0.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    DaemonWithMetadata it;
                    Comparator comparator = this.$comparator;
                    DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                    Comparator comparator2 = comparator;
                    File file = it.getRunFile();
                    it = (DaemonWithMetadata)b;
                    File file2 = it.getRunFile();
                    n = comparator2.compare(file, file2);
                }
                return n;
            }
        };
        DaemonJVMOptions optsCopy = DaemonJVMOptions.copy$default(daemonJVMOptions, null, null, null, null, 15, null);
        Object object2 = (DaemonWithMetadata)CollectionsKt.maxWith((Iterable)aliveWithMetadata, (Comparator)comparator2);
        if (object2 != null && (object2 = DaemonParamsKt.memorywiseFitsInto(daemonJVMOptions, ((DaemonWithMetadata)(it = (object = object2))).getJvmOptions()) ? object : null) != null) {
            it = object = object2;
            pair = new Pair((Object)((DaemonWithMetadata)it).getDaemon(), (Object)DaemonParamsKt.updateMemoryUpperBounds(optsCopy, ((DaemonWithMetadata)it).getJvmOptions()));
        } else {
            void $receiver$iv;
            Pair pair2;
            object = aliveWithMetadata;
            Object var19_12 = null;
            Pair pair3 = pair2;
            Pair pair4 = pair2;
            DaemonJVMOptions accumulator$iv = optsCopy;
            for (Object element$iv : $receiver$iv) {
                void d;
                DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)element$iv;
                DaemonJVMOptions opts = accumulator$iv;
                accumulator$iv = DaemonParamsKt.updateMemoryUpperBounds(opts, d.getJvmOptions());
            }
            DaemonJVMOptions daemonJVMOptions2 = accumulator$iv;
            pair = pair4;
            pair3(var19_12, (Object)daemonJVMOptions2);
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void startDaemon(CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets reportingTargets) {
        javaExecutable = new File(new File(System.getProperty("java.home"), "bin"), "java");
        v0 = System.getProperty(NetworkUtilsKt.getJAVA_RMI_SERVER_HOSTNAME());
        if (v0 == null) {
            var7_6 = NetworkUtilsKt.getJAVA_RMI_SERVER_HOSTNAME() + " is not set!";
            throw (Throwable)new IllegalStateException(var7_6.toString());
        }
        serverHostname = v0;
        platformSpecificOptions = CollectionsKt.listOf((Object[])new String[]{"-Djava.awt.headless=true", "-D" + NetworkUtilsKt.getJAVA_RMI_SERVER_HOSTNAME() + "=" + serverHostname});
        v1 = new String[3];
        v1[0] = javaExecutable.getAbsolutePath();
        v1[1] = "-cp";
        v2 = compilerId.getCompilerClasspath();
        v3 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"File.pathSeparator");
        v1[2] = CollectionsKt.joinToString$default((Iterable)v2, (CharSequence)v3, null, null, (int)0, null, null, (int)62, null);
        var9_9 = daemonJVMOptions.getMappers();
        var20_10 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])v1), (Iterable)platformSpecificOptions);
        var10_11 = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (PropMapper)element$iv$iv;
            list$iv$iv = it.toArgs("-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var21_21 = (List)destination$iv$iv;
        $receiver$iv = daemonOptions.getMappers();
        var20_10 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)var20_10, (Iterable)var21_21), (Object)DaemonParamsKt.getCOMPILER_DAEMON_CLASS_FQN());
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (PropMapper)element$iv$iv;
            list$iv$iv = it.toArgs(DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var21_21 = (List)destination$iv$iv;
        $receiver$iv = compilerId.getMappers();
        var20_10 = CollectionsKt.plus((Collection)var20_10, (Iterable)var21_21);
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (PropMapper)element$iv$iv;
            list$iv$iv = it.toArgs(DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var21_21 = (List)destination$iv$iv;
        args = CollectionsKt.plus((Collection)var20_10, (Iterable)var21_21);
        KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "starting the daemon as: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, 4, null);
        processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        try {
            destination$iv$iv = NativePlatformUtilKt.launchWithNativePlatformLauncher(processBuilder);
        }
        catch (IOException e) {
            KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "Could not start daemon with native process launcher, falling back to ProcessBuilder#start (" + e.getCause() + ")", null, 4, null);
            destination$iv$iv = null;
        }
        catch (NoClassDefFoundError e) {
            KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "net.rubygrapefruit.platform library is not in the classpath, falling back to ProcessBuilder#start", null, 4, null);
            destination$iv$iv = null;
        }
        if ((v4 = destination$iv$iv) == null) {
            v4 = processBuilder.start();
        }
        daemon = v4;
        isEchoRead = new Semaphore(1);
        isEchoRead.acquire();
        stdoutThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>((Process)daemon, reportingTargets, isEchoRead){
            final /* synthetic */ Process $daemon;
            final /* synthetic */ DaemonReportingTargets $reportingTargets;
            final /* synthetic */ Semaphore $isEchoRead;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    InputStream inputStream = this.$daemon.getInputStream();
                    Charset charset = null;
                    boolean bl = true;
                    Object var4_5 = null;
                    if (bl & true) {
                        charset = Charsets.UTF_8;
                    }
                    TextStreamsKt.forEachLine((Reader)new InputStreamReader(inputStream, charset), (Function1)((Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ startDaemon.stdoutThread.1 this$0;

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            KotlinCompilerClient.access$report(KotlinCompilerClient.INSTANCE, this.this$0.$reportingTargets, DaemonReportCategory.DEBUG, it, "daemon");
                            if (Intrinsics.areEqual((Object)it, (Object)DaemonParamsKt.getCOMPILE_DAEMON_IS_READY_MESSAGE())) {
                                KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, this.this$0.$reportingTargets, DaemonReportCategory.DEBUG, "Received the message signalling that the daemon is ready", null, 4, null);
                                this.this$0.$isEchoRead.release();
                                return;
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }
                finally {
                    this.$daemon.getInputStream().close();
                    this.$daemon.getOutputStream().close();
                    this.$daemon.getErrorStream().close();
                }
            }
            {
                this.$daemon = process;
                this.$reportingTargets = daemonReportingTargets;
                this.$isEchoRead = semaphore;
                super(0);
            }
        }), (int)31, null);
        try {
            v5 = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY());
            if (v5 == null) ** GOTO lbl-1000
            $i$a$3$flatMap = v5;
            it = $i$a$3$flatMap;
            try {
                var17_25 = it;
                var17_25 = Long.parseLong((String)var17_25);
            }
            catch (Exception e) {
                KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, reportingTargets, DaemonReportCategory.INFO, "unable to interpret " + DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY() + " property ('" + it + "'); using default timeout " + KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS + " ms", null, 4, null);
                var17_25 = null;
            }
            if ((v5 = var17_25) != null) {
                v6 = v5.longValue();
            } else lbl-1000:
            // 2 sources

            {
                v6 = KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
            }
            daemonStartupTimeout = v6;
            $i$a$3$flatMap = daemonOptions.getRunFilesPath();
            if ($i$a$3$flatMap.length() > 0) {
                succeeded = isEchoRead.tryAcquire(daemonStartupTimeout, TimeUnit.MILLISECONDS);
                v7 = daemon;
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"daemon");
                if (!KotlinCompilerClientKt.isProcessAlive((Process)v7)) {
                    throw (Throwable)new Exception("Daemon terminated unexpectedly with error code: " + daemon.exitValue());
                }
                if (!succeeded) {
                    throw (Throwable)new Exception("Unable to get response from daemon in " + daemonStartupTimeout + " ms");
                }
            } else {
                Thread.sleep(daemonStartupTimeout);
            }
        }
        finally {
            if (stdoutThread.isAlive()) {
                stdoutThread.stop();
            }
            v8 = reportingTargets.getOut();
            if (v8 != null) {
                v8.flush();
            }
        }
    }

    private KotlinCompilerClient() {
        INSTANCE = this;
        DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
        DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
        verboseReporting = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_VERBOSE_REPORT_PROPERTY()) != null;
        COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY = COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY;
    }

    static {
        new KotlinCompilerClient();
    }

    public static final /* synthetic */ void access$report(KotlinCompilerClient $this, @NotNull DaemonReportingTargets $receiver, @NotNull DaemonReportCategory category, @NotNull String message, @NotNull String source) {
        $this.report($receiver, category, message, source);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "Lorg/jetbrains/kotlin/daemon/common/OptionsGroup;", "stop", "", "(Z)V", "mappers", "", "Lorg/jetbrains/kotlin/daemon/common/PropMapper;", "getMappers", "()Ljava/util/List;", "getStop", "()Z", "setStop", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "daemon-client"})
    public static final class ClientOptions
    implements OptionsGroup {
        private boolean stop;

        @Override
        @NotNull
        public List<PropMapper<?, ?, ?>> getMappers() {
            return CollectionsKt.listOf(new BoolPropMapper(this, KotlinCompilerClient$ClientOptions$mappers$1.INSTANCE, null, 4, null));
        }

        public final boolean getStop() {
            return this.stop;
        }

        public final void setStop(boolean bl) {
            this.stop = bl;
        }

        public ClientOptions(boolean stop) {
            this.stop = stop;
        }

        public /* synthetic */ ClientOptions(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public ClientOptions() {
            this(false, 1, null);
        }

        public final boolean component1() {
            return this.stop;
        }

        @NotNull
        public final ClientOptions copy(boolean stop) {
            return new ClientOptions(stop);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ClientOptions copy$default(ClientOptions clientOptions, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = clientOptions.stop;
            }
            return clientOptions.copy(bl);
        }

        public String toString() {
            return "ClientOptions(stop=" + this.stop + ")";
        }

        public int hashCode() {
            int n = this.stop ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClientOptions)) break block3;
                    ClientOptions clientOptions = (ClientOptions)object;
                    if (!(this.stop == clientOptions.stop)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

