/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u001e\u0010\r\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002JH\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b26\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\t0\u0016H\u0002JH\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b26\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\t0\u0016H\u0002JH\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b26\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\t0\u0016H\u0002JN\u0010\u001d\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f26\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\t0\u0016H\u0007JH\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u000b26\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\t0\u0016H\u0007JD\u0010!\u001a\u00020\t*\u00020\u000b26\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\t0\u0016H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/utils/JsLibraryUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "META_INF_RESOURCES", "", "copyJsFilesFromDirectory", "", "dir", "Ljava/io/File;", "outputLibraryJsPath", "copyJsFilesFromLibraries", "libraries", "", "copyJsFilesFromZip", "file", "getSuggestedPath", "path", "processDirectory", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "content", "relativePath", "traverseArchive", "traverseDirectory", "traverseJsLibraries", "libs", "traverseJsLibrary", "lib", "runIfFileExists", "util"})
public final class JsLibraryUtils {
    private static final Logger LOG;
    private static final String META_INF_RESOURCES = "META-INF/resources/";
    public static final JsLibraryUtils INSTANCE;

    @JvmStatic
    public static final void copyJsFilesFromLibraries(@NotNull List<String> libraries, @NotNull String outputLibraryJsPath) {
        Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
        Intrinsics.checkParameterIsNotNull((Object)outputLibraryJsPath, (String)"outputLibraryJsPath");
        for (String library : libraries) {
            File file = new File(library);
            boolean bl = file.exists();
            if (_Assertions.ENABLED && !bl) {
                String string = "Library " + library + " not found";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (file.isDirectory()) {
                INSTANCE.copyJsFilesFromDirectory(file, outputLibraryJsPath);
                continue;
            }
            INSTANCE.copyJsFilesFromZip(file, outputLibraryJsPath);
        }
    }

    @JvmStatic
    public static final void traverseJsLibraries(@NotNull List<? extends File> libs, @NotNull Function2<? super String, ? super String, Unit> action) {
        Intrinsics.checkParameterIsNotNull(libs, (String)"libs");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Iterable $receiver$iv = libs;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            JsLibraryUtils.traverseJsLibrary(it, action);
        }
    }

    @JvmStatic
    public static final void traverseJsLibrary(@NotNull File lib, @NotNull Function2<? super String, ? super String, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)lib, (String)"lib");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        if (lib.isDirectory()) {
            INSTANCE.traverseDirectory(lib, action);
        } else if (FileUtil.isJarOrZip((File)lib)) {
            INSTANCE.traverseArchive(lib, action);
        } else if (StringsKt.endsWith$default((String)lib.getName(), (String)".js", (boolean)false, (int)2, null)) {
            File jsFile;
            INSTANCE.runIfFileExists(lib, action);
            File file = jsFile = FileUtilsKt.withReplacedExtensionOrNull(lib, ".meta.js", ".js");
            if (file != null) {
                INSTANCE.runIfFileExists(file, action);
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown library format (directory, zip or js file expected): " + lib);
        }
    }

    private final void runIfFileExists(@NotNull File $receiver, Function2<? super String, ? super String, Unit> action) {
        if ($receiver.isFile()) {
            String string = FileUtil.loadFile((File)$receiver);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.loadFile(this)");
            action.invoke((Object)string, (Object)"");
        }
    }

    private final void copyJsFilesFromDirectory(File dir, String outputLibraryJsPath) {
        this.traverseDirectory(dir, (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(outputLibraryJsPath){
            final /* synthetic */ String $outputLibraryJsPath;

            public final void invoke(@NotNull String content, @NotNull String relativePath) {
                Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
                Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                FileUtil.writeToFile((File)new File(this.$outputLibraryJsPath, relativePath), (String)content);
            }
            {
                this.$outputLibraryJsPath = string;
                super(2);
            }
        }));
    }

    private final void processDirectory(File dir, Function2<? super String, ? super String, Unit> action) {
        FileUtil.processFilesRecursively((File)dir, (Processor)((Processor)new Processor<File>(dir, action){
            final /* synthetic */ File $dir;
            final /* synthetic */ Function2 $action;

            public final boolean process(File file) {
                String string = FileUtil.getRelativePath((File)this.$dir, (File)file);
                if (string == null) {
                    throw (Throwable)new IllegalArgumentException("relativePath should not be null " + this.$dir + " " + file);
                }
                String relativePath = string;
                if (file.isFile() && StringsKt.endsWith$default((String)relativePath, (String)".js", (boolean)false, (int)2, null)) {
                    String string2 = relativePath;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"relativePath");
                    String string3 = JsLibraryUtils.access$getSuggestedPath(JsLibraryUtils.INSTANCE, string2);
                    if (string3 == null) {
                        return true;
                    }
                    String suggestedRelativePath = string3;
                    String string4 = FileUtil.loadFile((File)file);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"FileUtil.loadFile(file)");
                    this.$action.invoke((Object)string4, (Object)suggestedRelativePath);
                }
                return true;
            }
            {
                this.$dir = file;
                this.$action = function2;
            }
        }));
    }

    private final void traverseDirectory(File dir, Function2<? super String, ? super String, Unit> action) {
        try {
            this.processDirectory(dir, action);
        }
        catch (IOException ex) {
            LOG.error("Could not read files from directory " + dir.getName() + ": " + ex.getMessage());
        }
    }

    private final void copyJsFilesFromZip(File file, String outputLibraryJsPath) {
        this.traverseArchive(file, (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(outputLibraryJsPath){
            final /* synthetic */ String $outputLibraryJsPath;

            public final void invoke(@NotNull String content, @NotNull String relativePath) {
                Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
                Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                FileUtil.writeToFile((File)new File(this.$outputLibraryJsPath, relativePath), (String)content);
            }
            {
                this.$outputLibraryJsPath = string;
                super(2);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void traverseArchive(File file, Function2<? super String, ? super String, Unit> action) {
        ZipFile zipFile = new ZipFile(file.getPath());
        try {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                String relativePath;
                String content;
                ZipEntry entry = zipEntries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory() || !StringsKt.endsWith$default((String)entryName, (String)".js", (boolean)false, (int)2, null)) continue;
                String string = entryName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entryName");
                if (this.getSuggestedPath(string) == null) {
                    continue;
                }
                InputStream stream = zipFile.getInputStream(entry);
                String string2 = content = FileUtil.loadTextAndClose((InputStream)stream);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"content");
                action.invoke((Object)string2, (Object)relativePath);
            }
        }
        catch (IOException ex) {
            LOG.error("Could not extract files from archive " + file.getName() + ": " + ex.getMessage());
        }
        finally {
            zipFile.close();
        }
    }

    private final String getSuggestedPath(String path) {
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)path);
        if (StringsKt.startsWith$default((String)systemIndependentPath, (String)LibraryUtils.INSTANCE.getMETA_INF(), (boolean)false, (int)2, null)) {
            if (StringsKt.startsWith$default((String)systemIndependentPath, (String)META_INF_RESOURCES, (boolean)false, (int)2, null)) {
                String string = path;
                int n = META_INF_RESOURCES.length();
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                return string3;
            }
            return null;
        }
        return path;
    }

    private JsLibraryUtils() {
        INSTANCE = this;
        LOG = Logger.getInstance(LibraryUtils.class);
        META_INF_RESOURCES = LibraryUtils.INSTANCE.getMETA_INF() + "resources/";
    }

    static {
        new JsLibraryUtils();
    }

    @Nullable
    public static final /* synthetic */ String access$getSuggestedPath(JsLibraryUtils $this, @NotNull String path) {
        return $this.getSuggestedPath(path);
    }
}

