/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.MobileModuleUtil;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissedExecutableInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)("#" + MissedExecutableInspection.class.getName()));

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.J2ME_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = J2MEBundle.message("executable.class.misconfiguration.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("MissedExecutable" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection", "getShortName"));
        }
        return "MissedExecutable";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                super.visitClass(aClass);
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)aClass);
                if (module != null && MobileModuleUtil.isExecutable(aClass, module)) {
                    String fqName = aClass.getQualifiedName();
                    J2MEModuleProperties moduleProperties = J2MEModuleProperties.getInstance(module);
                    if (moduleProperties != null) {
                        MobileModuleSettings moduleSettings = MobileModuleSettings.getInstance(module);
                        LOG.assertTrue(moduleSettings != null);
                        if (!moduleSettings.containsMidlet(fqName)) {
                            MobileApplicationType applicationType = moduleProperties.getMobileApplicationType();
                            holder.registerProblem((PsiElement)aClass.getNameIdentifier(), J2MEBundle.message("midlet.undefined.problem.description", applicationType.getPresentableClassName()), new LocalQuickFix[]{new AddExecutable2Configuration(aClass)});
                        }
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static class AddExecutable2Configuration
    implements LocalQuickFix {
        private final String myClassFQN;
        private final Module myModule;

        public AddExecutable2Configuration(PsiClass aClass) {
            this.myClassFQN = aClass.getQualifiedName();
            this.myModule = ModuleUtil.findModuleForPsiElement((PsiElement)aClass);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Append midlet to suite" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection$AddExecutable2Configuration", "getFamilyName"));
            }
            return "Append midlet to suite";
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection$AddExecutable2Configuration", "getElementToMakeWritable"));
            }
            return null;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = J2MEBundle.message("append.to.suite.quickfix.text", StringUtil.getShortName((String)this.myClassFQN), this.myModule.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection$AddExecutable2Configuration", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection$AddExecutable2Configuration", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection$AddExecutable2Configuration", "applyFix"));
            }
            MobileModuleSettings moduleSettings = MobileModuleSettings.getInstance(this.myModule);
            LOG.assertTrue(moduleSettings != null);
            moduleSettings.addMidlet(this.myClassFQN);
        }
    }
}

