/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.i18n;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class ResourceBundlesBean
implements JDOMExternalizable {
    public JDOMExternalizableStringList myResourceBundles = new JDOMExternalizableStringList();
    private final Project myProject;

    public ResourceBundlesBean(Project project) {
        this.myProject = project;
    }

    public List<String> getResourceBundles() {
        return this.myResourceBundles;
    }

    public void registerResourceBundle(PsiClass resourceBundle) {
        this.myResourceBundles.add((Object)resourceBundle.getQualifiedName());
    }

    public PsiClass getResourceBundle() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        Iterator it = this.myResourceBundles.iterator();
        while (it.hasNext()) {
            String bundle = (String)it.next();
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(bundle, GlobalSearchScope.allScope((Project)this.myProject));
            if (psiClass != null) {
                return psiClass;
            }
            it.remove();
        }
        return null;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }
}

