/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class J2MEModuleExtension
extends ModuleExtension {
    @NonNls
    private static final String EXPLODED_TAG = "exploded";
    @NonNls
    private static final String EXCLUDE_EXPLODED_TAG = "exclude-exploded";
    @NonNls
    private static final String ATTRIBUTE_URL = "url";
    @Nullable
    VirtualFilePointer myExplodedDirectoryPointer;
    @Nullable
    private String myExplodedDirectory;
    private boolean myExcludeExploded;
    private J2MEModuleExtension mySource;

    public static J2MEModuleExtension getInstance(Module module) {
        return (J2MEModuleExtension)((Object)ModuleRootManager.getInstance((Module)module).getModuleExtension(J2MEModuleExtension.class));
    }

    public J2MEModuleExtension() {
    }

    public J2MEModuleExtension(J2MEModuleExtension source) {
        this.mySource = source;
        this.myExcludeExploded = source.myExcludeExploded;
        this.myExplodedDirectory = source.myExplodedDirectory;
        VirtualFilePointer pointer = source.myExplodedDirectoryPointer;
        this.myExplodedDirectoryPointer = pointer != null ? VirtualFilePointerManager.getInstance().duplicate(pointer, (Disposable)this, null) : null;
    }

    public ModuleExtension getModifiableModel(boolean writable) {
        return new J2MEModuleExtension(this);
    }

    public void commit() {
        if (this.mySource != null) {
            this.mySource.setExcludeExplodedDirectory(this.myExcludeExploded);
            this.mySource.setExplodedDirectory(this.myExplodedDirectoryPointer != null ? this.myExplodedDirectoryPointer.getUrl() : null);
        }
    }

    public boolean isChanged() {
        return this.myExcludeExploded != this.mySource.myExcludeExploded || !Comparing.equal((String)this.getExplodedDirectoryUrl(), (String)this.mySource.getExplodedDirectoryUrl());
    }

    public void dispose() {
        this.mySource = null;
        this.myExplodedDirectoryPointer = null;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/j2meplugin/module/J2MEModuleExtension", "readExternal"));
        }
        this.myExcludeExploded = element.getChild(EXCLUDE_EXPLODED_TAG) != null;
        Element outputPathChild = element.getChild(EXPLODED_TAG);
        this.myExplodedDirectory = outputPathChild != null ? outputPathChild.getAttributeValue(ATTRIBUTE_URL) : null;
        this.myExplodedDirectoryPointer = this.myExplodedDirectory != null ? VirtualFilePointerManager.getInstance().create(this.myExplodedDirectory, (Disposable)this, null) : null;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/j2meplugin/module/J2MEModuleExtension", "writeExternal"));
        }
        if (this.myExplodedDirectory != null) {
            Element pathElement = new Element(EXPLODED_TAG);
            pathElement.setAttribute(ATTRIBUTE_URL, this.myExplodedDirectory);
            element.addContent(pathElement);
        }
        if (this.myExcludeExploded) {
            element.addContent(new Element(EXCLUDE_EXPLODED_TAG));
        }
    }

    @Nullable
    public VirtualFile getExplodedDirectory() {
        return this.myExplodedDirectoryPointer == null ? null : this.myExplodedDirectoryPointer.getFile();
    }

    @Nullable
    public VirtualFilePointer getExplodedDirectoryPointer() {
        return this.myExplodedDirectoryPointer;
    }

    public void setExplodedDirectory(@Nullable VirtualFile file) {
        this.setExplodedDirectory(file == null ? null : file.getUrl());
    }

    public void setExplodedDirectory(@Nullable String url) {
        this.myExplodedDirectory = url;
        this.myExplodedDirectoryPointer = url == null ? null : VirtualFilePointerManager.getInstance().create(url, (Disposable)this, null);
    }

    public boolean isExcludeExplodedDirectory() {
        return this.myExcludeExploded;
    }

    public void setExcludeExplodedDirectory(boolean excludeExploded) {
        this.myExcludeExploded = excludeExploded;
    }

    @Nullable
    public String getExplodedDirectoryUrl() {
        return this.myExplodedDirectoryPointer == null ? null : this.myExplodedDirectoryPointer.getUrl();
    }
}

