/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.settings.doja;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.module.J2MEModuleBuilder;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.j2meplugin.module.settings.doja.DOJAApplicationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class DOJASettings
extends MobileModuleSettings {
    public DOJASettings() {
    }

    public DOJASettings(Module module) {
        super(module);
    }

    @Override
    public void copyTo(MobileModuleSettings mobileModuleSettings) {
        if (!(mobileModuleSettings instanceof DOJASettings)) {
            return;
        }
        super.copyTo(mobileModuleSettings);
    }

    @Override
    public void initSettings(J2MEModuleBuilder moduleBuilder) {
        super.initSettings(moduleBuilder);
        if (this.myDefaultModified) {
            this.putIfNotExists("AppName", moduleBuilder.getName());
        } else {
            this.putSetting("AppName", moduleBuilder.getName());
        }
    }

    @Override
    public void prepareJarSettings() {
        super.prepareJarSettings();
        String lastModified = new SimpleDateFormat(J2MEBundle.message("doja.time.format", new Object[0])).format(new Date(new File(this.myJarURL).lastModified()));
        LOG.assertTrue(lastModified != null);
        if (this.myJarURL != null) {
            this.putSetting("LastModified", lastModified);
        }
    }

    @Override
    @Nullable
    public File getManifest() {
        return null;
    }

    @Override
    public SortedSet<String> getMIDlets() {
        TreeSet<String> treeSet = new TreeSet<String>();
        String appClass = (String)this.properties.get("AppClass");
        if (appClass != null) {
            treeSet.add("AppClass");
        }
        return treeSet;
    }

    @Override
    public void setMIDletClassName(String name, String className) {
        this.properties.put(name, className);
    }

    @Override
    public String getMIDletClassName(String midletKey) {
        return (String)this.properties.get(midletKey);
    }

    @Override
    public boolean isMidletKey(String key) {
        return Comparing.strEqual((String)key, (String)"AppClass");
    }

    @Override
    public MobileApplicationType getApplicationType() {
        return DOJAApplicationType.getInstance();
    }

    @Override
    public void addMidlet(String qualifiedName) {
        String currentApplication = (String)this.properties.get("AppClass");
        if (currentApplication != null && Messages.showYesNoDialog((String)J2MEBundle.message("doja.configuration.contains.executable.class.dialog.message", currentApplication, qualifiedName), (String)J2MEBundle.message("doja.configuration.contains.executable.class.dialog.title", new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        this.properties.put("AppClass", qualifiedName);
        super.addMidlet(qualifiedName);
    }

    @Override
    public boolean containsMidlet(String qualifiedName) {
        return Comparing.strEqual((String)((String)this.properties.get("AppClass")).trim(), (String)qualifiedName);
    }
}

