/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.settings.ui;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MobileBuildPanel
implements UnnamedConfigurable {
    private final JPanel myBuildSettingsPanel = new JPanel(new GridBagLayout());
    private final JLabel myJarPathLabel = new JLabel(J2MEBundle.message("build.settings.jar.file.label", new Object[0]));
    private final TextFieldWithBrowseButton myJarUrl = new TextFieldWithBrowseButton();
    private final TextFieldWithBrowseButton myDescriptorUrl = new TextFieldWithBrowseButton();
    private final JLabel myDescriptorLabel = new JLabel();
    private final JCheckBox myUseUserManifest = new JCheckBox(J2MEBundle.message("build.settings.manifest.label", new Object[0]));
    private final FieldPanel myUserManifestPath = new FieldPanel();
    private final MobileApplicationType myMobileApplicationType;
    private final Project myProject;
    private final MobileModuleSettings mySettings;
    private boolean myModified = false;

    public MobileBuildPanel(MobileApplicationType mobileApplicationType, Project project, MobileModuleSettings settings) {
        this.myMobileApplicationType = mobileApplicationType;
        this.myProject = project;
        this.mySettings = settings;
    }

    public JComponent createComponent() {
        if (this.myMobileApplicationType != null && this.mySettings != null) {
            this.myDescriptorLabel.setText(J2MEBundle.message("file.label", this.myMobileApplicationType.getExtension().toUpperCase()));
            this.myDescriptorUrl.addBrowseFolderListener(J2MEBundle.message("build.settings.file.url.title", this.myMobileApplicationType.getExtension()), J2MEBundle.message("build.settings.file.url", this.myMobileApplicationType.getExtension()), this.myProject, FileChooserDescriptorFactory.createSingleLocalFileDescriptor());
            this.myDescriptorUrl.setText(this.mySettings.getMobileDescriptionPath());
            DocumentAdapter modifier = new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    MobileBuildPanel.this.myModified = true;
                }
            };
            this.myDescriptorUrl.getTextField().getDocument().addDocumentListener((DocumentListener)modifier);
            this.myJarUrl.addBrowseFolderListener(J2MEBundle.message("build.settings.jar.utl.title", new Object[0]), J2MEBundle.message("build.settings.jar.url", new Object[0]), this.myProject, FileChooserDescriptorFactory.createSingleLocalFileDescriptor());
            this.myJarUrl.setText(this.mySettings.getJarURL());
            this.myJarUrl.getTextField().getDocument().addDocumentListener((DocumentListener)modifier);
            this.myUseUserManifest.setSelected(this.mySettings.isUseUserManifest());
            this.myUserManifestPath.setEnabled(this.mySettings.isUseUserManifest());
            this.myUserManifestPath.setText(this.mySettings.getUserManifestPath() != null ? this.mySettings.getUserManifestPath() : "");
            this.myUseUserManifest.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MobileBuildPanel.this.myUserManifestPath.setEnabled(MobileBuildPanel.this.myUseUserManifest.isSelected());
                    MobileBuildPanel.this.myModified = true;
                }
            });
            this.myUserManifestPath.setBrowseButtonActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                    descriptor.setTitle(J2MEBundle.message("build.settings.manifest.title", new Object[0]));
                    descriptor.setDescription(J2MEBundle.message("build.settings.manifes.choose", new Object[0]));
                    VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)MobileBuildPanel.this.myBuildSettingsPanel, (Project)MobileBuildPanel.this.myProject, null);
                    if (file != null) {
                        MobileBuildPanel.this.myUserManifestPath.setText(FileUtil.toSystemDependentName((String)file.getPath()));
                    }
                }
            });
            this.myUserManifestPath.createComponent();
            this.myUserManifestPath.getTextField().getDocument().addDocumentListener((DocumentListener)modifier);
        }
        this.myBuildSettingsPanel.add((Component)this.myJarPathLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insets((int)5, (int)0), 0, 0));
        this.myBuildSettingsPanel.add((Component)this.myJarUrl, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.insets((int)5, (int)5, (int)5, (int)0), 0, 0));
        this.myBuildSettingsPanel.add((Component)this.myDescriptorLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insets((int)5, (int)0), 0, 0));
        this.myBuildSettingsPanel.add((Component)this.myDescriptorUrl, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.insets((int)5, (int)5, (int)5, (int)0), 0, 0));
        this.myBuildSettingsPanel.add((Component)this.myUseUserManifest, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)5), 0, 0));
        this.myBuildSettingsPanel.add((Component)this.myUserManifestPath, new GridBagConstraints(1, -1, 1, 1, 1.0, 1.0, 10, 2, (Insets)JBUI.insets((int)5, (int)5, (int)5, (int)0), 0, 0));
        this.myBuildSettingsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)J2MEBundle.message("mobile.module.packages.title", new Object[0]), (boolean)true));
        return this.myBuildSettingsPanel;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void apply() throws ConfigurationException {
        if (this.myDescriptorUrl.getText() == null || this.myDescriptorUrl.getText().length() == 0) {
            throw new ConfigurationException(J2MEBundle.message("build.settings.descriptor.not.specified", this.myMobileApplicationType.getExtension().toUpperCase()));
        }
        if (!this.myDescriptorUrl.getText().endsWith(this.myMobileApplicationType.getExtension())) {
            throw new ConfigurationException(J2MEBundle.message("build.settings.mistyped.descriptor", this.myMobileApplicationType.getExtension().toUpperCase()));
        }
        if (this.myJarUrl.getText() == null || this.myJarUrl.getText().length() == 0) {
            throw new ConfigurationException(J2MEBundle.message("build.settings.jar.not.specified", new Object[0]));
        }
        if (this.myUseUserManifest.isSelected() && (this.myUserManifestPath.getText() == null || this.myUserManifestPath.getText().length() == 0)) {
            throw new ConfigurationException(J2MEBundle.message("build.settings.manifest.not.specified", new Object[0]));
        }
        this.mySettings.setMobileDescriptionPath(this.myDescriptorUrl.getText());
        this.mySettings.setJarURL(this.myJarUrl.getText());
        this.mySettings.setUseUserManifest(this.myUseUserManifest.isSelected());
        if (this.myUseUserManifest.isSelected()) {
            this.mySettings.setUserManifestPath(this.myUserManifestPath.getText());
        }
        this.myModified = false;
    }

    public void reset() {
        this.myDescriptorUrl.setText(this.mySettings.getMobileDescriptionPath());
        this.myJarUrl.setText(this.mySettings.getJarURL());
        this.myUseUserManifest.setSelected(this.mySettings.isUseUserManifest());
        this.myUserManifestPath.setText(this.mySettings.getUserManifestPath() != null ? this.mySettings.getUserManifestPath() : "");
        this.myModified = false;
    }

    public void disposeUIResources() {
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJarUrl.getTextField();
    }
}

