/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger;

import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianModel;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.ConfigurationSpecificState;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerMode;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerSettingsState;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerTransport;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteJVMSettingsCoordinator;
import org.jetbrains.annotations.NotNull;

public class RemoteDebuggerModel
extends ArquillianModel<ConfigurationSpecificState, RemoteDebuggerModel>
implements RemoteJVMSettingsCoordinator.Callback {
    @NotNull
    private final RemoteJVMSettingsCoordinator remoteJVMSettingsCoordinator;
    @NotNull
    private ConfigurationSpecificState currentState;
    @NotNull
    private RemoteJVMSettingsCoordinator.RemoteJVMSettings remoteJVMSettings;

    public RemoteDebuggerModel(Project project, @NotNull ConfigurationSpecificState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/plugins/jboss/arquillian/configuration/remoteDebugger/RemoteDebuggerModel", "<init>"));
        }
        this.remoteJVMSettings = RemoteJVMSettingsCoordinator.inProgressStateSettings;
        this.remoteJVMSettingsCoordinator = new RemoteJVMSettingsCoordinator(project, this);
        this.currentState = state.clone();
        this.remoteJVMSettingsCoordinator.retrieveSettingsForState(this.currentState.settings.clone());
        this.addChangeListener(new ArquillianModel.Listener<ConfigurationSpecificState, RemoteDebuggerModel>(){

            @Override
            public void itemChanged(RemoteDebuggerModel model) {
                RemoteDebuggerModel.this.remoteJVMSettingsCoordinator.retrieveSettingsForState(((RemoteDebuggerModel)RemoteDebuggerModel.this).currentState.settings.clone());
            }
        });
    }

    @NotNull
    public RemoteJVMSettingsCoordinator.RemoteJVMSettings getRemoteJVMSettings() {
        RemoteJVMSettingsCoordinator.RemoteJVMSettings remoteJVMSettings = this.remoteJVMSettings;
        if (remoteJVMSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/remoteDebugger/RemoteDebuggerModel", "getRemoteJVMSettings"));
        }
        return remoteJVMSettings;
    }

    @Override
    public boolean hasChanges(ConfigurationSpecificState state) {
        return !this.currentState.equals(state);
    }

    @Override
    @NotNull
    public ConfigurationSpecificState getCurrentState() {
        ConfigurationSpecificState configurationSpecificState = this.currentState.clone();
        if (configurationSpecificState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/remoteDebugger/RemoteDebuggerModel", "getCurrentState"));
        }
        return configurationSpecificState;
    }

    public boolean isEnabled() {
        return this.currentState.remoteDebuggingEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.currentState.remoteDebuggingEnabled != enabled) {
            this.currentState.remoteDebuggingEnabled = enabled;
            this.notifyMeChanged();
        }
    }

    public String getHost() {
        return this.currentState.settings.host;
    }

    public void setHost(String host) {
        if (!this.currentState.settings.host.equals(host)) {
            this.currentState.settings.host = host;
            this.notifyMeChanged();
        }
    }

    public RemoteDebuggerMode getMode() {
        return this.currentState.settings.mode;
    }

    public void setMode(RemoteDebuggerMode mode) {
        if (this.currentState.settings.mode != mode) {
            this.currentState.settings.mode = mode;
            this.notifyMeChanged();
        }
    }

    public String getPort() {
        return this.currentState.settings.port;
    }

    public void setPort(String port) {
        if (!this.currentState.settings.port.equals(port)) {
            this.currentState.settings.port = port;
            this.notifyMeChanged();
        }
    }

    public String getSharedMemoryAddress() {
        return this.currentState.settings.sharedMemoryAddress;
    }

    public void setSharedMemoryAddress(String sharedMemoryAddress) {
        if (!this.currentState.settings.sharedMemoryAddress.equals(sharedMemoryAddress)) {
            this.currentState.settings.sharedMemoryAddress = sharedMemoryAddress;
            this.notifyMeChanged();
        }
    }

    public RemoteDebuggerTransport getTransport() {
        return this.currentState.settings.transport;
    }

    public void setTransport(RemoteDebuggerTransport transport) {
        if (this.currentState.settings.transport != transport) {
            this.currentState.settings.transport = transport;
            this.notifyMeChanged();
        }
    }

    public String getRunContainerQualifier() {
        return this.currentState.runContainerQualifier;
    }

    public void setRunContainerQualifier(String containerQualifier) {
        if (!this.currentState.runContainerQualifier.equals(containerQualifier)) {
            this.currentState.runContainerQualifier = containerQualifier;
            this.notifyMeChanged();
        }
    }

    public String getDebugContainerQualifier() {
        return this.currentState.debugContainerQualifier;
    }

    public void setDebugContainerQualifier(String containerQualifier) {
        if (!this.currentState.debugContainerQualifier.equals(containerQualifier)) {
            this.currentState.debugContainerQualifier = containerQualifier;
            this.notifyMeChanged();
        }
    }

    @Override
    public void settingsForState(RemoteDebuggerSettingsState state, RemoteJVMSettingsCoordinator.RemoteJVMSettings settings) {
        if (!this.currentState.settings.equals(state)) {
            return;
        }
        if (this.remoteJVMSettings.equals(settings)) {
            return;
        }
        this.remoteJVMSettings = settings;
        this.notifyMeChanged();
    }
}

