/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.inspection;

import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.utils.ArquillianUtils;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArquillianClassEnabledInspection
extends BaseJavaLocalInspectionTool {
    private static ProblemDescriptor createTestngProblemDescriptor(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianClassEnabledInspection", "createTestngProblemDescriptor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianClassEnabledInspection", "createTestngProblemDescriptor"));
        }
        return manager.createProblemDescriptor((PsiElement)(aClass.getNameIdentifier() == null ? aClass : aClass.getNameIdentifier()), ArquillianBundle.message("arquillian.testng.should.extend.arquillian", new Object[0]), isOnTheFly, new LocalQuickFix[]{ArquillianClassEnabledInspection.createTestngQuickFix(aClass), ArquillianClassEnabledInspection.createMakeClassAbstractQuickFix(aClass)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private static LocalQuickFix createTestngQuickFix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianClassEnabledInspection", "createTestngQuickFix"));
        }
        return QuickFixFactory.getInstance().createExtendsListFix(aClass, ArquillianUtils.getTestngArquillianType(aClass.getProject()), true);
    }

    private static ProblemDescriptor createJUnitProblemDescriptor(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianClassEnabledInspection", "createJUnitProblemDescriptor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianClassEnabledInspection", "createJUnitProblemDescriptor"));
        }
        return manager.createProblemDescriptor((PsiElement)(aClass.getNameIdentifier() == null ? aClass : aClass.getNameIdentifier()), ArquillianBundle.message("arquillian.junit.run.with.required", new Object[0]), isOnTheFly, new LocalQuickFix[]{ArquillianClassEnabledInspection.createJUnitQuickFix(aClass), ArquillianClassEnabledInspection.createMakeClassAbstractQuickFix(aClass)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private static LocalQuickFix createMakeClassAbstractQuickFix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianClassEnabledInspection", "createMakeClassAbstractQuickFix"));
        }
        if (aClass.getModifierList() == null) {
            return null;
        }
        return QuickFixFactory.getInstance().createModifierListFix(aClass.getModifierList(), "abstract", true, true);
    }

    private static LocalQuickFix createJUnitQuickFix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianClassEnabledInspection", "createJUnitQuickFix"));
        }
        PsiAnnotation annotation = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createAnnotationFromText("@org.junit.runner.RunWith(org.jboss.arquillian.junit.Arquillian.class)", (PsiElement)aClass);
        return new AddAnnotationFix("org.junit.runner.RunWith", (PsiModifierListOwner)aClass, annotation.getParameterList().getAttributes(), new String[0]);
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianClassEnabledInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianClassEnabledInspection", "checkClass"));
        }
        if (ArquillianUtils.getAnnotatedMethods(aClass, "org.jboss.arquillian.container.test.api.Deployment").isEmpty()) {
            return null;
        }
        if (aClass.getModifierList() != null && aClass.getModifierList().hasExplicitModifier("abstract")) {
            return null;
        }
        ArrayList<ProblemDescriptor> problemDescriptors = new ArrayList<ProblemDescriptor>();
        if (!ArquillianUtils.getAnnotatedMethods(aClass, "org.junit.Test").isEmpty() && !ArquillianUtils.isJunitArquillianEnabled(aClass)) {
            problemDescriptors.add(ArquillianClassEnabledInspection.createJUnitProblemDescriptor(aClass, manager, isOnTheFly));
        }
        if (!ArquillianUtils.getAnnotatedMethods(aClass, "org.testng.annotations.Test").isEmpty() && !ArquillianUtils.isTestngArquillianEnabled(aClass)) {
            problemDescriptors.add(ArquillianClassEnabledInspection.createTestngProblemDescriptor(aClass, manager, isOnTheFly));
        }
        return problemDescriptors.isEmpty() ? null : problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]);
    }
}

