/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.libraries;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainersManager;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianExistLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianMavenLibraryState;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.remote.MavenDependenciesRemoteManager;

public class ArquillianLibrarySynchronizer
implements StartupActivity,
DumbAware {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/jboss/arquillian/libraries/ArquillianLibrarySynchronizer", "runActivity"));
        }
        StartupManager.getInstance((Project)project).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                    public void run() {
                        final HashMap libsToDownload = new HashMap();
                        for (ArquillianContainerState container : ArquillianContainersManager.getInstance((Project)project).getState().containers) {
                            for (ArquillianLibraryState library : container.libraries) {
                                library.accept(new ArquillianLibraryState.Visitor<Void>(){

                                    @Override
                                    public Void visitMavenLibrary(ArquillianMavenLibraryState mavenLibrary) {
                                        String mavenId = mavenLibrary.groupId + ":" + mavenLibrary.artifactId + ":" + mavenLibrary.version;
                                        ArquillianMavenLibraryState mapLibrary = (ArquillianMavenLibraryState)libsToDownload.get(mavenId);
                                        if (mapLibrary == null) {
                                            mapLibrary = new ArquillianMavenLibraryState(mavenLibrary.groupId, mavenLibrary.artifactId, mavenLibrary.version);
                                            libsToDownload.put(mavenId, mapLibrary);
                                        }
                                        mapLibrary.downloadSources = mapLibrary.downloadSources || mavenLibrary.downloadSources;
                                        mapLibrary.downloadJavaDocs = mapLibrary.downloadJavaDocs || mavenLibrary.downloadJavaDocs;
                                        return null;
                                    }

                                    @Override
                                    public Void visitExistLibrary(ArquillianExistLibraryState state) {
                                        return null;
                                    }
                                });
                            }
                        }
                        for (ArquillianMavenLibraryState mavenLibraryState : libsToDownload.values()) {
                            MavenDependenciesRemoteManager.getInstance((Project)project).downloadDependenciesAsync(new RepositoryLibraryProperties(mavenLibraryState.groupId, mavenLibraryState.artifactId, mavenLibraryState.version), mavenLibraryState.downloadSources, mavenLibraryState.downloadJavaDocs, null, null);
                        }
                    }
                }, project.getDisposed());
            }
        });
    }
}

