/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.runConfiguration;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.configuration.ArquillianContainersAppManager;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainersManager;
import com.intellij.plugins.jboss.arquillian.configuration.ui.ArquillianSettingsConfigurable;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfiguration;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class ArquillianConfigurationPanel
extends SettingsEditor<ArquillianRunConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)("#" + ArquillianConfigurationPanel.class.getName()));
    private final Project project;
    private ButtonGroup buttonGroup;
    private List<JBRadioButton> buttons;
    private JBRadioButton selectedButton;
    private String selectedName;
    private JPanel mainPanel;
    private JPanel frameworksPanel;
    private JButton configureButton;

    public ArquillianConfigurationPanel(final Project project) {
        this.project = project;
        this.$$$setupUI$$$();
        this.configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArquillianSettingsConfigurable configurable = new ArquillianSettingsConfigurable(ArquillianContainersAppManager.getInstance(), ArquillianContainersManager.getInstance(project), project);
                if (ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable)) {
                    ArquillianConfigurationPanel.this.refreshContainerList();
                    ArquillianConfigurationPanel.this.setSelection(ArquillianConfigurationPanel.this.selectedName);
                }
            }
        });
    }

    private void setSelection(String name) {
        for (JBRadioButton button2 : this.buttons) {
            button2.setSelected(false);
        }
        this.selectedName = name;
        this.selectedButton = (JBRadioButton)JBIterable.from(this.buttons).filter(button -> button.getText().equals(this.selectedName)).first();
        if (this.selectedButton != null) {
            this.selectedButton.setSelected(true);
        }
    }

    protected void resetEditorFrom(@NotNull ArquillianRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianConfigurationPanel", "resetEditorFrom"));
        }
        this.setSelection(runConfiguration.getContainerStateName());
    }

    protected void applyEditorTo(@NotNull ArquillianRunConfiguration runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianConfigurationPanel", "applyEditorTo"));
        }
        runConfiguration.setContainerStateName(this.selectedName);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianConfigurationPanel", "createEditor"));
        }
        return jPanel;
    }

    private void refreshContainerList() {
        this.frameworksPanel.removeAll();
        this.buttonGroup = new ButtonGroup();
        ArrayList<ArquillianContainerState> states = new ArrayList<ArquillianContainerState>(ArquillianContainersManager.getInstance((Project)this.project).getState().containers);
        Collections.sort(states);
        this.buttons = Lists.newArrayList((Iterable)Iterables.transform(states, (Function)new Function<ArquillianContainerState, JBRadioButton>(){

            public JBRadioButton apply(ArquillianContainerState containerState) {
                final JBRadioButton button = new JBRadioButton(containerState.getName());
                button.setHorizontalAlignment(2);
                ArquillianConfigurationPanel.this.frameworksPanel.add((Component)button);
                ArquillianConfigurationPanel.this.buttonGroup.add((AbstractButton)button);
                button.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (button.isSelected()) {
                            ArquillianConfigurationPanel.this.selectedButton = button;
                            ArquillianConfigurationPanel.this.selectedName = button.getText();
                        }
                    }
                });
                return button;
            }
        }));
    }

    private void createUIComponents() {
        this.frameworksPanel = new JPanel();
        this.frameworksPanel.setLayout(new BoxLayout(this.frameworksPanel, 1));
        this.refreshContainerList();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        this.createUIComponents();
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = this.frameworksPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.configureButton = jButton = new JButton();
        jButton.setText("Configure");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

