/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathEnvironmentVariableUtil {
    private static final String PATH = "PATH";

    private PathEnvironmentVariableUtil() {
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInPath"));
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, null);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInPath"));
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, EnvironmentUtil.getValue((String)PATH), filter);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, @Nullable String pathVariableValue, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInPath"));
        }
        List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(fileBaseName, true, filter, pathVariableValue);
        return (File)ContainerUtil.getFirstItem(exeFiles);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, boolean logDetails) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInPath"));
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, null);
    }

    private static File findInOriginalPath(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInOriginalPath"));
        }
        List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(fileBaseName, true, null, System.getenv(PATH));
        return (File)ContainerUtil.getFirstItem(exeFiles);
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAllExeFilesInPath"));
        }
        List<File> list = PathEnvironmentVariableUtil.findAllExeFilesInPath(fileBaseName, null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAllExeFilesInPath"));
        }
        return list;
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAllExeFilesInPath"));
        }
        List<File> list = PathEnvironmentVariableUtil.findExeFilesInPath(fileBaseName, false, filter, EnvironmentUtil.getValue((String)PATH));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAllExeFilesInPath"));
        }
        return list;
    }

    @NotNull
    private static List<File> findExeFilesInPath(@NotNull String fileBaseName, boolean stopAfterFirstMatch, @Nullable FileFilter filter, @Nullable String pathEnvVarValue) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findExeFilesInPath"));
        }
        if (pathEnvVarValue == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findExeFilesInPath"));
            }
            return list;
        }
        SmartList result = new SmartList();
        List dirPaths = StringUtil.split((String)pathEnvVarValue, (String)File.pathSeparator, (boolean)true, (boolean)true);
        for (String dirPath : dirPaths) {
            File exeFile;
            File dir = new File(dirPath);
            if (!dir.isAbsolute() || !dir.isDirectory() || !(exeFile = new File(dir, fileBaseName)).isFile() || !exeFile.canExecute() || filter != null && !filter.accept(exeFile)) continue;
            result.add(exeFile);
            if (!stopAfterFirstMatch) continue;
            SmartList smartList = result;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findExeFilesInPath"));
            }
            return smartList;
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findExeFilesInPath"));
        }
        return smartList;
    }

    @NotNull
    public static String toLocatableExePath(@NotNull String exePath) {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "toLocatableExePath"));
        }
        String string = PathEnvironmentVariableUtil.findAbsolutePathOnMac(exePath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "toLocatableExePath"));
        }
        return string;
    }

    public static String findAbsolutePathOnMac(@NotNull String exePath) {
        File resolvedExeFile;
        File originalResolvedExeFile;
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAbsolutePathOnMac"));
        }
        if (SystemInfo.isMac && !StringUtil.containsChar((String)exePath, (char)'/') && !StringUtil.containsChar((String)exePath, (char)'\\') && (originalResolvedExeFile = PathEnvironmentVariableUtil.findInOriginalPath(exePath)) == null && (resolvedExeFile = PathEnvironmentVariableUtil.findInPath(exePath)) != null) {
            exePath = resolvedExeFile.getAbsolutePath();
        }
        return exePath;
    }
}

