/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.DocumentsSynchronizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentContent
extends DiffContent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.FragmentContent");
    private final DiffContent myOriginal;
    private final FileType myType;
    private final MyDocumentsSynchronizer mySynchonizer;
    public static final Key<Document> ORIGINAL_DOCUMENT = UndoManager.ORIGINAL_DOCUMENT;
    private final boolean myForceReadOnly;

    public FragmentContent(@NotNull DiffContent original, @NotNull TextRange range, Project project, VirtualFile file) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/diff/FragmentContent", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/diff/FragmentContent", "<init>"));
        }
        this(original, range, project, file, false);
    }

    public FragmentContent(@NotNull DiffContent original, @NotNull TextRange range, Project project, VirtualFile file, boolean forceReadOnly) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/diff/FragmentContent", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/diff/FragmentContent", "<init>"));
        }
        this(original, range, project, file != null ? DiffContentUtil.getContentType(file) : null, forceReadOnly);
    }

    public FragmentContent(@NotNull DiffContent original, @NotNull TextRange range, Project project, FileType fileType) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/diff/FragmentContent", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/diff/FragmentContent", "<init>"));
        }
        this(original, range, project, fileType, false);
    }

    public FragmentContent(@NotNull DiffContent original, @NotNull TextRange range, Project project, FileType fileType, boolean forceReadOnly) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/diff/FragmentContent", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/diff/FragmentContent", "<init>"));
        }
        RangeMarker rangeMarker = original.getDocument().createRangeMarker(range.getStartOffset(), range.getEndOffset(), true);
        rangeMarker.setGreedyToLeft(true);
        rangeMarker.setGreedyToRight(true);
        this.mySynchonizer = new MyDocumentsSynchronizer(project, rangeMarker);
        this.myOriginal = original;
        this.myType = fileType;
        this.myForceReadOnly = forceReadOnly;
    }

    public FragmentContent(DiffContent original, TextRange range, Project project) {
        this(original, range, project, (FileType)null);
    }

    private static String subText(Document document, int startOffset, int length) {
        return document.getCharsSequence().subSequence(startOffset, startOffset + length).toString();
    }

    @Override
    public void onAssigned(boolean isAssigned) {
        this.myOriginal.onAssigned(isAssigned);
        this.mySynchonizer.listenDocuments(isAssigned);
        super.onAssigned(isAssigned);
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.mySynchonizer.getCopy();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/FragmentContent", "getDocument"));
        }
        return document;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        return this.myOriginal.getOpenFileDescriptor(offset + this.mySynchonizer.getStartOffset());
    }

    @Override
    public VirtualFile getFile() {
        return null;
    }

    @Override
    @Nullable
    public FileType getContentType() {
        return this.myType != null ? this.myType : this.myOriginal.getContentType();
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.getDocument().getText().getBytes();
    }

    public static FragmentContent fromRangeMarker(RangeMarker rangeMarker, Project project) {
        Document document = rangeMarker.getDocument();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        FileType type = file.getFileType();
        return new FragmentContent((DiffContent)new DocumentContent(project, document), TextRange.create((Segment)rangeMarker), project, type);
    }

    private class MyDocumentsSynchronizer
    extends DocumentsSynchronizer {
        private final RangeMarker myRangeMarker;

        public MyDocumentsSynchronizer(@NotNull Project project, RangeMarker originalRange) {
            if (originalRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalRange", "com/intellij/openapi/diff/FragmentContent$MyDocumentsSynchronizer", "<init>"));
            }
            super(project);
            this.myRangeMarker = originalRange;
        }

        public int getStartOffset() {
            return this.myRangeMarker.getStartOffset();
        }

        @Override
        protected void onOriginalChanged(@NotNull DocumentEvent event, @NotNull Document copy) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/diff/FragmentContent$MyDocumentsSynchronizer", "onOriginalChanged"));
            }
            if (copy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/openapi/diff/FragmentContent$MyDocumentsSynchronizer", "onOriginalChanged"));
            }
            if (!this.myRangeMarker.isValid()) {
                FragmentContent.this.fireContentInvalid();
                return;
            }
            this.replaceString(copy, 0, copy.getTextLength(), FragmentContent.subText(event.getDocument(), this.myRangeMarker.getStartOffset(), this.getLength()));
        }

        @Override
        protected void beforeListenersAttached(@NotNull Document original, @NotNull Document copy) {
            boolean readOnly;
            if (original == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/diff/FragmentContent$MyDocumentsSynchronizer", "beforeListenersAttached"));
            }
            if (copy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/openapi/diff/FragmentContent$MyDocumentsSynchronizer", "beforeListenersAttached"));
            }
            boolean bl = readOnly = !copy.isWritable();
            if (readOnly) {
                copy.setReadOnly(false);
            }
            this.replaceString(copy, 0, copy.getTextLength(), FragmentContent.subText(original, this.myRangeMarker.getStartOffset(), this.getLength()));
            copy.setReadOnly(readOnly);
        }

        private int getLength() {
            return this.myRangeMarker.getEndOffset() - this.myRangeMarker.getStartOffset();
        }

        @Override
        protected Document createOriginal() {
            return this.myRangeMarker.getDocument();
        }

        @Override
        @NotNull
        protected Document createCopy() {
            Document originalDocument = this.myRangeMarker.getDocument();
            String textInRange = originalDocument.getCharsSequence().subSequence(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset()).toString();
            Document result = EditorFactory.getInstance().createDocument(textInRange);
            result.setReadOnly(FragmentContent.this.myForceReadOnly || !originalDocument.isWritable());
            result.putUserData(ORIGINAL_DOCUMENT, originalDocument);
            Document document = result;
            if (document == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/FragmentContent$MyDocumentsSynchronizer", "createCopy"));
            }
            return document;
        }

        @Override
        protected void onCopyChanged(@NotNull DocumentEvent event, @NotNull Document original) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/diff/FragmentContent$MyDocumentsSynchronizer", "onCopyChanged"));
            }
            if (original == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/diff/FragmentContent$MyDocumentsSynchronizer", "onCopyChanged"));
            }
            int originalOffset = event.getOffset() + this.myRangeMarker.getStartOffset();
            LOG.assertTrue(originalOffset >= 0);
            if (!original.isWritable()) {
                return;
            }
            String newText = FragmentContent.subText(event.getDocument(), event.getOffset(), event.getNewLength());
            int originalEnd = originalOffset + event.getOldLength();
            this.replaceString(original, originalOffset, originalEnd, newText);
        }
    }
}

