/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableConstantFunction;
import com.intellij.util.NullableFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathReference {
    public static final NullableFunction<PathReference, Icon> NULL_ICON = new NullableConstantFunction((Object)null);
    private final String myPath;
    private final NullableLazyValue<Icon> myIcon;

    public PathReference(@NotNull String path2, final @NotNull Function<PathReference, Icon> icon) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/paths/PathReference", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/openapi/paths/PathReference", "<init>"));
        }
        this.myPath = path2;
        this.myIcon = new NullableLazyValue<Icon>(){

            protected Icon compute() {
                return (Icon)icon.fun((Object)PathReference.this);
            }
        };
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/paths/PathReference", "getPath"));
        }
        return string;
    }

    @NotNull
    public String getTrimmedPath() {
        String string = PathReference.trimPath(this.myPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/paths/PathReference", "getTrimmedPath"));
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return (Icon)this.myIcon.getValue();
    }

    @Nullable
    public PsiElement resolve() {
        return null;
    }

    public static String trimPath(String url) {
        for (int i2 = 0; i2 < url.length(); ++i2) {
            switch (url.charAt(i2)) {
                case '#': 
                case '?': {
                    return url.substring(0, i2);
                }
            }
        }
        return url;
    }

    public static class ResolveFunction
    implements NullableFunction<PathReference, Icon> {
        public static final ResolveFunction NULL_RESOLVE_FUNCTION = new ResolveFunction(null);
        private final Icon myDefaultIcon;

        public ResolveFunction(@Nullable Icon defaultValue) {
            this.myDefaultIcon = defaultValue;
        }

        public Icon fun(PathReference pathReference) {
            PsiElement element = pathReference.resolve();
            return element == null ? this.myDefaultIcon : element.getIcon(2);
        }
    }
}

