/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.DistinctRootsCollection;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.text.StringFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsUtilCore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.VfsUtilCore");
    private static final String MAILTO = "mailto";
    public static final String LOCALHOST_URI_PATH_PREFIX = "localhost/";
    public static final char VFS_SEPARATOR_CHAR = '/';
    private static final String PROTOCOL_DELIMITER = ":";

    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file, boolean strict) {
        VirtualFile parent;
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/openapi/vfs/VfsUtilCore", "isAncestor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "isAncestor"));
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile2 = parent = strict ? file.getParent() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isUnder(@NotNull VirtualFile file, @Nullable Set<VirtualFile> roots) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "isUnder"));
        }
        if (roots == null || roots.isEmpty()) {
            return false;
        }
        for (VirtualFile parent = file; parent != null; parent = parent.getParent()) {
            if (!roots.contains(parent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnder(@NotNull String url, @Nullable Collection<String> rootUrls) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/VfsUtilCore", "isUnder"));
        }
        if (rootUrls == null || rootUrls.isEmpty()) {
            return false;
        }
        for (String excludesUrl : rootUrls) {
            if (!VfsUtilCore.isEqualOrAncestor(excludesUrl, url)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqualOrAncestor(@NotNull String ancestorUrl, @NotNull String fileUrl) {
        if (ancestorUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestorUrl", "com/intellij/openapi/vfs/VfsUtilCore", "isEqualOrAncestor"));
        }
        if (fileUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileUrl", "com/intellij/openapi/vfs/VfsUtilCore", "isEqualOrAncestor"));
        }
        if (ancestorUrl.equals(fileUrl)) {
            return true;
        }
        if (StringUtil.endsWithChar((CharSequence)ancestorUrl, (char)'/')) {
            return fileUrl.startsWith(ancestorUrl);
        }
        return StringUtil.startsWithConcatenation((String)fileUrl, (String[])new String[]{ancestorUrl, "/"});
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/openapi/vfs/VfsUtilCore", "isAncestor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "isAncestor"));
        }
        return FileUtil.isAncestor((File)ancestor, (File)file, (boolean)strict);
    }

    @Nullable
    public static String getRelativeLocation(@Nullable VirtualFile file, @NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/vfs/VfsUtilCore", "getRelativeLocation"));
        }
        if (file == null) {
            return null;
        }
        String path2 = VfsUtilCore.getRelativePath(file, root);
        return path2 != null ? path2 : file.getPresentableUrl();
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "getRelativePath"));
        }
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/openapi/vfs/VfsUtilCore", "getRelativePath"));
        }
        return VfsUtilCore.getRelativePath(file, ancestor, '/');
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor, char separator) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "getRelativePath"));
        }
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/openapi/vfs/VfsUtilCore", "getRelativePath"));
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return null;
        }
        int length = 0;
        VirtualFile parent = file;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (parent.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent.getNameSequence().length();
            parent = parent.getParent();
        }
        char[] chars = new char[length];
        int index = chars.length;
        parent = file;
        while (!parent.equals(ancestor)) {
            if (index < length) {
                chars[--index] = separator;
            }
            CharSequence name = parent.getNameSequence();
            for (int i2 = name.length() - 1; i2 >= 0; --i2) {
                chars[--index] = name.charAt(i2);
            }
            parent = parent.getParent();
        }
        return StringFactory.createShared((char[])chars);
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path2 = entryVFile.getPath();
        int separatorIndex = path2.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path2.substring(0, separatorIndex);
        return VirtualFileManager.getInstance().findFileByUrl("file://" + localPath);
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        VirtualFile virtualFile2 = VfsUtilCore.copyFile(requestor, file, toDir, file.getName());
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        return virtualFile2;
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull String newName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        VirtualFile newChild = toDir.createChildData(requestor, newName);
        newChild.setBinaryContent(file.contentsToByteArray());
        VirtualFile virtualFile2 = newChild;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        return virtualFile2;
    }

    @NotNull
    public static InputStream byteStreamSkippingBOM(@NotNull byte[] buf, @NotNull VirtualFile file) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/openapi/vfs/VfsUtilCore", "byteStreamSkippingBOM"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "byteStreamSkippingBOM"));
        }
        BufferExposingByteArrayInputStream stream = new BufferExposingByteArrayInputStream(buf);
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM((InputStream)stream, file);
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "byteStreamSkippingBOM"));
        }
        return inputStream;
    }

    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream, @NotNull VirtualFile file) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/vfs/VfsUtilCore", "inputStreamSkippingBOM"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "inputStreamSkippingBOM"));
        }
        InputStream inputStream = CharsetToolkit.inputStreamSkippingBOM((InputStream)stream);
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "inputStreamSkippingBOM"));
        }
        return inputStream;
    }

    @NotNull
    public static OutputStream outputStreamAddingBOM(@NotNull OutputStream stream, @NotNull VirtualFile file) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/vfs/VfsUtilCore", "outputStreamAddingBOM"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "outputStreamAddingBOM"));
        }
        byte[] bom = file.getBOM();
        if (bom != null) {
            stream.write(bom);
        }
        OutputStream outputStream = stream;
        if (outputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "outputStreamAddingBOM"));
        }
        return outputStream;
    }

    public static boolean iterateChildrenRecursively(final @NotNull VirtualFile root, final @Nullable VirtualFileFilter filter, final @NotNull ContentIterator iterator) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/vfs/VfsUtilCore", "iterateChildrenRecursively"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/openapi/vfs/VfsUtilCore", "iterateChildrenRecursively"));
        }
        VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore$1", "visitFileEx"));
                }
                if (filter != null && !filter.accept(file)) {
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore$1", "visitFileEx"));
                    }
                    return result;
                }
                if (!iterator.processFile(file)) {
                    VirtualFileVisitor.Result result = 1.skipTo(root);
                    if (result == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore$1", "visitFileEx"));
                    }
                    return result;
                }
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore$1", "visitFileEx"));
                }
                return result;
            }
        });
        return !Comparing.equal((Object)result.skipToParent, (Object)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor<?> visitor) throws VirtualFileVisitor.VisitorException {
        block27: {
            block26: {
                block25: {
                    block24: {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"file", "com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                        }
                        if (visitor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"visitor", "com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                        }
                        pushed = false;
                        visited = visitor.allowVisitFile(file);
                        if (visited) {
                            result = visitor.visitFileEx(file);
                            if (result.skipChildren) {
                                var5_5 = result;
                                v0 = var5_5;
                                if (v0 == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                                }
                                return v0;
                            }
                        }
                        childrenIterable = null;
                        children = null;
                        try {
                            if (file.isValid() && visitor.allowVisitChildren(file) && !visitor.depthLimitReached() && (childrenIterable = visitor.getChildrenIterable(file)) == null) {
                                children = file.getChildren();
                            }
                        }
                        catch (InvalidVirtualFileAccessException e) {
                            VfsUtilCore.LOG.info("Ignoring: " + e.getMessage());
                            var7_9 = VirtualFileVisitor.CONTINUE;
                            visitor.restoreValue(pushed);
                            v1 = var7_9;
                            if (v1 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                            }
                            return v1;
                        }
                        if (childrenIterable == null) break block24;
                        visitor.saveValue();
                        pushed = true;
                        var6_8 = childrenIterable.iterator();
                        break block25;
                    }
                    if (children == null || children.length == 0) break block26;
                    break block27;
                }
                while (var6_8.hasNext()) {
                    child = (VirtualFile)var6_8.next();
                    result = VfsUtilCore.visitChildrenRecursively(child, visitor);
                    if (result.skipToParent == null || Comparing.equal((Object)result.skipToParent, (Object)child)) continue;
                    var9_14 = result;
                    v2 = var9_14;
                    if (v2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                    }
                    return v2;
                }
            }
            while (true) {
                if (visited) {
                    visitor.afterChildrenVisited(file);
                }
                var6_8 = VirtualFileVisitor.CONTINUE;
                v3 = var6_8;
                if (v3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                }
                return v3;
            }
            finally {
                visitor.restoreValue(pushed);
            }
        }
        visitor.saveValue();
        pushed = true;
        var6_8 = children;
        var7_11 = ((Object)var6_8).length;
        var8_13 = 0;
        while (true) {
            if (var8_13 >= var7_11) ** continue;
            child = var6_8[var8_13];
            result = VfsUtilCore.visitChildrenRecursively((VirtualFile)child, visitor);
            if (result.skipToParent != null && !Comparing.equal((Object)result.skipToParent, (Object)child)) {
                var11_17 = result;
                v4 = var11_17;
                if (v4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                }
                return v4;
            }
            ++var8_13;
        }
    }

    public static <E extends Exception> VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor visitor, @NotNull Class<E> eClass) throws E {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"));
        }
        if (eClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eClass", "com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"));
        }
        try {
            return VfsUtilCore.visitChildrenRecursively(file, visitor);
        }
        catch (VirtualFileVisitor.VisitorException e) {
            Throwable cause = e.getCause();
            if (eClass.isInstance(cause)) {
                throw (Exception)eClass.cast(cause);
            }
            throw e;
        }
    }

    public static boolean isBrokenLink(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "isBrokenLink"));
        }
        return file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null;
    }

    public static boolean isInvalidLink(@NotNull VirtualFile link) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/openapi/vfs/VfsUtilCore", "isInvalidLink"));
        }
        VirtualFile target = link.getCanonicalFile();
        return target == null || target.equals(link) || VfsUtilCore.isAncestor(target, link, true);
    }

    @NotNull
    public static String loadText(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "loadText"));
        }
        String string = VfsUtilCore.loadText(file, (int)file.getLength());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "loadText"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String loadText(@NotNull VirtualFile file, int length) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "loadText"));
        }
        InputStreamReader reader = new InputStreamReader(file.getInputStream(), file.getCharset());
        String string = StringFactory.createShared((char[])FileUtil.loadText((Reader)reader, (int)length));
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "loadText"));
        }
        return string2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static byte[] loadBytes(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "loadBytes"));
        }
        byte[] byArray = FileUtilRt.isTooLarge((long)file.getLength()) ? FileUtil.loadFirstAndClose((InputStream)file.getInputStream(), (int)FileUtilRt.LARGE_FILE_PREVIEW_SIZE) : file.contentsToByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "loadBytes"));
        }
        return byArray;
    }

    @NotNull
    public static VirtualFile[] toVirtualFileArray(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/VfsUtilCore", "toVirtualFileArray"));
        }
        int size = files.size();
        if (size == 0) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "toVirtualFileArray"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] virtualFileArray = files.toArray(new VirtualFile[size]);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "toVirtualFileArray"));
        }
        return virtualFileArray;
    }

    @NotNull
    public static String urlToPath(@Nullable String url) {
        if (url == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "urlToPath"));
            }
            return "";
        }
        String string = VirtualFileManager.extractPath(url);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "urlToPath"));
        }
        return string;
    }

    @NotNull
    public static File virtualToIoFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "virtualToIoFile"));
        }
        File file2 = new File(PathUtil.toPresentableUrl(file.getUrl()));
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "virtualToIoFile"));
        }
        return file2;
    }

    @NotNull
    public static String pathToUrl(@NotNull String path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/VfsUtilCore", "pathToUrl"));
        }
        String string = VirtualFileManager.constructUrl("file", path2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "pathToUrl"));
        }
        return string;
    }

    public static List<File> virtualToIoFiles(@NotNull Collection<VirtualFile> scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/vfs/VfsUtilCore", "virtualToIoFiles"));
        }
        return ContainerUtil.map2List(scope, file -> VfsUtilCore.virtualToIoFile(file));
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/VfsUtilCore", "toIdeaUrl"));
        }
        String string = VfsUtilCore.toIdeaUrl(url, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "toIdeaUrl"));
        }
        return string;
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url, boolean removeLocalhostPrefix) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/VfsUtilCore", "toIdeaUrl"));
        }
        int index = url.indexOf(":/");
        if (index < 0 || index + 2 >= url.length()) {
            String string = url;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "toIdeaUrl"));
            }
            return string;
        }
        if (url.charAt(index + 2) != '/') {
            String prefix = url.substring(0, index);
            String suffix = url.substring(index + 2);
            if (SystemInfoRt.isWindows) {
                String string = prefix + "://" + suffix;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "toIdeaUrl"));
                }
                return string;
            }
            if (removeLocalhostPrefix && prefix.equals("file") && suffix.startsWith(LOCALHOST_URI_PATH_PREFIX)) {
                String string = prefix + ":///" + suffix.substring(LOCALHOST_URI_PATH_PREFIX.length());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "toIdeaUrl"));
                }
                return string;
            }
            String string = prefix + ":///" + suffix;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "toIdeaUrl"));
            }
            return string;
        }
        if (SystemInfoRt.isWindows && index + 3 < url.length() && url.charAt(index + 3) == '/' && url.regionMatches(0, "file://", 0, "file://".length())) {
            char c;
            for (int i2 = index + 4; i2 < url.length() && (c = url.charAt(i2)) != '/'; ++i2) {
                if (c != ':') continue;
                String string = "file://" + url.substring(index + 4);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "toIdeaUrl"));
                }
                return string;
            }
            String string = url;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "toIdeaUrl"));
            }
            return string;
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "toIdeaUrl"));
        }
        return string;
    }

    @NotNull
    public static String fixURLforIDEA(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/VfsUtilCore", "fixURLforIDEA"));
        }
        String string = VfsUtilCore.toIdeaUrl(url, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "fixURLforIDEA"));
        }
        return string;
    }

    @NotNull
    public static String convertFromUrl(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/VfsUtilCore", "convertFromUrl"));
        }
        String protocol = url.getProtocol();
        String path2 = url.getPath();
        if (protocol.equals("jar")) {
            if (StringUtil.startsWithConcatenation((String)path2, (String[])new String[]{"file", PROTOCOL_DELIMITER})) {
                try {
                    URL subURL = new URL(path2);
                    path2 = subURL.getPath();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(VfsBundle.message("url.parse.unhandled.exception", new Object[0]), e);
                }
            } else {
                throw new RuntimeException(new IOException(VfsBundle.message("url.parse.error", url.toExternalForm())));
            }
        }
        if (SystemInfo.isWindows || SystemInfo.isOS2) {
            while (!path2.isEmpty() && path2.charAt(0) == '/') {
                path2 = path2.substring(1, path2.length());
            }
        }
        path2 = URLUtil.unescapePercentSequences((String)path2);
        String string = protocol + "://" + path2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "convertFromUrl"));
        }
        return string;
    }

    @Nullable
    public static URL convertToURL(@NotNull String vfsUrl) {
        if (vfsUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfsUrl", "com/intellij/openapi/vfs/VfsUtilCore", "convertToURL"));
        }
        if (vfsUrl.startsWith("jar://")) {
            try {
                return new URL("jar:file:///" + vfsUrl.substring("jar://".length()));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (vfsUrl.startsWith(MAILTO)) {
            try {
                return new URL(vfsUrl);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        String[] split = vfsUrl.split("://");
        if (split.length != 2) {
            LOG.debug("Malformed VFS URL: " + vfsUrl);
            return null;
        }
        String protocol = split[0];
        String path2 = split[1];
        try {
            if (protocol.equals("file")) {
                return new URL("file", "", path2);
            }
            return UrlClassLoader.internProtocol((URL)new URL(vfsUrl));
        }
        catch (MalformedURLException e) {
            LOG.debug("MalformedURLException occurred:" + e.getMessage());
            return null;
        }
    }

    @NotNull
    public static String fixIDEAUrl(@NotNull String ideaUrl) {
        if (ideaUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaUrl", "com/intellij/openapi/vfs/VfsUtilCore", "fixIDEAUrl"));
        }
        String ideaProtocolMarker = "://";
        int idx = ideaUrl.indexOf("://");
        if (idx >= 0) {
            String s = ideaUrl.substring(0, idx);
            if (s.equals("jar")) {
                s = "jar:file";
            }
            String urlWithoutProtocol = ideaUrl.substring(idx + "://".length());
            ideaUrl = s + PROTOCOL_DELIMITER + (urlWithoutProtocol.startsWith("/") ? "" : "/") + urlWithoutProtocol;
        }
        String string = ideaUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "fixIDEAUrl"));
        }
        return string;
    }

    @Nullable
    public static VirtualFile findRelativeFile(@NotNull String uri, @Nullable VirtualFile base) {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/openapi/vfs/VfsUtilCore", "findRelativeFile"));
        }
        if (base != null && !base.isValid()) {
            LOG.error("Invalid file name: " + base.getName() + ", url: " + uri);
        }
        if ((uri = uri.replace('\\', '/')).startsWith("file:///")) {
            uri = uri.substring("file:///".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
        } else if (uri.startsWith("file:/")) {
            uri = uri.substring("file:/".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
        } else {
            uri = StringUtil.trimStart((String)uri, (String)"file:");
        }
        VirtualFile file = null;
        if (uri.startsWith("jar:file:/")) {
            uri = uri.substring("jar:file:/".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
            file = VirtualFileManager.getInstance().findFileByUrl("jar://" + uri);
        } else if (!SystemInfo.isWindows && StringUtil.startsWithChar((CharSequence)uri, (char)'/') || SystemInfo.isWindows && uri.length() >= 2 && Character.isLetter(uri.charAt(0)) && uri.charAt(1) == ':') {
            file = StandardFileSystems.local().findFileByPath(uri);
        }
        if (file == null && uri.contains("!/") && (file = StandardFileSystems.jar().findFileByPath(uri)) == null && base == null) {
            file = VirtualFileManager.getInstance().findFileByUrl(uri);
        }
        if (file == null) {
            if (base == null) {
                return StandardFileSystems.local().findFileByPath(uri);
            }
            if (!base.isDirectory()) {
                base = base.getParent();
            }
            if (base == null) {
                return StandardFileSystems.local().findFileByPath(uri);
            }
            file = VirtualFileManager.getInstance().findFileByUrl(base.getUrl() + "/" + uri);
            if (file == null) {
                return null;
            }
        }
        return file;
    }

    public static boolean processFilesRecursively(final @NotNull VirtualFile root, final @NotNull Processor<VirtualFile> processor) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/vfs/VfsUtilCore", "processFilesRecursively"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vfs/VfsUtilCore", "processFilesRecursively"));
        }
        final Ref result = Ref.create((Object)true);
        VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore$2", "visitFileEx"));
                }
                if (!processor.process((Object)file)) {
                    result.set((Object)Boolean.FALSE);
                    VirtualFileVisitor.Result result2 = 2.skipTo(root);
                    if (result2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore$2", "visitFileEx"));
                    }
                    return result2;
                }
                VirtualFileVisitor.Result result3 = CONTINUE;
                if (result3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore$2", "visitFileEx"));
                }
                return result3;
            }
        });
        return (Boolean)result.get();
    }

    @Nullable
    public static VirtualFile getCommonAncestor(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/openapi/vfs/VfsUtilCore", "getCommonAncestor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/openapi/vfs/VfsUtilCore", "getCommonAncestor"));
        }
        if (!file1.getFileSystem().equals(file2.getFileSystem())) {
            return null;
        }
        VirtualFile[] path1 = VfsUtilCore.getPathComponents(file1);
        VirtualFile[] path2 = VfsUtilCore.getPathComponents(file2);
        int lastEqualIdx = -1;
        int i2 = 0;
        while (i2 < path1.length && i2 < path2.length && path1[i2].equals(path2[i2])) {
            lastEqualIdx = i2++;
        }
        return lastEqualIdx == -1 ? null : path1[lastEqualIdx];
    }

    @NotNull
    static VirtualFile[] getPathComponents(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtilCore", "getPathComponents"));
        }
        ArrayList<VirtualFile> componentsList = new ArrayList<VirtualFile>();
        while (file != null) {
            componentsList.add(file);
            file = file.getParent();
        }
        int size = componentsList.size();
        VirtualFile[] components = new VirtualFile[size];
        for (int i2 = 0; i2 < size; ++i2) {
            components[i2] = (VirtualFile)componentsList.get(size - i2 - 1);
        }
        if (components == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "getPathComponents"));
        }
        return components;
    }

    public static boolean hasInvalidFiles(@NotNull Iterable<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/VfsUtilCore", "hasInvalidFiles"));
        }
        for (VirtualFile file : files) {
            if (file.isValid()) continue;
            return true;
        }
        return false;
    }

    public static void processFilesRecursively(@NotNull VirtualFile root, @NotNull Processor<VirtualFile> processor, @NotNull Convertor<VirtualFile, Boolean> directoryFilter) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/vfs/VfsUtilCore", "processFilesRecursively"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vfs/VfsUtilCore", "processFilesRecursively"));
        }
        if (directoryFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryFilter", "com/intellij/openapi/vfs/VfsUtilCore", "processFilesRecursively"));
        }
        if (!processor.process((Object)root)) {
            return;
        }
        if (root.isDirectory() && ((Boolean)directoryFilter.convert((Object)root)).booleanValue()) {
            LinkedList<VirtualFile[]> queue = new LinkedList<VirtualFile[]>();
            queue.add(root.getChildren());
            do {
                VirtualFile[] files;
                for (VirtualFile file : files = (VirtualFile[])queue.removeFirst()) {
                    if (!processor.process((Object)file)) {
                        return;
                    }
                    if (!file.isDirectory() || !((Boolean)directoryFilter.convert((Object)file)).booleanValue()) continue;
                    queue.add(file.getChildren());
                }
            } while (!queue.isEmpty());
        }
    }

    public static class DistinctVFilesRootsCollection
    extends DistinctRootsCollection<VirtualFile> {
        public DistinctVFilesRootsCollection() {
        }

        public DistinctVFilesRootsCollection(Collection<VirtualFile> virtualFiles) {
            super(virtualFiles);
        }

        public DistinctVFilesRootsCollection(VirtualFile[] collection) {
            super((Object[])collection);
        }

        protected boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile virtualFile2) {
            if (ancestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/openapi/vfs/VfsUtilCore$DistinctVFilesRootsCollection", "isAncestor"));
            }
            if (virtualFile2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/VfsUtilCore$DistinctVFilesRootsCollection", "isAncestor"));
            }
            return VfsUtilCore.isAncestor(ancestor, virtualFile2, false);
        }
    }
}

