/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.presentation;

import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSelectSettingPresentation
extends CodeStyleSettingPresentation {
    @NotNull
    protected int[] myValues;
    @NotNull
    protected String[] myValueUiNames;
    protected int myLowerBound;
    protected int myUpperBound;

    public CodeStyleSelectSettingPresentation(@NotNull String fieldName, @NotNull String uiName, @NotNull int[] values, @NotNull String[] valueUiNames) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/psi/codeStyle/presentation/CodeStyleSelectSettingPresentation", "<init>"));
        }
        if (uiName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/psi/codeStyle/presentation/CodeStyleSelectSettingPresentation", "<init>"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/psi/codeStyle/presentation/CodeStyleSelectSettingPresentation", "<init>"));
        }
        if (valueUiNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueUiNames", "com/intellij/psi/codeStyle/presentation/CodeStyleSelectSettingPresentation", "<init>"));
        }
        super(fieldName, uiName);
        assert (values.length == valueUiNames.length);
        assert (values.length > 0);
        this.myValues = values;
        this.myValueUiNames = valueUiNames;
        this.myLowerBound = values[0];
        this.myUpperBound = values[0];
        for (int value : values) {
            this.myLowerBound = Math.min(value, this.myLowerBound);
            this.myUpperBound = Math.max(value, this.myUpperBound);
        }
    }

    @Override
    @NotNull
    public String getValueUiName(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/codeStyle/presentation/CodeStyleSelectSettingPresentation", "getValueUiName"));
        }
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            for (int i2 = 0; i2 < this.myValues.length; ++i2) {
                if (this.myValues[i2] != intValue) continue;
                String string = this.myValueUiNames[i2];
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/presentation/CodeStyleSelectSettingPresentation", "getValueUiName"));
                }
                return string;
            }
            String string = super.getValueUiName(value);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/presentation/CodeStyleSelectSettingPresentation", "getValueUiName"));
            }
            return string;
        }
        String string = super.getValueUiName(value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/presentation/CodeStyleSelectSettingPresentation", "getValueUiName"));
        }
        return string;
    }

    public int getLowerBound() {
        return this.myLowerBound;
    }

    public int getUpperBound() {
        return this.myUpperBound;
    }

    @NotNull
    public int[] getValues() {
        if (this.myValues == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/presentation/CodeStyleSelectSettingPresentation", "getValues"));
        }
        return this.myValues;
    }

    @NotNull
    public String[] getOptions() {
        if (this.myValueUiNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/presentation/CodeStyleSelectSettingPresentation", "getOptions"));
        }
        return this.myValueUiNames;
    }
}

