/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.codeInsight.hierarchy;

import com.intellij.codeInsight.CodeInsightTestCase;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyViewTestBase
extends CodeInsightTestCase {
    private static final String NODE_ELEMENT_NAME = "node";
    private static final String ANY_NODES_ELEMENT_NAME = "any";
    private static final String TEXT_ATTR_NAME = "text";
    private static final String BASE_ATTR_NAME = "base";

    protected abstract String getBasePath();

    protected void doHierarchyTest(Computable<HierarchyTreeStructure> treeStructureComputable, String ... fileNames) throws Exception {
        String[] relFilePaths = new String[fileNames.length];
        for (int i2 = 0; i2 < fileNames.length; ++i2) {
            relFilePaths[i2] = "/" + this.getBasePath() + "/" + fileNames[i2];
        }
        this.configureByFiles(null, relFilePaths);
        String verificationFilePath = this.getTestDataPath() + "/" + this.getBasePath() + "/" + this.getTestName(false) + "_verification.xml";
        HierarchyTreeStructure structure = (HierarchyTreeStructure)treeStructureComputable.compute();
        try {
            HierarchyViewTestBase.checkHierarchyTreeStructure(structure, JDOMUtil.load((File)new File(verificationFilePath)));
        }
        catch (Throwable e) {
            HierarchyViewTestBase.assertEquals((String)"XML structure comparison for your convenience, actual failure details BELOW", (String)FileUtil.loadFile((File)new File(verificationFilePath)), (String)HierarchyViewTestBase.dump(structure, null, 0));
            e.printStackTrace();
        }
    }

    private static String dump(HierarchyTreeStructure treeStructure, @Nullable HierarchyNodeDescriptor descriptor, int level) {
        StringBuilder s = new StringBuilder();
        HierarchyViewTestBase.dump(treeStructure, descriptor, level, s);
        return s.toString();
    }

    private static void dump(HierarchyTreeStructure treeStructure, @Nullable HierarchyNodeDescriptor descriptor, int level, StringBuilder b) {
        if (level > 10) {
            for (int i2 = 0; i2 < level; ++i2) {
                b.append("  ");
            }
            b.append("<Probably infinite part skipped>\n");
            return;
        }
        if (descriptor == null) {
            descriptor = (HierarchyNodeDescriptor)treeStructure.getRootElement();
        }
        for (int i3 = 0; i3 < level; ++i3) {
            b.append("  ");
        }
        descriptor.update();
        b.append("<node text=\"").append(descriptor.getHighlightedText().getText()).append("\"").append(treeStructure.getBaseDescriptor() == descriptor ? " base=\"true\"" : "");
        Object[] children = treeStructure.getChildElements((Object)descriptor);
        if (children.length > 0) {
            b.append(">\n");
            for (Object o : children) {
                HierarchyNodeDescriptor d = (HierarchyNodeDescriptor)o;
                HierarchyViewTestBase.dump(treeStructure, d, level + 1, b);
            }
            for (int i4 = 0; i4 < level; ++i4) {
                b.append("  ");
            }
            b.append("</node>\n");
        } else {
            b.append("/>\n");
        }
    }

    private static void checkHierarchyTreeStructure(HierarchyTreeStructure treeStructure, Element rootElement) {
        HierarchyNodeDescriptor rootNodeDescriptor = (HierarchyNodeDescriptor)treeStructure.getRootElement();
        rootNodeDescriptor.update();
        if (rootElement == null || !NODE_ELEMENT_NAME.equals(rootElement.getName())) {
            throw new IllegalArgumentException("Incorrect root element in verification resource");
        }
        HierarchyViewTestBase.checkNodeDescriptorRecursively(treeStructure, rootNodeDescriptor, rootElement);
    }

    private static void checkNodeDescriptorRecursively(HierarchyTreeStructure treeStructure, HierarchyNodeDescriptor descriptor, Element expectedElement) {
        HierarchyViewTestBase.checkBaseNode(treeStructure, descriptor, expectedElement);
        HierarchyViewTestBase.checkContent(descriptor, expectedElement);
        HierarchyViewTestBase.checkChildren(treeStructure, descriptor, expectedElement);
    }

    private static void checkBaseNode(HierarchyTreeStructure treeStructure, HierarchyNodeDescriptor descriptor, Element expectedElement) {
        String baseAttrValue = expectedElement.getAttributeValue(BASE_ATTR_NAME);
        HierarchyNodeDescriptor baseDescriptor = treeStructure.getBaseDescriptor();
        boolean mustBeBase = "true".equalsIgnoreCase(baseAttrValue);
        HierarchyViewTestBase.assertTrue((String)"Incorrect base node", (boolean)(mustBeBase ? baseDescriptor == descriptor : baseDescriptor != descriptor));
    }

    private static void checkContent(HierarchyNodeDescriptor descriptor, Element expectedElement) {
        HierarchyViewTestBase.assertEquals((String)expectedElement.getAttributeValue(TEXT_ATTR_NAME), (String)descriptor.getHighlightedText().getText());
    }

    private static void checkChildren(HierarchyTreeStructure treeStructure, HierarchyNodeDescriptor descriptor, Element element) {
        if (element.getChild(ANY_NODES_ELEMENT_NAME) != null) {
            return;
        }
        Object[] children = treeStructure.getChildElements((Object)descriptor);
        ArrayList expectedChildren = new ArrayList(element.getChildren(NODE_ELEMENT_NAME));
        StringBuilder messageBuilder = new StringBuilder("Actual children of [" + descriptor.getHighlightedText().getText() + "]:\n");
        for (Object child : children) {
            HierarchyNodeDescriptor nodeDescriptor = (HierarchyNodeDescriptor)child;
            nodeDescriptor.update();
            messageBuilder.append("    [").append(nodeDescriptor.getHighlightedText().getText()).append("]\n");
        }
        HierarchyViewTestBase.assertEquals((String)messageBuilder.toString(), (int)expectedChildren.size(), (int)children.length);
        Arrays.sort(children, (first, second) -> ((HierarchyNodeDescriptor)first).getHighlightedText().getText().compareTo(((HierarchyNodeDescriptor)second).getHighlightedText().getText()));
        Collections.sort(expectedChildren, (first, second) -> first.getAttributeValue(TEXT_ATTR_NAME).compareTo(second.getAttributeValue(TEXT_ATTR_NAME)));
        Iterator iterator = expectedChildren.iterator();
        for (Object child : children) {
            HierarchyViewTestBase.checkNodeDescriptorRecursively(treeStructure, (HierarchyNodeDescriptor)child, (Element)iterator.next());
        }
    }
}

