/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class IndexableSetContributor {
    public static final ExtensionPointName<IndexableSetContributor> EP_NAME = new ExtensionPointName("com.intellij.indexedRootsProvider");
    private static final Logger LOG = Logger.getInstance(IndexableSetContributor.class);

    @NotNull
    public static Set<VirtualFile> getProjectRootsToIndex(@NotNull IndexableSetContributor contributor, @NotNull Project project) {
        if (contributor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contributor", "com/intellij/util/indexing/IndexableSetContributor", "getProjectRootsToIndex"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/IndexableSetContributor", "getProjectRootsToIndex"));
        }
        Set<VirtualFile> roots = contributor.getAdditionalProjectRootsToIndex(project);
        Set<VirtualFile> set = IndexableSetContributor.filterOutNulls(contributor, "getAdditionalProjectRootsToIndex(Project)", roots);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "getProjectRootsToIndex"));
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getRootsToIndex(@NotNull IndexableSetContributor contributor) {
        if (contributor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contributor", "com/intellij/util/indexing/IndexableSetContributor", "getRootsToIndex"));
        }
        Set<VirtualFile> roots = contributor.getAdditionalRootsToIndex();
        Set<VirtualFile> set = IndexableSetContributor.filterOutNulls(contributor, "getAdditionalRootsToIndex()", roots);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "getRootsToIndex"));
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getAdditionalProjectRootsToIndex(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/IndexableSetContributor", "getAdditionalProjectRootsToIndex"));
        }
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "getAdditionalProjectRootsToIndex"));
        }
        return set;
    }

    @NotNull
    public abstract Set<VirtualFile> getAdditionalRootsToIndex();

    @NotNull
    private static Set<VirtualFile> filterOutNulls(@NotNull IndexableSetContributor contributor, @NotNull String methodInfo, @NotNull Set<VirtualFile> roots) {
        if (contributor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contributor", "com/intellij/util/indexing/IndexableSetContributor", "filterOutNulls"));
        }
        if (methodInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodInfo", "com/intellij/util/indexing/IndexableSetContributor", "filterOutNulls"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/indexing/IndexableSetContributor", "filterOutNulls"));
        }
        for (VirtualFile root : roots) {
            if (root != null && root.isValid()) continue;
            LOG.error("Please fix " + contributor.getClass().getName() + "#" + methodInfo + ".\n" + (root == null ? "The returned set is not expected to contain nulls, but it is " + roots : "Invalid file returned: " + root));
            LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet((Iterable)ContainerUtil.filter(roots, virtualFile2 -> virtualFile2 != null && virtualFile2.isValid()));
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "filterOutNulls"));
            }
            return linkedHashSet;
        }
        Set<VirtualFile> set = roots;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "filterOutNulls"));
        }
        return set;
    }
}

