/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.asp;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.asp.AspElementTypes;
import com.jetbrains.asp.AspLanguage;
import com.jetbrains.asp.AspTokenTypes;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AspFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private static final Set<Language> ourRelevantLanguages = new THashSet(Arrays.asList(new Language[]{HTMLLanguage.INSTANCE, AspLanguage.INSTANCE}));
    private static TemplateDataElementType ourTemplateDataType = new TemplateDataElementType("TEMPLATE_DATA in ASP", (Language)AspLanguage.INSTANCE, AspTokenTypes.TEMPLATE_DATA, AspElementTypes.ASP_OUTER_TYPE);

    public AspFileViewProvider(PsiManager manager, VirtualFile file, boolean physical) {
        super(manager, file, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        AspLanguage aspLanguage = AspLanguage.INSTANCE;
        if (aspLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/asp/AspFileViewProvider", "getBaseLanguage"));
        }
        return aspLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = ourRelevantLanguages;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/asp/AspFileViewProvider", "getLanguages"));
        }
        return set;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        HTMLLanguage hTMLLanguage = HTMLLanguage.INSTANCE;
        if (hTMLLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/asp/AspFileViewProvider", "getTemplateDataLanguage"));
        }
        return hTMLLanguage;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/jetbrains/asp/AspFileViewProvider", "createFile"));
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)ourTemplateDataType);
            return file;
        }
        if (lang == this.getBaseLanguage()) {
            return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
        }
        return null;
    }

    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(VirtualFile virtualFile) {
        return new AspFileViewProvider(this.getManager(), virtualFile, false);
    }
}

